/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.companion.virtual.IVirtualDevice;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;

public class VirtualDevice
implements Parcelable {
    @NonNull
    private final IVirtualDevice mVirtualDevice;
    private final int mId;
    @Nullable
    private final String mPersistentId;
    @Nullable
    private final String mName;
    @Nullable
    private final CharSequence mDisplayName;
    @NonNull
    public static final Parcelable.Creator<VirtualDevice> CREATOR = new Parcelable.Creator<VirtualDevice>(){

        @Override
        public VirtualDevice createFromParcel(Parcel in) {
            return new VirtualDevice(in);
        }

        public VirtualDevice[] newArray(int size) {
            return new VirtualDevice[size];
        }
    };

    public VirtualDevice(@NonNull IVirtualDevice virtualDevice, int id2, @Nullable String persistentId, @Nullable String name) {
        this(virtualDevice, id2, persistentId, name, null);
    }

    public VirtualDevice(@NonNull IVirtualDevice virtualDevice, int id2, @Nullable String persistentId, @Nullable String name, @Nullable CharSequence displayName) {
        if (id2 <= 0) {
            throw new IllegalArgumentException("VirtualDevice ID must be greater than 0");
        }
        this.mVirtualDevice = virtualDevice;
        this.mId = id2;
        this.mPersistentId = persistentId;
        this.mName = name;
        this.mDisplayName = displayName;
    }

    private VirtualDevice(@NonNull Parcel parcel) {
        this.mVirtualDevice = IVirtualDevice.Stub.asInterface(parcel.readStrongBinder());
        this.mId = parcel.readInt();
        this.mPersistentId = parcel.readString8();
        this.mName = parcel.readString8();
        this.mDisplayName = parcel.readCharSequence();
    }

    public int getDeviceId() {
        return this.mId;
    }

    @Nullable
    public String getPersistentDeviceId() {
        return this.mPersistentId;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    @Nullable
    public CharSequence getDisplayName() {
        return this.mDisplayName;
    }

    @NonNull
    public int[] getDisplayIds() {
        try {
            return this.mVirtualDevice.getDisplayIds();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean hasCustomSensorSupport() {
        try {
            return this.mVirtualDevice.getDevicePolicy(0) == 1;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public boolean hasCustomAudioInputSupport() {
        try {
            return this.mVirtualDevice.hasCustomAudioInputSupport();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public boolean hasCustomCameraSupport() {
        try {
            return this.mVirtualDevice.getDevicePolicy(5) == 1;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeStrongBinder(this.mVirtualDevice.asBinder());
        dest.writeInt(this.mId);
        dest.writeString8(this.mPersistentId);
        dest.writeString8(this.mName);
        dest.writeCharSequence(this.mDisplayName);
    }

    @NonNull
    public String toString() {
        return "VirtualDevice( mId=" + this.mId + " mPersistentId=" + this.mPersistentId + " mName=" + this.mName + " mDisplayName=" + this.mDisplayName + ")";
    }
}

