/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual;

import android.annotation.EnforcePermission;
import android.app.ActivityThread;
import android.companion.virtual.IVirtualDevice;
import android.companion.virtual.IVirtualDeviceActivityListener;
import android.companion.virtual.IVirtualDeviceListener;
import android.companion.virtual.IVirtualDeviceSoundEffectListener;
import android.companion.virtual.VirtualDevice;
import android.companion.virtual.VirtualDeviceParams;
import android.content.AttributionSource;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

public interface IVirtualDeviceManager
extends IInterface {
    public static final String DESCRIPTOR = "android.companion.virtual.IVirtualDeviceManager";

    @EnforcePermission(value="android.permission.CREATE_VIRTUAL_DEVICE")
    public IVirtualDevice createVirtualDevice(IBinder var1, AttributionSource var2, int var3, VirtualDeviceParams var4, IVirtualDeviceActivityListener var5, IVirtualDeviceSoundEffectListener var6) throws RemoteException;

    @EnforcePermission(value="android.permission.ACCESS_COMPUTER_CONTROL")
    public IVirtualDevice createLocalVirtualDevice(IBinder var1, AttributionSource var2, VirtualDeviceParams var3, IVirtualDeviceActivityListener var4, IVirtualDeviceSoundEffectListener var5) throws RemoteException;

    public List<VirtualDevice> getVirtualDevices() throws RemoteException;

    public VirtualDevice getVirtualDevice(int var1) throws RemoteException;

    public void registerVirtualDeviceListener(IVirtualDeviceListener var1) throws RemoteException;

    public void unregisterVirtualDeviceListener(IVirtualDeviceListener var1) throws RemoteException;

    public int getDeviceIdForDisplayId(int var1) throws RemoteException;

    public CharSequence getDisplayNameForPersistentDeviceId(String var1) throws RemoteException;

    public boolean isValidVirtualDeviceId(int var1) throws RemoteException;

    public int getDevicePolicy(int var1, int var2) throws RemoteException;

    public int getAudioPlaybackSessionId(int var1) throws RemoteException;

    public int getAudioRecordingSessionId(int var1) throws RemoteException;

    public void playSoundEffect(int var1, int var2) throws RemoteException;

    public boolean isVirtualDeviceOwnedMirrorDisplay(int var1) throws RemoteException;

    public List<String> getAllPersistentDeviceIds() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVirtualDeviceManager {
        private final PermissionEnforcer mEnforcer;
        static final int TRANSACTION_createVirtualDevice = 1;
        static final int TRANSACTION_createLocalVirtualDevice = 2;
        static final int TRANSACTION_getVirtualDevices = 3;
        static final int TRANSACTION_getVirtualDevice = 4;
        static final int TRANSACTION_registerVirtualDeviceListener = 5;
        static final int TRANSACTION_unregisterVirtualDeviceListener = 6;
        static final int TRANSACTION_getDeviceIdForDisplayId = 7;
        static final int TRANSACTION_getDisplayNameForPersistentDeviceId = 8;
        static final int TRANSACTION_isValidVirtualDeviceId = 9;
        static final int TRANSACTION_getDevicePolicy = 10;
        static final int TRANSACTION_getAudioPlaybackSessionId = 11;
        static final int TRANSACTION_getAudioRecordingSessionId = 12;
        static final int TRANSACTION_playSoundEffect = 13;
        static final int TRANSACTION_isVirtualDeviceOwnedMirrorDisplay = 14;
        static final int TRANSACTION_getAllPersistentDeviceIds = 15;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, IVirtualDeviceManager.DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentSystemContext()));
        }

        public static IVirtualDeviceManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IVirtualDeviceManager.DESCRIPTOR);
            if (iin != null && iin instanceof IVirtualDeviceManager) {
                return (IVirtualDeviceManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "createVirtualDevice";
                }
                case 2: {
                    return "createLocalVirtualDevice";
                }
                case 3: {
                    return "getVirtualDevices";
                }
                case 4: {
                    return "getVirtualDevice";
                }
                case 5: {
                    return "registerVirtualDeviceListener";
                }
                case 6: {
                    return "unregisterVirtualDeviceListener";
                }
                case 7: {
                    return "getDeviceIdForDisplayId";
                }
                case 8: {
                    return "getDisplayNameForPersistentDeviceId";
                }
                case 9: {
                    return "isValidVirtualDeviceId";
                }
                case 10: {
                    return "getDevicePolicy";
                }
                case 11: {
                    return "getAudioPlaybackSessionId";
                }
                case 12: {
                    return "getAudioRecordingSessionId";
                }
                case 13: {
                    return "playSoundEffect";
                }
                case 14: {
                    return "isVirtualDeviceOwnedMirrorDisplay";
                }
                case 15: {
                    return "getAllPersistentDeviceIds";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IVirtualDeviceManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IBinder _arg0 = data.readStrongBinder();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    int _arg2 = data.readInt();
                    VirtualDeviceParams _arg3 = data.readTypedObject(VirtualDeviceParams.CREATOR);
                    IVirtualDeviceActivityListener _arg4 = IVirtualDeviceActivityListener.Stub.asInterface(data.readStrongBinder());
                    IVirtualDeviceSoundEffectListener _arg5 = IVirtualDeviceSoundEffectListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    IVirtualDevice _result = this.createVirtualDevice(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 2: {
                    IBinder _arg0 = data.readStrongBinder();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    VirtualDeviceParams _arg2 = data.readTypedObject(VirtualDeviceParams.CREATOR);
                    IVirtualDeviceActivityListener _arg3 = IVirtualDeviceActivityListener.Stub.asInterface(data.readStrongBinder());
                    IVirtualDeviceSoundEffectListener _arg4 = IVirtualDeviceSoundEffectListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    IVirtualDevice _result = this.createLocalVirtualDevice(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 3: {
                    List<VirtualDevice> _result = this.getVirtualDevices();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    VirtualDevice _result = this.getVirtualDevice(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 5: {
                    IVirtualDeviceListener _arg0 = IVirtualDeviceListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerVirtualDeviceListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    IVirtualDeviceListener _arg0 = IVirtualDeviceListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterVirtualDeviceListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getDeviceIdForDisplayId(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    CharSequence _result = this.getDisplayNameForPersistentDeviceId(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        TextUtils.writeToParcel(_result, reply, 1);
                        break;
                    }
                    reply.writeInt(0);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isValidVirtualDeviceId(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getDevicePolicy(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getAudioPlaybackSessionId(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getAudioRecordingSessionId(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.playSoundEffect(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isVirtualDeviceOwnedMirrorDisplay(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 15: {
                    List<String> _result = this.getAllPersistentDeviceIds();
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void createVirtualDevice_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.CREATE_VIRTUAL_DEVICE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void createLocalVirtualDevice_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.ACCESS_COMPUTER_CONTROL", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 14;
        }

        private static class Proxy
        implements IVirtualDeviceManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IVirtualDeviceManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IVirtualDevice createVirtualDevice(IBinder token, AttributionSource attributionSource, int associationId, VirtualDeviceParams params, IVirtualDeviceActivityListener activityListener, IVirtualDeviceSoundEffectListener soundEffectListener) throws RemoteException {
                IVirtualDevice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeInt(associationId);
                    _data.writeTypedObject(params, 0);
                    _data.writeStrongInterface(activityListener);
                    _data.writeStrongInterface(soundEffectListener);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = IVirtualDevice.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IVirtualDevice createLocalVirtualDevice(IBinder token, AttributionSource attributionSource, VirtualDeviceParams params, IVirtualDeviceActivityListener activityListener, IVirtualDeviceSoundEffectListener soundEffectListener) throws RemoteException {
                IVirtualDevice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(params, 0);
                    _data.writeStrongInterface(activityListener);
                    _data.writeStrongInterface(soundEffectListener);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = IVirtualDevice.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<VirtualDevice> getVirtualDevices() throws RemoteException {
                ArrayList<VirtualDevice> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(VirtualDevice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VirtualDevice getVirtualDevice(int deviceId) throws RemoteException {
                VirtualDevice _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(VirtualDevice.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerVirtualDeviceListener(IVirtualDeviceListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterVirtualDeviceListener(IVirtualDeviceListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDeviceIdForDisplayId(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CharSequence getDisplayNameForPersistentDeviceId(String persistentDeviceId) throws RemoteException {
                CharSequence _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    _data.writeString(persistentDeviceId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isValidVirtualDeviceId(int deviceId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDevicePolicy(int deviceId, int policyType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeInt(policyType);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAudioPlaybackSessionId(int deviceId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getAudioRecordingSessionId(int deviceId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playSoundEffect(int deviceId, int effectType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    _data.writeInt(effectType);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isVirtualDeviceOwnedMirrorDisplay(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getAllPersistentDeviceIds() throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IVirtualDeviceManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IVirtualDeviceManager {
        @Override
        public IVirtualDevice createVirtualDevice(IBinder token, AttributionSource attributionSource, int associationId, VirtualDeviceParams params, IVirtualDeviceActivityListener activityListener, IVirtualDeviceSoundEffectListener soundEffectListener) throws RemoteException {
            return null;
        }

        @Override
        public IVirtualDevice createLocalVirtualDevice(IBinder token, AttributionSource attributionSource, VirtualDeviceParams params, IVirtualDeviceActivityListener activityListener, IVirtualDeviceSoundEffectListener soundEffectListener) throws RemoteException {
            return null;
        }

        @Override
        public List<VirtualDevice> getVirtualDevices() throws RemoteException {
            return null;
        }

        @Override
        public VirtualDevice getVirtualDevice(int deviceId) throws RemoteException {
            return null;
        }

        @Override
        public void registerVirtualDeviceListener(IVirtualDeviceListener listener) throws RemoteException {
        }

        @Override
        public void unregisterVirtualDeviceListener(IVirtualDeviceListener listener) throws RemoteException {
        }

        @Override
        public int getDeviceIdForDisplayId(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public CharSequence getDisplayNameForPersistentDeviceId(String persistentDeviceId) throws RemoteException {
            return null;
        }

        @Override
        public boolean isValidVirtualDeviceId(int deviceId) throws RemoteException {
            return false;
        }

        @Override
        public int getDevicePolicy(int deviceId, int policyType) throws RemoteException {
            return 0;
        }

        @Override
        public int getAudioPlaybackSessionId(int deviceId) throws RemoteException {
            return 0;
        }

        @Override
        public int getAudioRecordingSessionId(int deviceId) throws RemoteException {
            return 0;
        }

        @Override
        public void playSoundEffect(int deviceId, int effectType) throws RemoteException {
        }

        @Override
        public boolean isVirtualDeviceOwnedMirrorDisplay(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public List<String> getAllPersistentDeviceIds() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

