/*
 * Decompiled with CFR 0.152.
 */
package android.companion.datatransfer.continuity;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.graphics.drawable.Icon;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="android.companion.enable_task_continuity")
public class RemoteTask
implements Parcelable {
    private final int mId;
    private final int mDeviceId;
    @NonNull
    private final String mLabel;
    private final boolean mIsHandoffEnabled;
    @NonNull
    private final String mSourceDeviceName;
    private final int mLastUsedTimestampMillis;
    @Nullable
    private final Icon mIcon;
    @NonNull
    public static final Parcelable.Creator<RemoteTask> CREATOR = new Parcelable.Creator<RemoteTask>(){

        @Override
        public RemoteTask createFromParcel(Parcel in) {
            return new RemoteTask(in);
        }

        public RemoteTask[] newArray(int size) {
            return new RemoteTask[size];
        }
    };

    RemoteTask(@NonNull Builder builder) {
        this.mId = builder.mId;
        this.mDeviceId = builder.mDeviceId;
        this.mLabel = builder.mLabel;
        this.mIcon = builder.mIcon;
        this.mIsHandoffEnabled = builder.mIsHandoffEnabled;
        this.mSourceDeviceName = builder.mSourceDeviceName;
        this.mLastUsedTimestampMillis = builder.mLastUsedTimestampMillis;
    }

    RemoteTask(@NonNull Parcel in) {
        this.mId = in.readInt();
        this.mDeviceId = in.readInt();
        this.mLabel = in.readString();
        this.mIsHandoffEnabled = in.readBoolean();
        this.mSourceDeviceName = in.readString();
        this.mLastUsedTimestampMillis = in.readInt();
        this.mIcon = in.readInt() != 0 ? in.readParcelable(Icon.class.getClassLoader(), Icon.class) : null;
    }

    public int getId() {
        return this.mId;
    }

    public int getDeviceId() {
        return this.mDeviceId;
    }

    @NonNull
    public String getLabel() {
        return this.mLabel;
    }

    @Nullable
    public Icon getIcon() {
        return this.mIcon;
    }

    public boolean isHandoffEnabled() {
        return this.mIsHandoffEnabled;
    }

    @NonNull
    public String getSourceDeviceName() {
        return this.mSourceDeviceName;
    }

    public int getLastUsedTimestampMillis() {
        return this.mLastUsedTimestampMillis;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mDeviceId, this.mLabel, this.mIcon, this.mIsHandoffEnabled, this.mSourceDeviceName, this.mLastUsedTimestampMillis);
    }

    public boolean equals(Object o) {
        if (o instanceof RemoteTask) {
            RemoteTask other = (RemoteTask)o;
            return this.mId == other.mId && this.mDeviceId == other.mDeviceId && Objects.equals(this.mLabel, other.mLabel) && (this.mIcon == null ? other.mIcon == null : this.mIcon.sameAs(other.mIcon)) && this.mIsHandoffEnabled == other.mIsHandoffEnabled && this.mLastUsedTimestampMillis == other.mLastUsedTimestampMillis && Objects.equals(this.mSourceDeviceName, other.mSourceDeviceName);
        }
        return false;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeInt(this.mDeviceId);
        dest.writeString8(this.mLabel);
        dest.writeBoolean(this.mIsHandoffEnabled);
        dest.writeString8(this.mSourceDeviceName);
        dest.writeInt(this.mLastUsedTimestampMillis);
        if (this.mIcon != null) {
            dest.writeInt(1);
            this.mIcon.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
    }

    public static class Builder {
        private int mId = 0;
        private int mDeviceId = 0;
        @NonNull
        private String mLabel = "";
        @Nullable
        private Icon mIcon = null;
        private boolean mIsHandoffEnabled = false;
        @NonNull
        private String mSourceDeviceName = "";
        private int mLastUsedTimestampMillis = 0;

        public Builder(int id2) {
            this.mId = id2;
        }

        @NonNull
        public Builder setLabel(@NonNull String label) {
            this.mLabel = label;
            return this;
        }

        @NonNull
        public Builder setIcon(@Nullable Icon icon) {
            this.mIcon = icon;
            return this;
        }

        @NonNull
        public Builder setDeviceId(int deviceId) {
            this.mDeviceId = deviceId;
            return this;
        }

        @NonNull
        public Builder setHandoffEnabled(boolean isHandoffEnabled) {
            this.mIsHandoffEnabled = isHandoffEnabled;
            return this;
        }

        @NonNull
        public Builder setSourceDeviceName(@NonNull String sourceDeviceName) {
            this.mSourceDeviceName = sourceDeviceName;
            return this;
        }

        @NonNull
        public Builder setLastUsedTimestampMillis(int lastUsedTimestampMillis) {
            this.mLastUsedTimestampMillis = lastUsedTimestampMillis;
            return this;
        }

        @NonNull
        public RemoteTask build() {
            return new RemoteTask(this);
        }
    }
}

