/*
 * Decompiled with CFR 0.152.
 */
package android.companion.datatransfer.continuity;

import android.companion.datatransfer.continuity.IHandoffRequestCallback;
import android.companion.datatransfer.continuity.IRemoteTaskListener;
import android.companion.datatransfer.continuity.RemoteTask;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface ITaskContinuityManager
extends IInterface {
    public static final String DESCRIPTOR = "android.companion.datatransfer.continuity.ITaskContinuityManager";

    public List<RemoteTask> getRemoteTasks() throws RemoteException;

    public void registerRemoteTaskListener(IRemoteTaskListener var1) throws RemoteException;

    public void unregisterRemoteTaskListener(IRemoteTaskListener var1) throws RemoteException;

    public void requestHandoff(int var1, int var2, IHandoffRequestCallback var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITaskContinuityManager {
        static final int TRANSACTION_getRemoteTasks = 1;
        static final int TRANSACTION_registerRemoteTaskListener = 2;
        static final int TRANSACTION_unregisterRemoteTaskListener = 3;
        static final int TRANSACTION_requestHandoff = 4;

        public Stub() {
            this.attachInterface(this, ITaskContinuityManager.DESCRIPTOR);
        }

        public static ITaskContinuityManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITaskContinuityManager.DESCRIPTOR);
            if (iin != null && iin instanceof ITaskContinuityManager) {
                return (ITaskContinuityManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getRemoteTasks";
                }
                case 2: {
                    return "registerRemoteTaskListener";
                }
                case 3: {
                    return "unregisterRemoteTaskListener";
                }
                case 4: {
                    return "requestHandoff";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITaskContinuityManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    List<RemoteTask> _result = this.getRemoteTasks();
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 2: {
                    IRemoteTaskListener _arg0 = IRemoteTaskListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerRemoteTaskListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    IRemoteTaskListener _arg0 = IRemoteTaskListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterRemoteTaskListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    IHandoffRequestCallback _arg2 = IHandoffRequestCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.requestHandoff(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements ITaskContinuityManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITaskContinuityManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<RemoteTask> getRemoteTasks() throws RemoteException {
                ArrayList<RemoteTask> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskContinuityManager.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(RemoteTask.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerRemoteTaskListener(IRemoteTaskListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskContinuityManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterRemoteTaskListener(IRemoteTaskListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskContinuityManager.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestHandoff(int associationId, int remoteTaskId, IHandoffRequestCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskContinuityManager.DESCRIPTOR);
                    _data.writeInt(associationId);
                    _data.writeInt(remoteTaskId);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITaskContinuityManager {
        @Override
        public List<RemoteTask> getRemoteTasks() throws RemoteException {
            return null;
        }

        @Override
        public void registerRemoteTaskListener(IRemoteTaskListener listener) throws RemoteException {
        }

        @Override
        public void unregisterRemoteTaskListener(IRemoteTaskListener listener) throws RemoteException {
        }

        @Override
        public void requestHandoff(int associationId, int remoteTaskId, IHandoffRequestCallback callback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

