/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.app.PendingIntent;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.IPeriodicAdvertisingCallback;
import android.bluetooth.le.IScannerCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.AttributionSource;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.WorkSource;
import java.util.ArrayList;
import java.util.List;

public interface IBluetoothScan
extends IInterface {
    public static final String DESCRIPTOR = "android.bluetooth.IBluetoothScan";

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void registerScanner(IScannerCallback var1, WorkSource var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void unregisterScanner(int var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void startScan(int var1, ScanSettings var2, List<ScanFilter> var3, AttributionSource var4) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void registerPiAndStartScan(PendingIntent var1, ScanSettings var2, List<ScanFilter> var3, AttributionSource var4) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void stopScan(int var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void stopScanForIntent(PendingIntent var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void flushPendingBatchResults(int var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void registerSync(ScanResult var1, int var2, int var3, IPeriodicAdvertisingCallback var4, AttributionSource var5) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void unregisterSync(IPeriodicAdvertisingCallback var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void transferSync(BluetoothDevice var1, int var2, int var3, AttributionSource var4) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void transferSetInfo(BluetoothDevice var1, int var2, int var3, IPeriodicAdvertisingCallback var4, AttributionSource var5) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public int numHwTrackFiltersAvailable(AttributionSource var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothScan {
        static final int TRANSACTION_registerScanner = 1;
        static final int TRANSACTION_unregisterScanner = 2;
        static final int TRANSACTION_startScan = 3;
        static final int TRANSACTION_registerPiAndStartScan = 4;
        static final int TRANSACTION_stopScan = 5;
        static final int TRANSACTION_stopScanForIntent = 6;
        static final int TRANSACTION_flushPendingBatchResults = 7;
        static final int TRANSACTION_registerSync = 8;
        static final int TRANSACTION_unregisterSync = 9;
        static final int TRANSACTION_transferSync = 10;
        static final int TRANSACTION_transferSetInfo = 11;
        static final int TRANSACTION_numHwTrackFiltersAvailable = 12;

        public Stub() {
            this.attachInterface(this, IBluetoothScan.DESCRIPTOR);
        }

        public static IBluetoothScan asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBluetoothScan.DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothScan) {
                return (IBluetoothScan)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "registerScanner";
                }
                case 2: {
                    return "unregisterScanner";
                }
                case 3: {
                    return "startScan";
                }
                case 4: {
                    return "registerPiAndStartScan";
                }
                case 5: {
                    return "stopScan";
                }
                case 6: {
                    return "stopScanForIntent";
                }
                case 7: {
                    return "flushPendingBatchResults";
                }
                case 8: {
                    return "registerSync";
                }
                case 9: {
                    return "unregisterSync";
                }
                case 10: {
                    return "transferSync";
                }
                case 11: {
                    return "transferSetInfo";
                }
                case 12: {
                    return "numHwTrackFiltersAvailable";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBluetoothScan.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IScannerCallback _arg0 = IScannerCallback.Stub.asInterface(data.readStrongBinder());
                    WorkSource _arg1 = data.readTypedObject(WorkSource.CREATOR);
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.registerScanner(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.unregisterScanner(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    ScanSettings _arg1 = data.readTypedObject(ScanSettings.CREATOR);
                    ArrayList<ScanFilter> _arg2 = data.createTypedArrayList(ScanFilter.CREATOR);
                    AttributionSource _arg3 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.startScan(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    PendingIntent _arg0 = data.readTypedObject(PendingIntent.CREATOR);
                    ScanSettings _arg1 = data.readTypedObject(ScanSettings.CREATOR);
                    ArrayList<ScanFilter> _arg2 = data.createTypedArrayList(ScanFilter.CREATOR);
                    AttributionSource _arg3 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.registerPiAndStartScan(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.stopScan(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    PendingIntent _arg0 = data.readTypedObject(PendingIntent.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.stopScanForIntent(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.flushPendingBatchResults(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    ScanResult _arg0 = data.readTypedObject(ScanResult.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    IPeriodicAdvertisingCallback _arg3 = IPeriodicAdvertisingCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg4 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.registerSync(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    IPeriodicAdvertisingCallback _arg0 = IPeriodicAdvertisingCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.unregisterSync(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    AttributionSource _arg3 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.transferSync(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    IPeriodicAdvertisingCallback _arg3 = IPeriodicAdvertisingCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg4 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.transferSetInfo(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.numHwTrackFiltersAvailable(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 11;
        }

        private static class Proxy
        implements IBluetoothScan {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBluetoothScan.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerScanner(IScannerCallback callback, WorkSource workSource, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothScan.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedObject(workSource, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterScanner(int scannerId, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothScan.DESCRIPTOR);
                    _data.writeInt(scannerId);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startScan(int scannerId, ScanSettings settings, List<ScanFilter> filters, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothScan.DESCRIPTOR);
                    _data.writeInt(scannerId);
                    _data.writeTypedObject(settings, 0);
                    _data.writeTypedList(filters, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerPiAndStartScan(PendingIntent intent, ScanSettings settings, List<ScanFilter> filters, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothScan.DESCRIPTOR);
                    _data.writeTypedObject(intent, 0);
                    _data.writeTypedObject(settings, 0);
                    _data.writeTypedList(filters, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopScan(int scannerId, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothScan.DESCRIPTOR);
                    _data.writeInt(scannerId);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopScanForIntent(PendingIntent intent, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothScan.DESCRIPTOR);
                    _data.writeTypedObject(intent, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void flushPendingBatchResults(int scannerId, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothScan.DESCRIPTOR);
                    _data.writeInt(scannerId);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSync(ScanResult scanResult, int skip, int timeout, IPeriodicAdvertisingCallback callback, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothScan.DESCRIPTOR);
                    _data.writeTypedObject(scanResult, 0);
                    _data.writeInt(skip);
                    _data.writeInt(timeout);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSync(IPeriodicAdvertisingCallback callback, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothScan.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void transferSync(BluetoothDevice bda, int serviceData, int syncHandle, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothScan.DESCRIPTOR);
                    _data.writeTypedObject(bda, 0);
                    _data.writeInt(serviceData);
                    _data.writeInt(syncHandle);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void transferSetInfo(BluetoothDevice bda, int serviceData, int advertisingHandle, IPeriodicAdvertisingCallback callback, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothScan.DESCRIPTOR);
                    _data.writeTypedObject(bda, 0);
                    _data.writeInt(serviceData);
                    _data.writeInt(advertisingHandle);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int numHwTrackFiltersAvailable(AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothScan.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IBluetoothScan {
        @Override
        public void registerScanner(IScannerCallback callback, WorkSource workSource, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void unregisterScanner(int scannerId, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void startScan(int scannerId, ScanSettings settings, List<ScanFilter> filters, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void registerPiAndStartScan(PendingIntent intent, ScanSettings settings, List<ScanFilter> filters, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void stopScan(int scannerId, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void stopScanForIntent(PendingIntent intent, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void flushPendingBatchResults(int scannerId, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void registerSync(ScanResult scanResult, int skip, int timeout, IPeriodicAdvertisingCallback callback, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void unregisterSync(IPeriodicAdvertisingCallback callback, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void transferSync(BluetoothDevice bda, int serviceData, int syncHandle, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void transferSetInfo(BluetoothDevice bda, int serviceData, int advertisingHandle, IPeriodicAdvertisingCallback callback, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public int numHwTrackFiltersAvailable(AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

