/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.bluetooth.BluetoothUtils;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class CallbackWrapper<T, S> {
    @GuardedBy(value={"mCallbackExecutorMap"})
    private final Map<T, Executor> mCallbackExecutorMap;
    private final Consumer<S> mRegisterConsumer;
    private final Consumer<S> mUnregisterConsumer;

    CallbackWrapper(Consumer<S> registerConsumer, Consumer<S> unregisterConsumer) {
        this(registerConsumer, unregisterConsumer, new HashMap());
    }

    @VisibleForTesting
    public CallbackWrapper(Consumer<S> registerConsumer, Consumer<S> unregisterConsumer, Map<T, Executor> map) {
        this.mRegisterConsumer = Objects.requireNonNull(registerConsumer);
        this.mUnregisterConsumer = Objects.requireNonNull(unregisterConsumer);
        this.mCallbackExecutorMap = Objects.requireNonNull(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(Consumer<T> consumer) {
        Map<T, Executor> map = this.mCallbackExecutorMap;
        synchronized (map) {
            this.mCallbackExecutorMap.forEach((? super K callback, ? super V executor) -> BluetoothUtils.executeFromBinder(executor, () -> consumer.accept(callback)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public void registerCallback(@Nullable S service, @NonNull T callback, @NonNull Executor executor) {
        Objects.requireNonNull(callback);
        Objects.requireNonNull(executor);
        Map<T, Executor> map = this.mCallbackExecutorMap;
        synchronized (map) {
            if (this.mCallbackExecutorMap.containsKey(callback)) {
                throw new IllegalArgumentException("Callback already registered");
            }
            if (service != null && this.mCallbackExecutorMap.isEmpty()) {
                this.mRegisterConsumer.accept(service);
            }
            this.mCallbackExecutorMap.put(callback, executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public void unregisterCallback(@Nullable S service, @NonNull T callback) {
        Objects.requireNonNull(callback);
        Map<T, Executor> map = this.mCallbackExecutorMap;
        synchronized (map) {
            if (!this.mCallbackExecutorMap.containsKey(callback)) {
                throw new IllegalArgumentException("Callback already unregistered");
            }
            this.mCallbackExecutorMap.remove(callback);
            if (service != null && this.mCallbackExecutorMap.isEmpty()) {
                this.mUnregisterConsumer.accept(service);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerToNewService(@NonNull S service) {
        Objects.requireNonNull(service);
        Map<T, Executor> map = this.mCallbackExecutorMap;
        synchronized (map) {
            if (!this.mCallbackExecutorMap.isEmpty()) {
                this.mRegisterConsumer.accept(service);
            }
        }
    }
}

