/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.NonNull;
import android.annotation.RequiresNoPermission;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class BluetoothSocketException
extends IOException {
    public static final int UNSPECIFIED = 0;
    public static final int L2CAP_UNKNOWN = 1;
    public static final int L2CAP_ACL_FAILURE = 2;
    public static final int L2CAP_CLIENT_SECURITY_FAILURE = 3;
    public static final int L2CAP_INSUFFICIENT_AUTHENTICATION = 4;
    public static final int L2CAP_INSUFFICIENT_AUTHORIZATION = 5;
    public static final int L2CAP_INSUFFICIENT_ENCRYPT_KEY_SIZE = 6;
    public static final int L2CAP_INSUFFICIENT_ENCRYPTION = 7;
    public static final int L2CAP_INVALID_SOURCE_CID = 8;
    public static final int L2CAP_SOURCE_CID_ALREADY_ALLOCATED = 9;
    public static final int L2CAP_UNACCEPTABLE_PARAMETERS = 10;
    public static final int L2CAP_INVALID_PARAMETERS = 11;
    public static final int L2CAP_NO_RESOURCES = 12;
    public static final int L2CAP_NO_PSM_AVAILABLE = 13;
    public static final int L2CAP_TIMEOUT = 14;
    public static final int BLUETOOTH_OFF_FAILURE = 15;
    public static final int SOCKET_MANAGER_FAILURE = 16;
    public static final int SOCKET_CLOSED = 17;
    public static final int SOCKET_CONNECTION_FAILURE = 18;
    public static final int NULL_DEVICE = 19;
    public static final int RPC_FAILURE = 20;
    public static final int UNIX_FILE_SOCKET_CREATION_FAILURE = 21;
    private static final String UNSPECIFIED_MSG = "A Bluetooth Socket failure occurred";
    private static final String L2CAP_UNKNOWN_MSG = "Connection failed for unknown reason";
    private static final String L2CAP_ACL_FAILURE_MSG = "ACL connection failed";
    private static final String L2CAP_CLIENT_SECURITY_FAILURE_MSG = "Client security clearance failed";
    private static final String L2CAP_INSUFFICIENT_AUTHENTICATION_MSG = "Insufficient authentication";
    private static final String L2CAP_INSUFFICIENT_AUTHORIZATION_MSG = "Insufficient authorization";
    private static final String L2CAP_INSUFFICIENT_ENCRYPT_KEY_SIZE_MSG = "Insufficient encryption key size";
    private static final String L2CAP_INSUFFICIENT_ENCRYPTION_MSG = "Insufficient encryption";
    private static final String L2CAP_INVALID_SOURCE_CID_MSG = "Invalid source CID";
    private static final String L2CAP_SOURCE_CID_ALREADY_ALLOCATED_MSG = "Source CID already allocated";
    private static final String L2CAP_UNACCEPTABLE_PARAMETERS_MSG = "Unacceptable Parameters";
    private static final String L2CAP_INVALID_PARAMETERS_MSG = "Invalid Parameters";
    private static final String L2CAP_NO_RESOURCES_MSG = "No resources Available";
    private static final String L2CAP_NO_PSM_AVAILABLE_MSG = "No PSM available";
    private static final String L2CAP_TIMEOUT_MSG = "Connection Timeout";
    private static final String BLUETOOTH_OFF_FAILURE_MSG = "Bluetooth is off";
    private static final String SOCKET_MANAGER_FAILURE_MSG = "bt get socket manager failed";
    private static final String SOCKET_CLOSED_MSG = "socket closed";
    private static final String SOCKET_CONNECTION_FAILURE_MSG = "bt socket connect failed";
    private static final String NULL_DEVICE_MSG = "Connect is called on null device";
    private static final String UNIX_FILE_SOCKET_CREATION_FAILURE_MSG = "Null file descriptor returned";
    private final int mErrorCode;

    public BluetoothSocketException(int code, @NonNull String msg) {
        super(msg);
        this.mErrorCode = code;
    }

    public BluetoothSocketException(int code) {
        this(code, BluetoothSocketException.getMessage(code));
    }

    @RequiresNoPermission
    public int getErrorCode() {
        return this.mErrorCode;
    }

    private static String getMessage(int code) {
        switch (code) {
            case 15: {
                return BLUETOOTH_OFF_FAILURE_MSG;
            }
            case 16: {
                return SOCKET_MANAGER_FAILURE_MSG;
            }
            case 17: {
                return SOCKET_CLOSED_MSG;
            }
            case 18: {
                return SOCKET_CONNECTION_FAILURE_MSG;
            }
            case 19: {
                return NULL_DEVICE_MSG;
            }
            case 21: {
                return UNIX_FILE_SOCKET_CREATION_FAILURE_MSG;
            }
            case 2: {
                return L2CAP_ACL_FAILURE_MSG;
            }
            case 3: {
                return L2CAP_CLIENT_SECURITY_FAILURE_MSG;
            }
            case 4: {
                return L2CAP_INSUFFICIENT_AUTHENTICATION_MSG;
            }
            case 5: {
                return L2CAP_INSUFFICIENT_AUTHORIZATION_MSG;
            }
            case 6: {
                return L2CAP_INSUFFICIENT_ENCRYPT_KEY_SIZE_MSG;
            }
            case 7: {
                return L2CAP_INSUFFICIENT_ENCRYPTION_MSG;
            }
            case 8: {
                return L2CAP_INVALID_SOURCE_CID_MSG;
            }
            case 9: {
                return L2CAP_SOURCE_CID_ALREADY_ALLOCATED_MSG;
            }
            case 10: {
                return L2CAP_UNACCEPTABLE_PARAMETERS_MSG;
            }
            case 11: {
                return L2CAP_INVALID_PARAMETERS_MSG;
            }
            case 12: {
                return L2CAP_NO_RESOURCES_MSG;
            }
            case 13: {
                return L2CAP_NO_PSM_AVAILABLE_MSG;
            }
            case 14: {
                return L2CAP_TIMEOUT_MSG;
            }
            case 1: {
                return L2CAP_UNKNOWN_MSG;
            }
        }
        return UNSPECIFIED_MSG;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface ErrorCode {
    }
}

