/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresNoPermission;
import android.bluetooth.BluetoothSocket;
import java.io.IOException;
import java.io.InputStream;

class BluetoothInputStream
extends InputStream {
    private final BluetoothSocket mSocket;

    BluetoothInputStream(BluetoothSocket s) {
        this.mSocket = s;
    }

    @Override
    @RequiresNoPermission
    public int available() throws IOException {
        return this.mSocket.available();
    }

    @Override
    public void close() throws IOException {
        this.mSocket.close();
    }

    @Override
    @RequiresNoPermission
    public int read() throws IOException {
        byte[] b = new byte[1];
        int ret = this.mSocket.read(b, 0, 1);
        if (ret == 1) {
            return b[0] & 0xFF;
        }
        return -1;
    }

    @Override
    @RequiresNoPermission
    public int read(byte[] b, int offset, int length) throws IOException {
        if (b == null) {
            throw new NullPointerException("byte array is null");
        }
        if ((offset | length) < 0 || length > b.length - offset) {
            throw new ArrayIndexOutOfBoundsException("invalid offset or length");
        }
        return this.mSocket.read(b, offset, length);
    }
}

