/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.compat.CompatChanges;
import android.bluetooth.Attributable;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothSinkAudioPolicy;
import android.bluetooth.BluetoothSocket;
import android.bluetooth.BluetoothSocketSettings;
import android.bluetooth.BluetoothUtils;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.OobData;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.content.Context;
import android.os.Handler;
import android.os.IpcDataCache;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;

public class BluetoothDevice
implements Parcelable,
Attributable {
    private static final String TAG = BluetoothDevice.class.getSimpleName();
    private static final boolean DBG = Log.isLoggable("bluetooth", 3);
    public static final int CONNECTION_STATE_DISCONNECTED = 0;
    public static final int CONNECTION_STATE_CONNECTED = 1;
    public static final int CONNECTION_STATE_ENCRYPTED_BREDR = 2;
    public static final int CONNECTION_STATE_ENCRYPTED_LE = 4;
    public static final int ERROR = Integer.MIN_VALUE;
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public static final String ACTION_FOUND = "android.bluetooth.device.action.FOUND";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_CLASS_CHANGED = "android.bluetooth.device.action.CLASS_CHANGED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_ACL_CONNECTED = "android.bluetooth.device.action.ACL_CONNECTED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_ACL_DISCONNECT_REQUESTED = "android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_ACL_DISCONNECTED = "android.bluetooth.device.action.ACL_DISCONNECTED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_NAME_CHANGED = "android.bluetooth.device.action.NAME_CHANGED";
    @SuppressLint(value={"ActionValue"})
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_ALIAS_CHANGED = "android.bluetooth.device.action.ALIAS_CHANGED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_BOND_STATE_CHANGED = "android.bluetooth.device.action.BOND_STATE_CHANGED";
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_BATTERY_LEVEL_CHANGED = "android.bluetooth.device.action.BATTERY_LEVEL_CHANGED";
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public static final String ACTION_SWITCH_BUFFER_SIZE = "android.bluetooth.device.action.SWITCH_BUFFER_SIZE";
    @SuppressLint(value={"ActionValue"})
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"}, conditional=true)
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.key_missing_public")
    public static final String ACTION_KEY_MISSING = "android.bluetooth.device.action.KEY_MISSING";
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.encryption_change_broadcast")
    @SuppressLint(value={"ActionValue"})
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_ENCRYPTION_CHANGE = "android.bluetooth.device.action.ENCRYPTION_CHANGE";
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_BATTERY_LEVEL = "android.bluetooth.device.extra.BATTERY_LEVEL";
    @SystemApi
    public static final int BATTERY_LEVEL_UNKNOWN = -1;
    @SystemApi
    public static final int BATTERY_LEVEL_BLUETOOTH_OFF = -100;
    public static final String EXTRA_DEVICE = "android.bluetooth.device.extra.DEVICE";
    public static final String EXTRA_NAME = "android.bluetooth.device.extra.NAME";
    public static final String EXTRA_RSSI = "android.bluetooth.device.extra.RSSI";
    public static final String EXTRA_IS_COORDINATED_SET_MEMBER = "android.bluetooth.extra.IS_COORDINATED_SET_MEMBER";
    @SuppressLint(value={"ActionValue"})
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.get_svc_uuids_from_ble_adv_data")
    public static final String EXTRA_DISCOVERY_RESULT_TYPE = "android.bluetooth.device.extra.DISCOVERY_RESULT_TYPE";
    public static final String EXTRA_CLASS = "android.bluetooth.device.extra.CLASS";
    public static final String EXTRA_BOND_STATE = "android.bluetooth.device.extra.BOND_STATE";
    public static final String EXTRA_PREVIOUS_BOND_STATE = "android.bluetooth.device.extra.PREVIOUS_BOND_STATE";
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_LOW_LATENCY_BUFFER_SIZE = "android.bluetooth.device.extra.LOW_LATENCY_BUFFER_SIZE";
    public static final int BOND_NONE = 10;
    public static final int BOND_BONDING = 11;
    public static final int BOND_BONDED = 12;
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_UNBOND_REASON = "android.bluetooth.device.extra.REASON";
    @UnsupportedAppUsage
    public static final String EXTRA_REASON = "android.bluetooth.device.extra.REASON";
    public static final String EXTRA_PAIRING_VARIANT = "android.bluetooth.device.extra.PAIRING_VARIANT";
    public static final String EXTRA_PAIRING_KEY = "android.bluetooth.device.extra.PAIRING_KEY";
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_PAIRING_INITIATOR = "android.bluetooth.device.extra.PAIRING_INITIATOR";
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.encryption_change_broadcast")
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_KEY_SIZE = "android.bluetooth.device.extra.KEY_SIZE";
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.encryption_change_broadcast")
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_ENCRYPTION_ALGORITHM = "android.bluetooth.device.extra.EXTRA_ENCRYPTION_ALGORITHM";
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.encryption_change_broadcast")
    public static final int ENCRYPTION_ALGORITHM_NONE = 0;
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.encryption_change_broadcast")
    public static final int ENCRYPTION_ALGORITHM_E0 = 1;
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.encryption_change_broadcast")
    public static final int ENCRYPTION_ALGORITHM_AES = 2;
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.encryption_change_broadcast")
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_ENCRYPTION_STATUS = "android.bluetooth.device.extra.ENCRYPTION_STATUS";
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.encryption_change_broadcast")
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_ENCRYPTION_ENABLED = "android.bluetooth.device.extra.ENCRYPTION_ENABLED";
    @SystemApi
    public static final int EXTRA_PAIRING_INITIATOR_FOREGROUND = 1;
    @SystemApi
    public static final int EXTRA_PAIRING_INITIATOR_BACKGROUND = 2;
    public static final int DEVICE_TYPE_UNKNOWN = 0;
    public static final int DEVICE_TYPE_CLASSIC = 1;
    public static final int DEVICE_TYPE_LE = 2;
    public static final int DEVICE_TYPE_DUAL = 3;
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String ACTION_SDP_RECORD = "android.bluetooth.device.action.SDP_RECORD";
    @SystemApi
    public static final int METADATA_MAX_LENGTH = 2048;
    @SystemApi
    public static final int METADATA_MANUFACTURER_NAME = 0;
    @SystemApi
    public static final int METADATA_MODEL_NAME = 1;
    @SystemApi
    public static final int METADATA_SOFTWARE_VERSION = 2;
    @SystemApi
    public static final int METADATA_HARDWARE_VERSION = 3;
    @SystemApi
    public static final int METADATA_COMPANION_APP = 4;
    @SystemApi
    public static final int METADATA_MAIN_ICON = 5;
    @SystemApi
    public static final int METADATA_IS_UNTETHERED_HEADSET = 6;
    @SystemApi
    public static final int METADATA_UNTETHERED_LEFT_ICON = 7;
    @SystemApi
    public static final int METADATA_UNTETHERED_RIGHT_ICON = 8;
    @SystemApi
    public static final int METADATA_UNTETHERED_CASE_ICON = 9;
    @SystemApi
    public static final int METADATA_UNTETHERED_LEFT_BATTERY = 10;
    @SystemApi
    public static final int METADATA_UNTETHERED_RIGHT_BATTERY = 11;
    @SystemApi
    public static final int METADATA_UNTETHERED_CASE_BATTERY = 12;
    @SystemApi
    public static final int METADATA_UNTETHERED_LEFT_CHARGING = 13;
    @SystemApi
    public static final int METADATA_UNTETHERED_RIGHT_CHARGING = 14;
    @SystemApi
    public static final int METADATA_UNTETHERED_CASE_CHARGING = 15;
    @SystemApi
    public static final int METADATA_ENHANCED_SETTINGS_UI_URI = 16;
    public static final String COMPANION_TYPE_PRIMARY = "COMPANION_PRIMARY";
    public static final String COMPANION_TYPE_SECONDARY = "COMPANION_SECONDARY";
    public static final String COMPANION_TYPE_NONE = "COMPANION_NONE";
    @SystemApi
    public static final int METADATA_DEVICE_TYPE = 17;
    @SystemApi
    public static final int METADATA_MAIN_BATTERY = 18;
    @SystemApi
    public static final int METADATA_MAIN_CHARGING = 19;
    @SystemApi
    public static final int METADATA_MAIN_LOW_BATTERY_THRESHOLD = 20;
    @SystemApi
    public static final int METADATA_UNTETHERED_LEFT_LOW_BATTERY_THRESHOLD = 21;
    @SystemApi
    public static final int METADATA_UNTETHERED_RIGHT_LOW_BATTERY_THRESHOLD = 22;
    @SystemApi
    public static final int METADATA_UNTETHERED_CASE_LOW_BATTERY_THRESHOLD = 23;
    public static final int METADATA_SPATIAL_AUDIO = 24;
    public static final int METADATA_FAST_PAIR_CUSTOMIZED_FIELDS = 25;
    @SystemApi
    public static final int METADATA_LE_AUDIO = 26;
    public static final int METADATA_GMCS_CCCD = 27;
    public static final int METADATA_GTBS_CCCD = 28;
    @SystemApi
    public static final int METADATA_EXCLUSIVE_MANAGER = 29;
    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.support_zoomed_in_icon_metadata")
    public static final int METADATA_ZOOMED_IN_ICON = 30;
    private static final int METADATA_MAX_KEY = 29;
    @SystemApi
    public static final String DEVICE_TYPE_DEFAULT = "Default";
    @SystemApi
    public static final String DEVICE_TYPE_WATCH = "Watch";
    @SystemApi
    public static final String DEVICE_TYPE_UNTETHERED_HEADSET = "Untethered Headset";
    @SystemApi
    public static final String DEVICE_TYPE_STYLUS = "Stylus";
    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.support_metadata_device_types_apis")
    public static final String DEVICE_TYPE_SPEAKER = "Speaker";
    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.support_metadata_device_types_apis")
    public static final String DEVICE_TYPE_HEADSET = "Headset";
    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.support_metadata_device_types_apis")
    public static final String DEVICE_TYPE_CARKIT = "Carkit";
    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.support_metadata_device_types_apis")
    public static final String DEVICE_TYPE_HEARING_AID = "HearingAid";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_UUID = "android.bluetooth.device.action.UUID";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_MAS_INSTANCE = "android.bluetooth.device.action.MAS_INSTANCE";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_NAME_FAILED = "android.bluetooth.device.action.NAME_FAILED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_PAIRING_REQUEST = "android.bluetooth.device.action.PAIRING_REQUEST";
    private static final long CHANGE_TO_STRING_REDACTED = 265103382L;
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_PAIRING_CANCEL = "android.bluetooth.device.action.PAIRING_CANCEL";
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_CONNECTION_ACCESS_REQUEST = "android.bluetooth.device.action.CONNECTION_ACCESS_REQUEST";
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_CONNECTION_ACCESS_REPLY = "android.bluetooth.device.action.CONNECTION_ACCESS_REPLY";
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_CONNECTION_ACCESS_CANCEL = "android.bluetooth.device.action.CONNECTION_ACCESS_CANCEL";
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_SILENCE_MODE_CHANGED = "android.bluetooth.device.action.SILENCE_MODE_CHANGED";
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_ACCESS_REQUEST_TYPE = "android.bluetooth.device.extra.ACCESS_REQUEST_TYPE";
    @SystemApi
    public static final int REQUEST_TYPE_PROFILE_CONNECTION = 1;
    @SystemApi
    public static final int REQUEST_TYPE_PHONEBOOK_ACCESS = 2;
    @SystemApi
    public static final int REQUEST_TYPE_MESSAGE_ACCESS = 3;
    @SystemApi
    public static final int REQUEST_TYPE_SIM_ACCESS = 4;
    public static final String EXTRA_PACKAGE_NAME = "android.bluetooth.device.extra.PACKAGE_NAME";
    public static final String EXTRA_CLASS_NAME = "android.bluetooth.device.extra.CLASS_NAME";
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_CONNECTION_ACCESS_RESULT = "android.bluetooth.device.extra.CONNECTION_ACCESS_RESULT";
    @SystemApi
    public static final int CONNECTION_ACCESS_YES = 1;
    @SystemApi
    public static final int CONNECTION_ACCESS_NO = 2;
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_ALWAYS_ALLOWED = "android.bluetooth.device.extra.ALWAYS_ALLOWED";
    public static final int BOND_SUCCESS = 0;
    @SystemApi
    public static final int UNBOND_REASON_AUTH_FAILED = 1;
    @SystemApi
    public static final int UNBOND_REASON_AUTH_REJECTED = 2;
    @SystemApi
    public static final int UNBOND_REASON_AUTH_CANCELED = 3;
    @SystemApi
    public static final int UNBOND_REASON_REMOTE_DEVICE_DOWN = 4;
    @SystemApi
    public static final int UNBOND_REASON_DISCOVERY_IN_PROGRESS = 5;
    @SystemApi
    public static final int UNBOND_REASON_AUTH_TIMEOUT = 6;
    @SystemApi
    public static final int UNBOND_REASON_REPEATED_ATTEMPTS = 7;
    @SystemApi
    public static final int UNBOND_REASON_REMOTE_AUTH_CANCELED = 8;
    @SystemApi
    public static final int UNBOND_REASON_REMOVED = 9;
    public static final int PAIRING_VARIANT_PIN = 0;
    @SystemApi
    public static final int PAIRING_VARIANT_PASSKEY = 1;
    public static final int PAIRING_VARIANT_PASSKEY_CONFIRMATION = 2;
    @SystemApi
    public static final int PAIRING_VARIANT_CONSENT = 3;
    @SystemApi
    public static final int PAIRING_VARIANT_DISPLAY_PASSKEY = 4;
    @SystemApi
    public static final int PAIRING_VARIANT_DISPLAY_PIN = 5;
    @SystemApi
    public static final int PAIRING_VARIANT_OOB_CONSENT = 6;
    @SystemApi
    public static final int PAIRING_VARIANT_PIN_16_DIGITS = 7;
    public static final String EXTRA_UUID = "android.bluetooth.device.extra.UUID";
    @SuppressLint(value={"ActionValue"})
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.get_svc_uuids_from_ble_adv_data")
    public static final String EXTRA_UUID_LE = "android.bluetooth.device.extra.UUID_LE";
    public static final String EXTRA_SDP_RECORD = "android.bluetooth.device.extra.SDP_RECORD";
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final String EXTRA_SDP_SEARCH_STATUS = "android.bluetooth.device.extra.SDP_SEARCH_STATUS";
    @SystemApi
    public static final int ACCESS_UNKNOWN = 0;
    @SystemApi
    public static final int ACCESS_ALLOWED = 1;
    @SystemApi
    public static final int ACCESS_REJECTED = 2;
    public static final int TRANSPORT_AUTO = 0;
    public static final int TRANSPORT_BREDR = 1;
    public static final int TRANSPORT_LE = 2;
    public static final int PHY_LE_1M = 1;
    public static final int PHY_LE_2M = 2;
    public static final int PHY_LE_CODED = 3;
    public static final int PHY_LE_1M_MASK = 1;
    public static final int PHY_LE_2M_MASK = 2;
    public static final int PHY_LE_CODED_MASK = 4;
    public static final int PHY_OPTION_NO_PREFERRED = 0;
    public static final int PHY_OPTION_S2 = 1;
    public static final int PHY_OPTION_S8 = 2;
    public static final String EXTRA_MAS_INSTANCE = "android.bluetooth.device.extra.MAS_INSTANCE";
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_TRANSPORT = "android.bluetooth.device.extra.TRANSPORT";
    public static final int ADDRESS_TYPE_PUBLIC = 0;
    public static final int ADDRESS_TYPE_RANDOM = 1;
    public static final int ADDRESS_TYPE_UNKNOWN = 65535;
    public static final int ADDRESS_TYPE_ANONYMOUS = 255;
    public static final int ON_HEAD_DETECTION_ENABLED_STATE_UNKNOWN = 0;
    public static final int ON_HEAD_DETECTION_ENABLED_STATE_ENABLED = 1;
    public static final int ON_HEAD_DETECTION_ENABLED_STATE_DISABLED = 2;
    public static final int ON_HEAD_DETECTION_STATE_UNKNOWN = 0;
    public static final int ON_HEAD_DETECTION_STATE_ON_HEAD = 1;
    public static final int ON_HEAD_DETECTION_STATE_NOT_ON_HEAD = 2;
    @SystemApi
    public static final int ACTIVE_AUDIO_DEVICE_POLICY_DEFAULT = 0;
    @SystemApi
    public static final int ACTIVE_AUDIO_DEVICE_POLICY_ALL_PROFILES_ACTIVE_UPON_CONNECTION = 1;
    @SystemApi
    public static final int ACTIVE_AUDIO_DEVICE_POLICY_ALL_PROFILES_INACTIVE_UPON_CONNECTION = 2;
    private static final String NULL_MAC_ADDRESS = "00:00:00:00:00:00";
    private final String mAddress;
    private final int mAddressType;
    private AttributionSource mAttributionSource;
    @NonNull
    public static final Parcelable.Creator<BluetoothDevice> CREATOR = new Parcelable.Creator<BluetoothDevice>(){

        @Override
        public BluetoothDevice createFromParcel(Parcel in) {
            return new BluetoothDevice(in);
        }

        public BluetoothDevice[] newArray(int size) {
            return new BluetoothDevice[size];
        }
    };
    private static final IpcDataCache.QueryHandler<Pair<IBluetooth, Pair<AttributionSource, BluetoothDevice>>, Integer> sBluetoothBondQuery = new IpcDataCache.QueryHandler<Pair<IBluetooth, Pair<AttributionSource, BluetoothDevice>>, Integer>(){

        @Override
        @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
        public Integer apply(Pair<IBluetooth, Pair<AttributionSource, BluetoothDevice>> pairQuery) {
            IBluetooth service = (IBluetooth)pairQuery.first;
            AttributionSource source = (AttributionSource)((Pair)pairQuery.second).first;
            BluetoothDevice device = (BluetoothDevice)((Pair)pairQuery.second).second;
            try {
                return service.getBondState(device, source);
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
    };
    private static final String GET_BOND_STATE_API = "BluetoothDevice_getBondState";
    private static final BluetoothCache<Pair<IBluetooth, Pair<AttributionSource, BluetoothDevice>>, Integer> sBluetoothBondCache = new BluetoothCache("BluetoothDevice_getBondState", sBluetoothBondQuery);

    static IBluetooth getService() {
        return BluetoothAdapter.getDefaultAdapter().getBluetoothService();
    }

    BluetoothDevice(String address, int addressType) {
        if (!BluetoothAdapter.checkBluetoothAddress(address)) {
            throw new IllegalArgumentException(address + " is not a valid Bluetooth address");
        }
        if (addressType != 0 && addressType != 1 && addressType != 255) {
            throw new IllegalArgumentException(addressType + " is not a Bluetooth address type");
        }
        if (addressType == 255 && !NULL_MAC_ADDRESS.equals(address)) {
            throw new IllegalArgumentException("Invalid address for anonymous address type: " + BluetoothUtils.toAnonymizedAddress(address));
        }
        this.mAddress = address;
        this.mAddressType = addressType;
        this.mAttributionSource = AttributionSource.myAttributionSource();
    }

    @UnsupportedAppUsage
    BluetoothDevice(String address) {
        this(address, 0);
    }

    @UnsupportedAppUsage
    BluetoothDevice(Parcel in) {
        this(in.readString(), in.readInt());
    }

    @Override
    public void setAttributionSource(@NonNull AttributionSource source) {
        this.mAttributionSource = source;
    }

    @SystemApi
    public void prepareToEnterProcess(@NonNull AttributionSource source) {
        this.setAttributionSource(source);
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof BluetoothDevice) {
            return this.mAddress.equals(((BluetoothDevice)o).getAddress());
        }
        return false;
    }

    public int hashCode() {
        return this.mAddress.hashCode();
    }

    public String toString() {
        if (!CompatChanges.isChangeEnabled(265103382L)) {
            return this.mAddress;
        }
        return this.getAnonymizedAddress();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        BluetoothUtils.writeStringToParcel(out, this.mAddress);
        out.writeInt(this.mAddressType);
    }

    public String getAddress() {
        return this.mAddress;
    }

    public int getAddressType() {
        return this.mAddressType;
    }

    @SystemApi
    @NonNull
    public String getAnonymizedAddress() {
        return BluetoothUtils.toAnonymizedAddress(this.mAddress);
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    @Nullable
    public String getIdentityAddress() {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot get identity address");
        } else {
            try {
                return service.getIdentityAddress(this.mAddress);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return null;
    }

    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.identity_address_type_api")
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    @NonNull
    public BluetoothAddress getIdentityAddressWithType() {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot get identity address with type");
        } else {
            try {
                return service.getIdentityAddressWithType(this.mAddress);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return new BluetoothAddress(null, 65535);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public String getName() {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot get Remote Device name");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                String name = service.getRemoteName(this, this.mAttributionSource);
                if (name != null) {
                    return name.replace('\t', ' ').replace('\n', ' ').replace('\r', ' ');
                }
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return null;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getType() {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot get Remote Device type");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.getRemoteType(this, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    @Nullable
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public String getAlias() {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot get Remote Device Alias");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                String alias = service.getRemoteAlias(this, this.mAttributionSource);
                if (alias == null) {
                    return this.getName();
                }
                return alias.replace('\t', ' ').replace('\n', ' ').replace('\r', ' ');
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return null;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"}, conditional=true)
    public int setAlias(@Nullable String alias) {
        IBluetooth service;
        if (alias != null && alias.isEmpty()) {
            throw new IllegalArgumentException("alias cannot be the empty string");
        }
        if (DBG) {
            BluetoothDevice.log("setAlias(" + alias + ")");
        }
        if ((service = BluetoothDevice.getService()) == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot set Remote Device name");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.setRemoteAlias(this, alias, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
            }
        }
        return 1;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getBatteryLevel() {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth disabled. Cannot get remote device battery level");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.getBatteryLevel(this, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return -100;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean createBond() {
        return this.createBond(0);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean createBond(int transport) {
        IBluetooth service;
        if (DBG) {
            BluetoothDevice.log("createBond()");
        }
        if ((service = BluetoothDevice.getService()) == null || !this.isBluetoothEnabled()) {
            Log.w(TAG, "BT not enabled, createBond failed");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else if (NULL_MAC_ADDRESS.equals(this.mAddress)) {
            Log.e(TAG, "Unable to create bond, invalid address " + this.mAddress);
        } else {
            try {
                return service.createBond(this, transport, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean createBondOutOfBand(int transport, @Nullable OobData remoteP192Data, @Nullable OobData remoteP256Data) {
        if (DBG) {
            BluetoothDevice.log("createBondOutOfBand()");
        }
        IBluetooth service = BluetoothDevice.getService();
        if (remoteP192Data == null && remoteP256Data == null) {
            throw new IllegalArgumentException("One or both arguments for the OOB data types are required to not be null.  Please use createBond() instead if you do not have OOB data to pass.");
        }
        if (service == null || !this.isBluetoothEnabled()) {
            Log.w(TAG, "BT not enabled, createBondOutOfBand failed");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else if (NULL_MAC_ADDRESS.equals(this.mAddress)) {
            Log.e(TAG, "Unable to create bond Out of Band, invalid address " + this.mAddress);
        } else {
            try {
                return service.createBondOutOfBand(this, transport, remoteP192Data, remoteP256Data, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean isBondingInitiatedLocally() {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.w(TAG, "BT not enabled, isBondingInitiatedLocally failed");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.isBondingInitiatedLocally(this, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean cancelBondProcess() {
        IBluetooth service;
        if (DBG) {
            BluetoothDevice.log("cancelBondProcess()");
        }
        if ((service = BluetoothDevice.getService()) == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot cancel Remote Device bond");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            Log.i(TAG, "cancelBondProcess() for" + " device " + this + " called by pid: " + Process.myPid() + " tid: " + Process.myTid());
            try {
                return service.cancelBondProcess(this, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean removeBond() {
        IBluetooth service;
        if (DBG) {
            BluetoothDevice.log("removeBond()");
        }
        if ((service = BluetoothDevice.getService()) == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot remove Remote Device bond");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            Log.i(TAG, "removeBond() for" + " device " + this + " called by pid: " + Process.myPid() + " tid: " + Process.myTid());
            try {
                return service.removeBond(this, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    private static void invalidateCache(@NonNull String api) {
        IpcDataCache.invalidateCache("bluetooth", api);
    }

    public void disableBluetoothGetBondStateCache() {
        sBluetoothBondCache.disableForCurrentProcess();
    }

    public static void invalidateBluetoothGetBondStateCache() {
        BluetoothDevice.invalidateCache(GET_BOND_STATE_API);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public int getBondState() {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null) {
            Log.e(TAG, "BT not enabled. Cannot get bond state");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return (Integer)sBluetoothBondCache.query(new Pair<IBluetooth, Pair<AttributionSource, BluetoothDevice>>(service, new Pair<AttributionSource, BluetoothDevice>(this.mAttributionSource, this)));
            }
            catch (RuntimeException e) {
                if (!(e.getCause() instanceof RemoteException)) {
                    throw e;
                }
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 10;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean canBondWithoutDialog() {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot check if we can skip pairing dialog");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.canBondWithoutDialog(this, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    @Nullable
    public String getPackageNameOfBondingApplication() {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.w(TAG, "BT not enabled, getPackageNameOfBondingApplication failed");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.getPackageNameOfBondingApplication(this, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return null;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED", "android.permission.MODIFY_PHONE_STATE"})
    public int connect() {
        if (DBG) {
            BluetoothDevice.log("connect()");
        }
        if (!BluetoothAdapter.checkBluetoothAddress(this.getAddress())) {
            throw new IllegalArgumentException("device cannot have an invalid address");
        }
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot connect to remote device.");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.connectAllEnabledProfiles(this, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
            }
        }
        return 1;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int disconnect() {
        if (DBG) {
            BluetoothDevice.log("disconnect()");
        }
        if (!BluetoothAdapter.checkBluetoothAddress(this.getAddress())) {
            throw new IllegalArgumentException("device cannot have an invalid address");
        }
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot disconnect to remote device.");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.disconnectAllEnabledProfiles(this, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
            }
        }
        return 1;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean isConnected() {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.w(TAG, "Proxy not attached to service");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.getConnectionState(this, this.mAttributionSource) != 0;
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getConnectionHandle(int transport) {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.w(TAG, "Proxy not attached to service");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.getConnectionHandle(this, transport, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return Integer.MIN_VALUE;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean isEncrypted() {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.w(TAG, "Proxy not attached to service");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.getConnectionState(this, this.mAttributionSource) > 1;
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothClass getBluetoothClass() {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot get Bluetooth Class");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                int classInt = service.getRemoteClass(this, this.mAttributionSource);
                if (classInt == -16777216) {
                    return null;
                }
                return new BluetoothClass(classInt);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return null;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public ParcelUuid[] getUuids() {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot get remote device Uuids");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                List<ParcelUuid> parcels = service.getRemoteUuids(this, this.mAttributionSource);
                return parcels != null ? parcels.toArray(new ParcelUuid[parcels.size()]) : null;
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return null;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public boolean fetchUuidsWithSdp() {
        return this.fetchUuidsWithSdp(0);
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"}, conditional=true)
    public boolean fetchUuidsWithSdp(int transport) {
        IBluetooth service;
        if (DBG) {
            BluetoothDevice.log("fetchUuidsWithSdp()");
        }
        if ((service = BluetoothDevice.getService()) == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot fetchUuidsWithSdp");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.fetchRemoteUuids(this, transport, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean sdpSearch(ParcelUuid uuid) {
        IBluetooth service;
        if (DBG) {
            BluetoothDevice.log("sdpSearch()");
        }
        if ((service = BluetoothDevice.getService()) == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot query remote device sdp records");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.sdpSearch(this, uuid, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean setPin(byte[] pin) {
        IBluetooth service;
        if (DBG) {
            BluetoothDevice.log("setPin()");
        }
        if ((service = BluetoothDevice.getService()) == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot set Remote Device pin");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.setPin(this, true, pin.length, pin, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean setPin(@NonNull String pin) {
        byte[] pinBytes = BluetoothDevice.convertPinToBytes(pin);
        if (pinBytes == null) {
            return false;
        }
        return this.setPin(pinBytes);
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setPairingConfirmation(boolean confirm) {
        IBluetooth service;
        if (DBG) {
            BluetoothDevice.log("setPairingConfirmation()");
        }
        if ((service = BluetoothDevice.getService()) == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot set pairing confirmation");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.setPairingConfirmation(this, confirm, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    boolean isBluetoothEnabled() {
        boolean ret = false;
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null && adapter.isEnabled()) {
            ret = true;
        }
        return ret;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getPhonebookAccessPermission() {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.w(TAG, "Proxy not attached to service");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.getPhonebookAccessPermission(this, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setSilenceMode(boolean silence) {
        IBluetooth service;
        if (DBG) {
            BluetoothDevice.log("setSilenceMode()");
        }
        if ((service = BluetoothDevice.getService()) == null || !this.isBluetoothEnabled()) {
            throw new IllegalStateException("Bluetooth is not turned ON");
        }
        try {
            return service.setSilenceMode(this, silence, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean isInSilenceMode() {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            throw new IllegalStateException("Bluetooth is not turned ON");
        }
        try {
            return service.getSilenceMode(this, this.mAttributionSource);
        }
        catch (RemoteException e) {
            Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            return false;
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setPhonebookAccessPermission(int value) {
        IBluetooth service;
        if (DBG) {
            BluetoothDevice.log("setPhonebookAccessPermission()");
        }
        if ((service = BluetoothDevice.getService()) == null || !this.isBluetoothEnabled()) {
            Log.w(TAG, "Proxy not attached to service");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.setPhonebookAccessPermission(this, value, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getMessageAccessPermission() {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.w(TAG, "Proxy not attached to service");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.getMessageAccessPermission(this, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setMessageAccessPermission(int value) {
        IBluetooth service;
        if (value != 1 && value != 2 && value != 0) {
            throw new IllegalArgumentException(value + "is not a valid AccessPermission value");
        }
        if (DBG) {
            BluetoothDevice.log("setMessageAccessPermission()");
        }
        if ((service = BluetoothDevice.getService()) == null || !this.isBluetoothEnabled()) {
            Log.w(TAG, "Proxy not attached to service");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.setMessageAccessPermission(this, value, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getSimAccessPermission() {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.w(TAG, "Proxy not attached to service");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.getSimAccessPermission(this, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 0;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setSimAccessPermission(int value) {
        IBluetooth service;
        if (DBG) {
            BluetoothDevice.log("setSimAccessPermission()");
        }
        if ((service = BluetoothDevice.getService()) == null || !this.isBluetoothEnabled()) {
            Log.w(TAG, "Proxy not attached to service");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.setSimAccessPermission(this, value, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @UnsupportedAppUsage
    public BluetoothSocket createRfcommSocket(int channel) throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(this, 1, true, true, channel, null);
    }

    public BluetoothSocket createL2capSocket(int channel) throws IOException {
        return new BluetoothSocket(this, 3, true, true, channel, null);
    }

    public BluetoothSocket createInsecureL2capSocket(int channel) throws IOException {
        return new BluetoothSocket(this, 3, false, false, channel, null);
    }

    public BluetoothSocket createRfcommSocketToServiceRecord(UUID uuid) throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(this, 1, true, true, -1, new ParcelUuid(uuid));
    }

    public BluetoothSocket createInsecureRfcommSocketToServiceRecord(UUID uuid) throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(this, 1, false, false, -1, new ParcelUuid(uuid));
    }

    @UnsupportedAppUsage(publicAlternatives="Use {@link #createInsecureRfcommSocketToServiceRecord} instead.")
    public BluetoothSocket createInsecureRfcommSocket(int port) throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(this, 1, false, false, port, null);
    }

    @UnsupportedAppUsage
    public BluetoothSocket createScoSocket() throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled");
            throw new IOException();
        }
        return new BluetoothSocket(this, 2, true, true, -1, null);
    }

    @UnsupportedAppUsage
    public static byte[] convertPinToBytes(String pin) {
        if (pin == null) {
            return null;
        }
        byte[] pinBytes = pin.getBytes(StandardCharsets.UTF_8);
        if (pinBytes.length <= 0 || pinBytes.length > 16) {
            return null;
        }
        return pinBytes;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback) {
        return this.connectGatt(context, autoConnect, callback, 0);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback, int transport) {
        return this.connectGatt(context, autoConnect, callback, transport, 1);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback, int transport, int phy) {
        return this.connectGatt(context, autoConnect, callback, transport, phy, null);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback, int transport, int phy, Handler handler) {
        return this.connectGatt(context, autoConnect, callback, transport, false, phy, handler);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothGatt connectGatt(Context context, boolean autoConnect, BluetoothGattCallback callback, int transport, boolean opportunistic, int phy, Handler handler) {
        if (callback == null) {
            throw new NullPointerException("callback is null");
        }
        IBluetoothGatt iGatt = BluetoothAdapter.getDefaultAdapter().getBluetoothGatt();
        if (iGatt == null) {
            return null;
        }
        if (NULL_MAC_ADDRESS.equals(this.mAddress)) {
            Log.e(TAG, "Unable to connect gatt, invalid address " + this.mAddress);
            return null;
        }
        BluetoothGatt gatt = new BluetoothGatt(iGatt, this, transport, opportunistic, phy, this.mAttributionSource);
        gatt.connect(autoConnect, callback, handler);
        return gatt;
    }

    @NonNull
    public BluetoothSocket createL2capChannel(int psm) throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e(TAG, "createL2capChannel: Bluetooth is not enabled");
            throw new IOException();
        }
        if (DBG) {
            Log.d(TAG, "createL2capChannel: psm=" + psm);
        }
        return new BluetoothSocket(this, 4, true, true, psm, null);
    }

    @NonNull
    public BluetoothSocket createInsecureL2capChannel(int psm) throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e(TAG, "createInsecureL2capChannel: Bluetooth is not enabled");
            throw new IOException();
        }
        if (DBG) {
            Log.d(TAG, "createInsecureL2capChannel: psm=" + psm);
        }
        return new BluetoothSocket(this, 4, false, false, psm, null);
    }

    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.socket_settings_api")
    @NonNull
    public BluetoothSocket createUsingSocketSettings(@NonNull BluetoothSocketSettings settings) throws IOException {
        if (!this.isBluetoothEnabled()) {
            Log.e(TAG, "createUsingSocketSettings: Bluetooth is not enabled");
            throw new IOException();
        }
        if (DBG) {
            Log.d(TAG, "createUsingSocketSettings: =" + settings.getL2capPsm());
        }
        ParcelUuid uuid = null;
        int psm = settings.getL2capPsm();
        if (settings.getSocketType() == 1) {
            if (settings.getRfcommUuid() == null) {
                throw new IllegalArgumentException("null uuid");
            }
            uuid = new ParcelUuid(settings.getRfcommUuid());
        } else if (settings.getSocketType() == 4 && (psm < 128 || psm > 255)) {
            throw new IllegalArgumentException("Invalid PSM/Channel value: " + psm);
        }
        if (settings.getDataPath() == 0) {
            return new BluetoothSocket(this, settings.getSocketType(), settings.isAuthenticationRequired(), settings.isEncryptionRequired(), psm, uuid);
        }
        return new BluetoothSocket(this, settings.getSocketType(), settings.isAuthenticationRequired(), settings.isEncryptionRequired(), psm, uuid, false, false, settings.getDataPath(), settings.getSocketName(), settings.getHubId(), settings.getEndpointId(), settings.getRequestedMaximumPacketSize());
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setMetadata(int key, @NonNull byte[] value) {
        IBluetooth service;
        if (DBG) {
            BluetoothDevice.log("setMetadata()");
        }
        if ((service = BluetoothDevice.getService()) == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled. Cannot set metadata");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            if (value.length > 2048) {
                throw new IllegalArgumentException("value length is " + value.length + ", should not over " + 2048);
            }
            try {
                return service.setMetadata(this, key, value, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    @Nullable
    public byte[] getMetadata(int key) {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled. Cannot get metadata");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.getMetadata(this, key, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return null;
    }

    public static int getMaxMetadataKey() {
        return 29;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int isRequestAudioPolicyAsSinkSupported() {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "BT not enabled. Cannot retrieve audio policy support status.");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.isRequestAudioPolicyAsSinkSupported(this, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
            }
        }
        return 30;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int requestAudioPolicyAsSink(@NonNull BluetoothSinkAudioPolicy policies) {
        IBluetooth service;
        if (DBG) {
            BluetoothDevice.log("requestAudioPolicyAsSink");
        }
        if ((service = BluetoothDevice.getService()) == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled. Cannot set Audio Policy.");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.requestAudioPolicyAsSink(this, policies, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 1;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    @Nullable
    public BluetoothSinkAudioPolicy getRequestedAudioPolicyAsSink() {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled. Cannot get Audio Policy.");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.getRequestedAudioPolicyAsSink(this, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return null;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean setLowLatencyAudioAllowed(boolean allowed) {
        IBluetooth service;
        if (DBG) {
            BluetoothDevice.log("setLowLatencyAudioAllowed(" + allowed + ")");
        }
        if ((service = BluetoothDevice.getService()) == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled. Cannot allow low latency");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.allowLowLatencyAudio(allowed, this);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int setActiveAudioDevicePolicy(int activeAudioDevicePolicy) {
        if (DBG) {
            BluetoothDevice.log("setActiveAudioDevicePolicy(" + activeAudioDevicePolicy + ")");
        }
        if (!BluetoothAdapter.checkBluetoothAddress(this.getAddress())) {
            throw new IllegalArgumentException("device cannot have an invalid address");
        }
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled. Cannot set active audio device policy.");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.setActiveAudioDevicePolicy(this, activeAudioDevicePolicy, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
            }
        }
        return 1;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getActiveAudioDevicePolicy() {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled. Cannot get active audio device policy.");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.getActiveAudioDevicePolicy(this, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, "", e);
            }
        }
        return 0;
    }

    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.metadata_api_microphone_for_call_enabled")
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int setMicrophonePreferredForCalls(boolean enabled) {
        if (DBG) {
            BluetoothDevice.log("setMicrophonePreferredForCalls(" + enabled + ")");
        }
        if (!BluetoothAdapter.checkBluetoothAddress(this.getAddress())) {
            throw new IllegalArgumentException("device cannot have an invalid address");
        }
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled. Cannot set microphone for call enabled state.");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.setMicrophonePreferredForCalls(this, enabled, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 1;
    }

    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.metadata_api_microphone_for_call_enabled")
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean isMicrophonePreferredForCalls() {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled. Cannot get microphone for call enabled state.");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.isMicrophonePreferredForCalls(this, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return true;
    }

    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.prioritized_in_ear_routing")
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int setOnHeadDetectionEnabled(boolean enabled) {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled. Cannot set on-head detection enable state.");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                int enabledState = enabled ? 1 : 2;
                return service.setOnHeadDetectionEnabled(this, enabledState, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 1;
    }

    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.prioritized_in_ear_routing")
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int setOnHead(boolean isOnHead) {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled. Cannot set on-head detection state.");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                int state = isOnHead ? 1 : 2;
                return service.setOnHead(this, state, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return 1;
    }

    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.key_missing_count_api")
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getKeyMissingCount() {
        IBluetooth service = BluetoothDevice.getService();
        if (service == null || !this.isBluetoothEnabled()) {
            Log.e(TAG, "Bluetooth is not enabled. Cannot get key missing counter.");
            if (DBG) {
                BluetoothDevice.log(Log.getStackTraceString(new Throwable()));
            }
        } else {
            try {
                return service.getKeyMissingCount(this, this.mAttributionSource);
            }
            catch (RemoteException e) {
                Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
            }
        }
        return -1;
    }

    private static void log(String msg) {
        Log.d(TAG, msg);
    }

    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.identity_address_type_api")
    public static class BluetoothAddress
    implements Parcelable {
        @Nullable
        private final String mAddress;
        private final int mAddressType;
        @NonNull
        public static final Parcelable.Creator<BluetoothAddress> CREATOR = new Parcelable.Creator<BluetoothAddress>(){

            @Override
            @NonNull
            public BluetoothAddress createFromParcel(Parcel in) {
                return new BluetoothAddress(in);
            }

            @NonNull
            public BluetoothAddress[] newArray(int size) {
                return new BluetoothAddress[size];
            }
        };

        public BluetoothAddress(@Nullable String address, int addressType) {
            this.mAddress = address;
            this.mAddressType = addressType;
        }

        @Nullable
        public String getAddress() {
            return this.mAddress;
        }

        public int getAddressType() {
            return this.mAddressType;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel out, int flags) {
            BluetoothUtils.writeStringToParcel(out, this.mAddress);
            out.writeInt(this.mAddressType);
        }

        private BluetoothAddress(@NonNull Parcel in) {
            this(in.readString(), in.readInt());
        }
    }

    private static class BluetoothCache<Q, R>
    extends IpcDataCache<Q, R> {
        BluetoothCache(String api, IpcDataCache.QueryHandler query) {
            super(8, "bluetooth", api, api, query);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetOnHeadDetectionParamsReturnValues {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetMicrophonePreferredForCallsReturnValues {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ActiveAudioDevicePolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetActiveAudioDevicePolicyReturnValues {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AudioPolicyReturnValues {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AudioPolicyRemoteSupport {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectionReturnValues {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetAliasReturnValues {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AddressType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Transport {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AccessPermission {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MetadataKey {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceType {
    }
}

