/*
 * Decompiled with CFR 0.152.
 */
package android.app.wearable;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import java.time.Duration;

@SystemApi
public class WearableSensingDataRequest
implements Parcelable {
    private static final int MAX_REQUEST_SIZE = 200;
    private static final Duration RATE_LIMIT_WINDOW_SIZE = Duration.ofMinutes(1L);
    private static final int RATE_LIMIT = 30;
    private final int mDataType;
    @NonNull
    private final PersistableBundle mRequestDetails;
    public static final String REQUEST_BUNDLE_KEY = "android.app.wearable.WearableSensingDataRequestBundleKey";
    public static final String REQUEST_STATUS_CALLBACK_BUNDLE_KEY = "android.app.wearable.WearableSensingDataRequestStatusCallbackBundleKey";
    @NonNull
    public static final Parcelable.Creator<WearableSensingDataRequest> CREATOR = new Parcelable.Creator<WearableSensingDataRequest>(){

        public WearableSensingDataRequest[] newArray(int size) {
            return new WearableSensingDataRequest[size];
        }

        @Override
        public WearableSensingDataRequest createFromParcel(@NonNull Parcel in) {
            int dataType = in.readInt();
            PersistableBundle requestDetails = in.readTypedObject(PersistableBundle.CREATOR);
            return new WearableSensingDataRequest(dataType, requestDetails);
        }
    };

    private WearableSensingDataRequest(int dataType, @NonNull PersistableBundle requestDetails) {
        this.mDataType = dataType;
        this.mRequestDetails = requestDetails;
    }

    public int getDataType() {
        return this.mDataType;
    }

    @NonNull
    public PersistableBundle getRequestDetails() {
        return this.mRequestDetails;
    }

    public int getDataSize() {
        Parcel parcel = Parcel.obtain();
        try {
            this.writeToParcel(parcel, this.describeContents());
            int n = parcel.dataSize();
            return n;
        }
        finally {
            parcel.recycle();
        }
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mDataType);
        dest.writeTypedObject(this.mRequestDetails, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "WearableSensingDataRequest { dataType = " + this.mDataType + ", requestDetails = " + this.mRequestDetails + " }";
    }

    public String toExpandedString() {
        if (this.mRequestDetails != null) {
            boolean bl = this.mRequestDetails.getBoolean("PlaceholderForWearableSensingDataRequest#toExpandedString()");
        }
        return this.toString();
    }

    public static int getMaxRequestSize() {
        return 200;
    }

    @NonNull
    public static Duration getRateLimitWindowSize() {
        return RATE_LIMIT_WINDOW_SIZE;
    }

    public static int getRateLimit() {
        return 30;
    }

    public static class Builder {
        private int mDataType;
        private PersistableBundle mRequestDetails;

        public Builder(int dataType) {
            this.mDataType = dataType;
        }

        @NonNull
        public Builder setRequestDetails(@NonNull PersistableBundle requestDetails) {
            this.mRequestDetails = requestDetails;
            return this;
        }

        @NonNull
        public WearableSensingDataRequest build() {
            if (this.mRequestDetails == null) {
                this.mRequestDetails = PersistableBundle.EMPTY;
            }
            return new WearableSensingDataRequest(this.mDataType, this.mRequestDetails);
        }
    }
}

