/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.app.usage.IStorageStatsManager;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.internal.hidden_from_bootclasspath.android.app.usage.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class StorageStats
implements Parcelable {
    public String packageName;
    public int userHandle;
    public int uid;
    public long codeBytes;
    public long dataBytes;
    public long cacheBytes;
    public long apkBytes;
    public long libBytes;
    public long dmBytes;
    public long dexoptBytes;
    public long curProfBytes;
    public long refProfBytes;
    public long externalCacheBytes;
    @FlaggedApi(value="android.app.usage.get_app_bytes_by_data_type_api")
    public static final int APP_DATA_TYPE_FILE_TYPE_DEXOPT_ARTIFACT = 0;
    @FlaggedApi(value="android.app.usage.get_app_bytes_by_data_type_api")
    public static final int APP_DATA_TYPE_FILE_TYPE_REFERENCE_PROFILE = 1;
    @FlaggedApi(value="android.app.usage.get_app_bytes_by_data_type_api")
    public static final int APP_DATA_TYPE_FILE_TYPE_CURRENT_PROFILE = 2;
    @FlaggedApi(value="android.app.usage.get_app_bytes_by_data_type_api")
    public static final int APP_DATA_TYPE_FILE_TYPE_APK = 3;
    @FlaggedApi(value="android.app.usage.get_app_bytes_by_data_type_api")
    public static final int APP_DATA_TYPE_FILE_TYPE_DM = 4;
    @FlaggedApi(value="android.app.usage.get_app_bytes_by_data_type_api")
    public static final int APP_DATA_TYPE_LIB = 5;
    private static final String TAG = "StorageStats";
    private boolean artStatsFetched;
    @NonNull
    public static final Parcelable.Creator<StorageStats> CREATOR = new Parcelable.Creator<StorageStats>(){

        @Override
        public StorageStats createFromParcel(Parcel in) {
            return new StorageStats(in);
        }

        public StorageStats[] newArray(int size) {
            return new StorageStats[size];
        }
    };

    public long getAppBytes() {
        return this.codeBytes;
    }

    @FlaggedApi(value="android.app.usage.get_app_bytes_by_data_type_api")
    public long getAppBytesByDataType(int dataType) {
        switch (dataType) {
            case 0: {
                return this.getDexoptBytes();
            }
            case 1: {
                return this.getRefProfBytes();
            }
            case 2: {
                return this.getCurProfBytes();
            }
            case 3: {
                return this.apkBytes;
            }
            case 5: {
                return this.libBytes;
            }
            case 4: {
                return this.dmBytes;
            }
        }
        return 0L;
    }

    public long getDataBytes() {
        return this.dataBytes;
    }

    public long getCacheBytes() {
        return this.cacheBytes;
    }

    public long getExternalCacheBytes() {
        return this.externalCacheBytes;
    }

    public StorageStats() {
    }

    public StorageStats(Parcel in) {
        this.packageName = in.readString8();
        this.userHandle = in.readInt();
        this.uid = in.readInt();
        this.codeBytes = in.readLong();
        this.dataBytes = in.readLong();
        this.cacheBytes = in.readLong();
        this.dexoptBytes = in.readLong();
        this.refProfBytes = in.readLong();
        this.curProfBytes = in.readLong();
        this.apkBytes = in.readLong();
        this.libBytes = in.readLong();
        this.dmBytes = in.readLong();
        this.externalCacheBytes = in.readLong();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString8(this.packageName);
        dest.writeInt(this.userHandle);
        dest.writeInt(this.uid);
        dest.writeLong(this.codeBytes);
        dest.writeLong(this.dataBytes);
        dest.writeLong(this.cacheBytes);
        dest.writeLong(this.dexoptBytes);
        dest.writeLong(this.refProfBytes);
        dest.writeLong(this.curProfBytes);
        dest.writeLong(this.apkBytes);
        dest.writeLong(this.libBytes);
        dest.writeLong(this.dmBytes);
        dest.writeLong(this.externalCacheBytes);
    }

    private void getArtManagedStats() {
        try {
            if (Flags.getAppArtManagedBytes() && !this.artStatsFetched) {
                IBinder binder = ServiceManager.getService("storagestats");
                IStorageStatsManager storageStatsManagerService = IStorageStatsManager.Stub.asInterface(binder);
                StorageStats newStats = storageStatsManagerService.queryArtManagedStats(this.packageName, this.userHandle, this.uid);
                this.dexoptBytes = newStats.dexoptBytes;
                this.curProfBytes = newStats.curProfBytes;
                this.refProfBytes = newStats.refProfBytes;
                this.artStatsFetched = true;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get art stats", e);
            e.rethrowFromSystemServer();
        }
    }

    private long getDexoptBytes() {
        this.getArtManagedStats();
        return this.dexoptBytes;
    }

    private long getCurProfBytes() {
        this.getArtManagedStats();
        return this.curProfBytes;
    }

    private long getRefProfBytes() {
        this.getArtManagedStats();
        return this.refProfBytes;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @FlaggedApi(value="android.app.usage.get_app_bytes_by_data_type_api")
    public static @interface AppDataType {
    }
}

