/*
 * Decompiled with CFR 0.152.
 */
package android.app.supervision;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import com.android.layoutlib.androidx.annotation.Keep;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.StringJoiner;

@SystemApi
@FlaggedApi(value="android.app.supervision.flags.supervision_manager_apis")
public class SupervisionRecoveryInfo
implements Parcelable {
    public static final String EXTRA_SUPERVISION_RECOVERY_INFO = "android.app.supervision.extra.SUPERVISION_RECOVERY_INFO";
    @NonNull
    public static final Parcelable.Creator<SupervisionRecoveryInfo> CREATOR = new Parcelable.Creator<SupervisionRecoveryInfo>(){

        @Override
        public SupervisionRecoveryInfo createFromParcel(@NonNull Parcel source) {
            String accountName = source.readString();
            String accountType = source.readString();
            PersistableBundle accountData = source.readPersistableBundle(this.getClass().getClassLoader());
            int state = source.readInt();
            if (accountName != null && accountType != null) {
                return new SupervisionRecoveryInfo(accountName, accountType, state, accountData);
            }
            return null;
        }

        public SupervisionRecoveryInfo[] newArray(int size) {
            return new SupervisionRecoveryInfo[size];
        }
    };
    public static final int STATE_PENDING = 0;
    public static final int STATE_VERIFIED = 1;
    @NonNull
    private String mAccountName;
    @NonNull
    private String mAccountType;
    @Nullable
    private PersistableBundle mAccountData;
    private int mState;

    public SupervisionRecoveryInfo(@NonNull String accountName, @NonNull String accountType, int state, @Nullable PersistableBundle accountData) {
        this.mAccountName = accountName;
        this.mAccountType = accountType;
        this.mAccountData = accountData;
        this.mState = state;
    }

    @NonNull
    public String getAccountName() {
        return this.mAccountName;
    }

    @NonNull
    public String getAccountType() {
        return this.mAccountType;
    }

    @NonNull
    public PersistableBundle getAccountData() {
        return this.mAccountData == null ? new PersistableBundle() : this.mAccountData;
    }

    public int getState() {
        return this.mState;
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int flag) {
        parcel.writeString(this.mAccountName);
        parcel.writeString(this.mAccountType);
        parcel.writePersistableBundle(this.mAccountData);
        parcel.writeInt(this.mState);
    }

    public void readFromParcel(@NonNull Parcel parcel) {
        this.mAccountName = Objects.requireNonNull(parcel.readString());
        this.mAccountType = Objects.requireNonNull(parcel.readString());
        this.mAccountData = parcel.readPersistableBundle(this.getClass().getClassLoader());
        this.mState = parcel.readInt();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "{", "}");
        joiner.add("accountName: " + this.mAccountName);
        joiner.add("accountType: " + this.mAccountType);
        joiner.add("accountData: " + this.mAccountData);
        joiner.add("state: " + this.mState);
        return "SupervisionRecoveryInfo" + joiner;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SupervisionRecoveryInfo)) {
            return false;
        }
        SupervisionRecoveryInfo that = (SupervisionRecoveryInfo)other;
        return Objects.equals(this.mAccountName, that.mAccountName) && Objects.equals(this.mAccountType, that.mAccountType) && Objects.equals(this.mAccountData, that.mAccountData) && this.mState == that.mState;
    }

    public int hashCode() {
        return Objects.hash(this.mAccountName, this.mAccountType, this.mAccountData, this.mState);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Keep
    public static @interface State {
    }
}

