/*
 * Decompiled with CFR 0.152.
 */
package android.app.supervision;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.supervision.ISupervisionListener;
import android.app.supervision.ISupervisionManager;
import android.app.supervision.SupervisionRecoveryInfo;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.Intent;
import android.os.RemoteException;

@SystemApi
@FlaggedApi(value="android.app.supervision.flags.supervision_manager_apis")
public class SupervisionManager {
    private final Context mContext;
    @Nullable
    private final ISupervisionManager mService;
    @SystemApi
    @FlaggedApi(value="android.app.supervision.flags.supervision_manager_apis")
    public static final String ACTION_ENABLE_SUPERVISION = "android.app.supervision.action.ENABLE_SUPERVISION";
    @SystemApi
    @FlaggedApi(value="android.app.supervision.flags.supervision_manager_apis")
    public static final String ACTION_DISABLE_SUPERVISION = "android.app.supervision.action.DISABLE_SUPERVISION";

    @UnsupportedAppUsage
    public SupervisionManager(Context context, @Nullable ISupervisionManager service) {
        this.mContext = context;
        this.mService = service;
    }

    @SystemApi
    @FlaggedApi(value="android.app.supervision.flags.supervision_manager_apis")
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.QUERY_USERS"})
    @Nullable
    public Intent createConfirmSupervisionCredentialsIntent() {
        if (this.mService != null) {
            try {
                Intent result = this.mService.createConfirmSupervisionCredentialsIntent(this.mContext.getUserId());
                if (result != null) {
                    result.prepareToEnterProcess(32, this.mContext.getAttributionSource());
                }
                return result;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    @SystemApi
    @FlaggedApi(value="android.app.supervision.flags.supervision_manager_apis")
    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.QUERY_USERS"})
    public boolean isSupervisionEnabled() {
        return this.isSupervisionEnabledForUser(this.mContext.getUserId());
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.QUERY_USERS"})
    public boolean isSupervisionEnabledForUser(int userId) {
        if (this.mService != null) {
            try {
                return this.mService.isSupervisionEnabledForUser(userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void setSupervisionEnabled(boolean enabled) {
        this.setSupervisionEnabledForUser(this.mContext.getUserId(), enabled);
    }

    public void setSupervisionEnabledForUser(int userId, boolean enabled) {
        if (this.mService != null) {
            try {
                this.mService.setSupervisionEnabledForUser(userId, enabled);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Nullable
    public String getActiveSupervisionAppPackage() {
        if (this.mService != null) {
            try {
                return this.mService.getActiveSupervisionAppPackage(this.mContext.getUserId());
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    @SystemApi
    @FlaggedApi(value="android.permission.flags.enable_system_supervision_role_behavior")
    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    public boolean shouldAllowBypassingSupervisionRoleQualification() {
        if (this.mService != null) {
            try {
                return this.mService.shouldAllowBypassingSupervisionRoleQualification();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void setSupervisionRecoveryInfo(SupervisionRecoveryInfo recoveryInfo) {
        if (this.mService != null) {
            try {
                this.mService.setSupervisionRecoveryInfo(recoveryInfo);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    @Nullable
    public SupervisionRecoveryInfo getSupervisionRecoveryInfo() {
        if (this.mService != null) {
            try {
                return this.mService.getSupervisionRecoveryInfo();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return null;
    }

    @RequiresPermission(anyOf={"android.permission.MANAGE_USERS", "android.permission.QUERY_USERS"})
    public boolean hasSupervisionCredentials() {
        if (this.mService != null) {
            try {
                return this.mService.hasSupervisionCredentials();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return false;
    }

    public void registerSupervisionListener(@NonNull SupervisionListener listener) {
        if (this.mService != null) {
            try {
                this.mService.registerSupervisionListener(listener.mListener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void unregisterSupervisionListener(@NonNull SupervisionListener listener) {
        if (this.mService != null) {
            try {
                this.mService.unregisterSupervisionListener(listener.mListener);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public static abstract class SupervisionListener {
        protected final ISupervisionListener mListener = new ISupervisionListener.Stub(){

            @Override
            public void onSetSupervisionEnabled(int userId, boolean enabled) {
                if (enabled) {
                    this.onSupervisionEnabled(userId);
                } else {
                    this.onSupervisionDisabled(userId);
                }
            }
        };

        public abstract void onSupervisionEnabled(int var1);

        public abstract void onSupervisionDisabled(int var1);
    }
}

