/*
 * Decompiled with CFR 0.152.
 */
package android.app.smartspace.uitemplatedata;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.smartspace.SmartspaceUtils;
import android.app.smartspace.uitemplatedata.Icon;
import android.app.smartspace.uitemplatedata.TapAction;
import android.app.smartspace.uitemplatedata.Text;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.Objects;

@SystemApi
@SuppressLint(value={"ParcelNotFinal"})
public class BaseTemplateData
implements Parcelable {
    private final int mTemplateType;
    @Nullable
    private final SubItemInfo mPrimaryItem;
    @Nullable
    private final SubItemInfo mSubtitleItem;
    @Nullable
    private final SubItemInfo mSubtitleSupplementalItem;
    @Nullable
    private final SubItemInfo mSupplementalLineItem;
    @Nullable
    private final SubItemInfo mSupplementalAlarmItem;
    private final int mLayoutWeight;
    @NonNull
    public static final Parcelable.Creator<BaseTemplateData> CREATOR = new Parcelable.Creator<BaseTemplateData>(){

        @Override
        public BaseTemplateData createFromParcel(Parcel in) {
            return new BaseTemplateData(in);
        }

        public BaseTemplateData[] newArray(int size) {
            return new BaseTemplateData[size];
        }
    };

    BaseTemplateData(@NonNull Parcel in) {
        this.mTemplateType = in.readInt();
        this.mPrimaryItem = in.readTypedObject(SubItemInfo.CREATOR);
        this.mSubtitleItem = in.readTypedObject(SubItemInfo.CREATOR);
        this.mSubtitleSupplementalItem = in.readTypedObject(SubItemInfo.CREATOR);
        this.mSupplementalLineItem = in.readTypedObject(SubItemInfo.CREATOR);
        this.mSupplementalAlarmItem = in.readTypedObject(SubItemInfo.CREATOR);
        this.mLayoutWeight = in.readInt();
    }

    BaseTemplateData(int templateType, @Nullable SubItemInfo primaryItem, @Nullable SubItemInfo subtitleItem, @Nullable SubItemInfo subtitleSupplementalItem, @Nullable SubItemInfo supplementalLineItem, @Nullable SubItemInfo supplementalAlarmItem, int layoutWeight) {
        this.mTemplateType = templateType;
        this.mPrimaryItem = primaryItem;
        this.mSubtitleItem = subtitleItem;
        this.mSubtitleSupplementalItem = subtitleSupplementalItem;
        this.mSupplementalLineItem = supplementalLineItem;
        this.mSupplementalAlarmItem = supplementalAlarmItem;
        this.mLayoutWeight = layoutWeight;
    }

    public int getTemplateType() {
        return this.mTemplateType;
    }

    @Nullable
    public SubItemInfo getPrimaryItem() {
        return this.mPrimaryItem;
    }

    @Nullable
    public SubItemInfo getSubtitleItem() {
        return this.mSubtitleItem;
    }

    @Nullable
    public SubItemInfo getSubtitleSupplementalItem() {
        return this.mSubtitleSupplementalItem;
    }

    @Nullable
    public SubItemInfo getSupplementalLineItem() {
        return this.mSupplementalLineItem;
    }

    @Nullable
    public SubItemInfo getSupplementalAlarmItem() {
        return this.mSupplementalAlarmItem;
    }

    public int getLayoutWeight() {
        return this.mLayoutWeight;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeInt(this.mTemplateType);
        out.writeTypedObject(this.mPrimaryItem, flags);
        out.writeTypedObject(this.mSubtitleItem, flags);
        out.writeTypedObject(this.mSubtitleSupplementalItem, flags);
        out.writeTypedObject(this.mSupplementalLineItem, flags);
        out.writeTypedObject(this.mSupplementalAlarmItem, flags);
        out.writeInt(this.mLayoutWeight);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseTemplateData)) {
            return false;
        }
        BaseTemplateData that = (BaseTemplateData)o;
        return this.mTemplateType == that.mTemplateType && this.mLayoutWeight == that.mLayoutWeight && Objects.equals(this.mPrimaryItem, that.mPrimaryItem) && Objects.equals(this.mSubtitleItem, that.mSubtitleItem) && Objects.equals(this.mSubtitleSupplementalItem, that.mSubtitleSupplementalItem) && Objects.equals(this.mSupplementalLineItem, that.mSupplementalLineItem) && Objects.equals(this.mSupplementalAlarmItem, that.mSupplementalAlarmItem);
    }

    public int hashCode() {
        return Objects.hash(this.mTemplateType, this.mPrimaryItem, this.mSubtitleItem, this.mSubtitleSupplementalItem, this.mSupplementalLineItem, this.mSupplementalAlarmItem, this.mLayoutWeight);
    }

    public String toString() {
        return "BaseTemplateData{mTemplateType=" + this.mTemplateType + ", mPrimaryItem=" + this.mPrimaryItem + ", mSubtitleItem=" + this.mSubtitleItem + ", mSubtitleSupplementalItem=" + this.mSubtitleSupplementalItem + ", mSupplementalLineItem=" + this.mSupplementalLineItem + ", mSupplementalAlarmItem=" + this.mSupplementalAlarmItem + ", mLayoutWeight=" + this.mLayoutWeight + '}';
    }

    public static class SubItemInfo
    implements Parcelable {
        @Nullable
        private final Text mText;
        @Nullable
        private final Icon mIcon;
        @Nullable
        private final TapAction mTapAction;
        @Nullable
        private final SubItemLoggingInfo mLoggingInfo;
        @NonNull
        public static final Parcelable.Creator<SubItemInfo> CREATOR = new Parcelable.Creator<SubItemInfo>(){

            @Override
            public SubItemInfo createFromParcel(Parcel in) {
                return new SubItemInfo(in);
            }

            public SubItemInfo[] newArray(int size) {
                return new SubItemInfo[size];
            }
        };

        SubItemInfo(@NonNull Parcel in) {
            this.mText = in.readTypedObject(Text.CREATOR);
            this.mIcon = in.readTypedObject(Icon.CREATOR);
            this.mTapAction = in.readTypedObject(TapAction.CREATOR);
            this.mLoggingInfo = in.readTypedObject(SubItemLoggingInfo.CREATOR);
        }

        private SubItemInfo(@Nullable Text text, @Nullable Icon icon, @Nullable TapAction tapAction, @Nullable SubItemLoggingInfo loggingInfo) {
            this.mText = text;
            this.mIcon = icon;
            this.mTapAction = tapAction;
            this.mLoggingInfo = loggingInfo;
        }

        @Nullable
        public Text getText() {
            return this.mText;
        }

        @Nullable
        public Icon getIcon() {
            return this.mIcon;
        }

        @Nullable
        public TapAction getTapAction() {
            return this.mTapAction;
        }

        @Nullable
        public SubItemLoggingInfo getLoggingInfo() {
            return this.mLoggingInfo;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel out, int flags) {
            out.writeTypedObject(this.mText, flags);
            out.writeTypedObject(this.mIcon, flags);
            out.writeTypedObject(this.mTapAction, flags);
            out.writeTypedObject(this.mLoggingInfo, flags);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SubItemInfo)) {
                return false;
            }
            SubItemInfo that = (SubItemInfo)o;
            return SmartspaceUtils.isEqual(this.mText, that.mText) && Objects.equals(this.mIcon, that.mIcon) && Objects.equals(this.mTapAction, that.mTapAction) && Objects.equals(this.mLoggingInfo, that.mLoggingInfo);
        }

        public int hashCode() {
            return Objects.hash(this.mText, this.mIcon, this.mTapAction, this.mLoggingInfo);
        }

        public String toString() {
            return "SubItemInfo{mText=" + this.mText + ", mIcon=" + this.mIcon + ", mTapAction=" + this.mTapAction + ", mLoggingInfo=" + this.mLoggingInfo + '}';
        }

        @SystemApi
        public static class Builder {
            private Text mText;
            private Icon mIcon;
            private TapAction mTapAction;
            private SubItemLoggingInfo mLoggingInfo;

            @NonNull
            public Builder setText(@NonNull Text text) {
                this.mText = text;
                return this;
            }

            @NonNull
            public Builder setIcon(@NonNull Icon icon) {
                this.mIcon = icon;
                return this;
            }

            @NonNull
            public Builder setTapAction(@NonNull TapAction tapAction) {
                this.mTapAction = tapAction;
                return this;
            }

            @NonNull
            public Builder setLoggingInfo(@NonNull SubItemLoggingInfo loggingInfo) {
                this.mLoggingInfo = loggingInfo;
                return this;
            }

            @NonNull
            public SubItemInfo build() {
                if (SmartspaceUtils.isEmpty(this.mText) && this.mIcon == null && this.mTapAction == null && this.mLoggingInfo == null) {
                    throw new IllegalStateException("SubItem data is empty");
                }
                return new SubItemInfo(this.mText, this.mIcon, this.mTapAction, this.mLoggingInfo);
            }
        }
    }

    public static class SubItemLoggingInfo
    implements Parcelable {
        private final int mInstanceId;
        private final int mFeatureType;
        @Nullable
        private final CharSequence mPackageName;
        @NonNull
        public static final Parcelable.Creator<SubItemLoggingInfo> CREATOR = new Parcelable.Creator<SubItemLoggingInfo>(){

            @Override
            public SubItemLoggingInfo createFromParcel(Parcel in) {
                return new SubItemLoggingInfo(in);
            }

            public SubItemLoggingInfo[] newArray(int size) {
                return new SubItemLoggingInfo[size];
            }
        };

        SubItemLoggingInfo(@NonNull Parcel in) {
            this.mInstanceId = in.readInt();
            this.mFeatureType = in.readInt();
            this.mPackageName = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        }

        private SubItemLoggingInfo(int instanceId, int featureType, @Nullable CharSequence packageName) {
            this.mInstanceId = instanceId;
            this.mFeatureType = featureType;
            this.mPackageName = packageName;
        }

        public int getInstanceId() {
            return this.mInstanceId;
        }

        public int getFeatureType() {
            return this.mFeatureType;
        }

        @Nullable
        public CharSequence getPackageName() {
            return this.mPackageName;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel out, int flags) {
            out.writeInt(this.mInstanceId);
            out.writeInt(this.mFeatureType);
            TextUtils.writeToParcel(this.mPackageName, out, flags);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SubItemLoggingInfo)) {
                return false;
            }
            SubItemLoggingInfo that = (SubItemLoggingInfo)o;
            return this.mInstanceId == that.mInstanceId && this.mFeatureType == that.mFeatureType && SmartspaceUtils.isEqual(this.mPackageName, that.mPackageName);
        }

        public int hashCode() {
            return Objects.hash(this.mInstanceId, this.mFeatureType, this.mPackageName);
        }

        public String toString() {
            return "SubItemLoggingInfo{mInstanceId=" + this.mInstanceId + ", mFeatureType=" + this.mFeatureType + ", mPackageName=" + this.mPackageName + '}';
        }

        @SystemApi
        public static class Builder {
            private final int mInstanceId;
            private final int mFeatureType;
            private CharSequence mPackageName;

            public Builder(int instanceId, int featureType) {
                this.mInstanceId = instanceId;
                this.mFeatureType = featureType;
            }

            @NonNull
            public Builder setPackageName(@NonNull CharSequence packageName) {
                this.mPackageName = packageName;
                return this;
            }

            @NonNull
            public SubItemLoggingInfo build() {
                return new SubItemLoggingInfo(this.mInstanceId, this.mFeatureType, this.mPackageName);
            }
        }
    }

    @SystemApi
    @SuppressLint(value={"StaticFinalBuilder"})
    public static class Builder {
        private final int mTemplateType;
        private SubItemInfo mPrimaryItem;
        private SubItemInfo mSubtitleItem;
        private SubItemInfo mSubtitleSupplementalItem;
        private SubItemInfo mSupplementalLineItem;
        private SubItemInfo mSupplementalAlarmItem;
        private int mLayoutWeight;

        public Builder(int templateType) {
            this.mTemplateType = templateType;
            this.mLayoutWeight = 0;
        }

        @SuppressLint(value={"GetterOnBuilder"})
        int getTemplateType() {
            return this.mTemplateType;
        }

        @Nullable
        @SuppressLint(value={"GetterOnBuilder"})
        SubItemInfo getPrimaryItem() {
            return this.mPrimaryItem;
        }

        @Nullable
        @SuppressLint(value={"GetterOnBuilder"})
        SubItemInfo getSubtitleItem() {
            return this.mSubtitleItem;
        }

        @Nullable
        @SuppressLint(value={"GetterOnBuilder"})
        SubItemInfo getSubtitleSupplemtnalItem() {
            return this.mSubtitleSupplementalItem;
        }

        @Nullable
        @SuppressLint(value={"GetterOnBuilder"})
        SubItemInfo getSupplementalLineItem() {
            return this.mSupplementalLineItem;
        }

        @Nullable
        @SuppressLint(value={"GetterOnBuilder"})
        SubItemInfo getSupplementalAlarmItem() {
            return this.mSupplementalAlarmItem;
        }

        @SuppressLint(value={"GetterOnBuilder"})
        int getLayoutWeight() {
            return this.mLayoutWeight;
        }

        @NonNull
        public Builder setPrimaryItem(@NonNull SubItemInfo primaryItem) {
            this.mPrimaryItem = primaryItem;
            return this;
        }

        @NonNull
        public Builder setSubtitleItem(@NonNull SubItemInfo subtitleItem) {
            this.mSubtitleItem = subtitleItem;
            return this;
        }

        @NonNull
        public Builder setSubtitleSupplementalItem(@NonNull SubItemInfo subtitleSupplementalItem) {
            this.mSubtitleSupplementalItem = subtitleSupplementalItem;
            return this;
        }

        @NonNull
        public Builder setSupplementalLineItem(@NonNull SubItemInfo supplementalLineItem) {
            this.mSupplementalLineItem = supplementalLineItem;
            return this;
        }

        @NonNull
        public Builder setSupplementalAlarmItem(@NonNull SubItemInfo supplementalAlarmItem) {
            this.mSupplementalAlarmItem = supplementalAlarmItem;
            return this;
        }

        @NonNull
        public Builder setLayoutWeight(int layoutWeight) {
            this.mLayoutWeight = layoutWeight;
            return this;
        }

        @NonNull
        public BaseTemplateData build() {
            return new BaseTemplateData(this.mTemplateType, this.mPrimaryItem, this.mSubtitleItem, this.mSubtitleSupplementalItem, this.mSupplementalLineItem, this.mSupplementalAlarmItem, this.mLayoutWeight);
        }
    }
}

