/*
 * Decompiled with CFR 0.152.
 */
package android.app.smartspace;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.content.Intent;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.text.TextUtils;
import java.util.Objects;

@SystemApi
public class SmartspaceAction
implements Parcelable {
    private static final String TAG = "SmartspaceAction";
    @NonNull
    private final String mId;
    @Nullable
    private final Icon mIcon;
    @NonNull
    private final CharSequence mTitle;
    @Nullable
    private final CharSequence mSubtitle;
    @Nullable
    private final CharSequence mContentDescription;
    @Nullable
    private final PendingIntent mPendingIntent;
    @Nullable
    private final Intent mIntent;
    @Nullable
    private final UserHandle mUserHandle;
    @Nullable
    private Bundle mExtras;
    @NonNull
    public static final Parcelable.Creator<SmartspaceAction> CREATOR = new Parcelable.Creator<SmartspaceAction>(){

        @Override
        public SmartspaceAction createFromParcel(Parcel in) {
            return new SmartspaceAction(in);
        }

        public SmartspaceAction[] newArray(int size) {
            return new SmartspaceAction[size];
        }
    };

    SmartspaceAction(Parcel in) {
        this.mId = in.readString();
        this.mIcon = in.readTypedObject(Icon.CREATOR);
        this.mTitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mSubtitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mContentDescription = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mPendingIntent = in.readTypedObject(PendingIntent.CREATOR);
        this.mIntent = in.readTypedObject(Intent.CREATOR);
        this.mUserHandle = in.readTypedObject(UserHandle.CREATOR);
        this.mExtras = in.readBundle();
    }

    private SmartspaceAction(@NonNull String id2, @Nullable Icon icon, @NonNull CharSequence title, @Nullable CharSequence subtitle, @Nullable CharSequence contentDescription, @Nullable PendingIntent pendingIntent, @Nullable Intent intent, @Nullable UserHandle userHandle, @Nullable Bundle extras) {
        this.mId = Objects.requireNonNull(id2);
        this.mIcon = icon;
        this.mTitle = Objects.requireNonNull(title);
        this.mSubtitle = subtitle;
        this.mContentDescription = contentDescription;
        this.mPendingIntent = pendingIntent;
        this.mIntent = intent;
        this.mUserHandle = userHandle;
        this.mExtras = extras;
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    @Nullable
    public Icon getIcon() {
        return this.mIcon;
    }

    @NonNull
    public CharSequence getTitle() {
        return this.mTitle;
    }

    @Nullable
    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    @Nullable
    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    @Nullable
    public PendingIntent getPendingIntent() {
        return this.mPendingIntent;
    }

    @Nullable
    public Intent getIntent() {
        return this.mIntent;
    }

    @Nullable
    public UserHandle getUserHandle() {
        return this.mUserHandle;
    }

    @SuppressLint(value={"NullableCollection"})
    @Nullable
    public Bundle getExtras() {
        return this.mExtras;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SmartspaceAction)) {
            return false;
        }
        SmartspaceAction that = (SmartspaceAction)o;
        return this.mId.equals(that.mId);
    }

    public int hashCode() {
        return Objects.hash(this.mId);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeString(this.mId);
        out.writeTypedObject(this.mIcon, flags);
        TextUtils.writeToParcel(this.mTitle, out, flags);
        TextUtils.writeToParcel(this.mSubtitle, out, flags);
        TextUtils.writeToParcel(this.mContentDescription, out, flags);
        out.writeTypedObject(this.mPendingIntent, flags);
        out.writeTypedObject(this.mIntent, flags);
        out.writeTypedObject(this.mUserHandle, flags);
        out.writeBundle(this.mExtras);
    }

    public String toString() {
        return "SmartspaceAction{mId='" + this.mId + '\'' + ", mIcon=" + this.mIcon + ", mTitle=" + this.mTitle + ", mSubtitle=" + this.mSubtitle + ", mContentDescription=" + this.mContentDescription + ", mPendingIntent=" + this.mPendingIntent + ", mIntent=" + this.mIntent + ", mUserHandle=" + this.mUserHandle + ", mExtras=" + this.mExtras + '}';
    }

    @SystemApi
    public static class Builder {
        @NonNull
        private String mId;
        @Nullable
        private Icon mIcon;
        @NonNull
        private CharSequence mTitle;
        @Nullable
        private CharSequence mSubtitle;
        @Nullable
        private CharSequence mContentDescription;
        @Nullable
        private PendingIntent mPendingIntent;
        @Nullable
        private Intent mIntent;
        @Nullable
        private UserHandle mUserHandle;
        @Nullable
        private Bundle mExtras;

        public Builder(@NonNull String id2, @NonNull String title) {
            this.mId = Objects.requireNonNull(id2);
            this.mTitle = Objects.requireNonNull(title);
        }

        @NonNull
        public Builder setIcon(@Nullable Icon icon) {
            this.mIcon = icon;
            return this;
        }

        @NonNull
        public Builder setSubtitle(@Nullable CharSequence subtitle) {
            this.mSubtitle = subtitle;
            return this;
        }

        @NonNull
        public Builder setContentDescription(@Nullable CharSequence contentDescription) {
            this.mContentDescription = contentDescription;
            return this;
        }

        @NonNull
        public Builder setPendingIntent(@Nullable PendingIntent pendingIntent) {
            this.mPendingIntent = pendingIntent;
            return this;
        }

        @NonNull
        public Builder setUserHandle(@Nullable UserHandle userHandle) {
            this.mUserHandle = userHandle;
            return this;
        }

        @NonNull
        public Builder setIntent(@Nullable Intent intent) {
            this.mIntent = intent;
            return this;
        }

        @NonNull
        public Builder setExtras(@SuppressLint(value={"NullableCollection"}) @Nullable Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        @NonNull
        public SmartspaceAction build() {
            if (this.mIcon != null) {
                this.mIcon.convertToAshmem();
            }
            return new SmartspaceAction(this.mId, this.mIcon, this.mTitle, this.mSubtitle, this.mContentDescription, this.mPendingIntent, this.mIntent, this.mUserHandle, this.mExtras);
        }
    }
}

