/*
 * Decompiled with CFR 0.152.
 */
package android.app.smartspace;

import android.app.smartspace.ISmartspaceCallback;
import android.app.smartspace.SmartspaceConfig;
import android.app.smartspace.SmartspaceSessionId;
import android.app.smartspace.SmartspaceTargetEvent;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ISmartspaceManager
extends IInterface {
    public static final String DESCRIPTOR = "android.app.smartspace.ISmartspaceManager";

    public void createSmartspaceSession(SmartspaceConfig var1, SmartspaceSessionId var2, IBinder var3) throws RemoteException;

    public void notifySmartspaceEvent(SmartspaceSessionId var1, SmartspaceTargetEvent var2) throws RemoteException;

    public void requestSmartspaceUpdate(SmartspaceSessionId var1) throws RemoteException;

    public void registerSmartspaceUpdates(SmartspaceSessionId var1, ISmartspaceCallback var2) throws RemoteException;

    public void unregisterSmartspaceUpdates(SmartspaceSessionId var1, ISmartspaceCallback var2) throws RemoteException;

    public void destroySmartspaceSession(SmartspaceSessionId var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISmartspaceManager {
        static final int TRANSACTION_createSmartspaceSession = 1;
        static final int TRANSACTION_notifySmartspaceEvent = 2;
        static final int TRANSACTION_requestSmartspaceUpdate = 3;
        static final int TRANSACTION_registerSmartspaceUpdates = 4;
        static final int TRANSACTION_unregisterSmartspaceUpdates = 5;
        static final int TRANSACTION_destroySmartspaceSession = 6;

        public Stub() {
            this.attachInterface(this, ISmartspaceManager.DESCRIPTOR);
        }

        public static ISmartspaceManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISmartspaceManager.DESCRIPTOR);
            if (iin != null && iin instanceof ISmartspaceManager) {
                return (ISmartspaceManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "createSmartspaceSession";
                }
                case 2: {
                    return "notifySmartspaceEvent";
                }
                case 3: {
                    return "requestSmartspaceUpdate";
                }
                case 4: {
                    return "registerSmartspaceUpdates";
                }
                case 5: {
                    return "unregisterSmartspaceUpdates";
                }
                case 6: {
                    return "destroySmartspaceSession";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISmartspaceManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    SmartspaceConfig _arg0 = data.readTypedObject(SmartspaceConfig.CREATOR);
                    SmartspaceSessionId _arg1 = data.readTypedObject(SmartspaceSessionId.CREATOR);
                    IBinder _arg2 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.createSmartspaceSession(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    SmartspaceSessionId _arg0 = data.readTypedObject(SmartspaceSessionId.CREATOR);
                    SmartspaceTargetEvent _arg1 = data.readTypedObject(SmartspaceTargetEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifySmartspaceEvent(_arg0, _arg1);
                    break;
                }
                case 3: {
                    SmartspaceSessionId _arg0 = data.readTypedObject(SmartspaceSessionId.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestSmartspaceUpdate(_arg0);
                    break;
                }
                case 4: {
                    SmartspaceSessionId _arg0 = data.readTypedObject(SmartspaceSessionId.CREATOR);
                    ISmartspaceCallback _arg1 = ISmartspaceCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerSmartspaceUpdates(_arg0, _arg1);
                    break;
                }
                case 5: {
                    SmartspaceSessionId _arg0 = data.readTypedObject(SmartspaceSessionId.CREATOR);
                    ISmartspaceCallback _arg1 = ISmartspaceCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterSmartspaceUpdates(_arg0, _arg1);
                    break;
                }
                case 6: {
                    SmartspaceSessionId _arg0 = data.readTypedObject(SmartspaceSessionId.CREATOR);
                    data.enforceNoDataAvail();
                    this.destroySmartspaceSession(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 5;
        }

        private static class Proxy
        implements ISmartspaceManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISmartspaceManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createSmartspaceSession(SmartspaceConfig config, SmartspaceSessionId sessionId, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISmartspaceManager.DESCRIPTOR);
                    _data.writeTypedObject(config, 0);
                    _data.writeTypedObject(sessionId, 0);
                    _data.writeStrongBinder(token);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifySmartspaceEvent(SmartspaceSessionId sessionId, SmartspaceTargetEvent event) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISmartspaceManager.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    _data.writeTypedObject(event, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestSmartspaceUpdate(SmartspaceSessionId sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISmartspaceManager.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSmartspaceUpdates(SmartspaceSessionId sessionId, ISmartspaceCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISmartspaceManager.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSmartspaceUpdates(SmartspaceSessionId sessionId, ISmartspaceCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISmartspaceManager.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroySmartspaceSession(SmartspaceSessionId sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISmartspaceManager.DESCRIPTOR);
                    _data.writeTypedObject(sessionId, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISmartspaceManager {
        @Override
        public void createSmartspaceSession(SmartspaceConfig config, SmartspaceSessionId sessionId, IBinder token) throws RemoteException {
        }

        @Override
        public void notifySmartspaceEvent(SmartspaceSessionId sessionId, SmartspaceTargetEvent event) throws RemoteException {
        }

        @Override
        public void requestSmartspaceUpdate(SmartspaceSessionId sessionId) throws RemoteException {
        }

        @Override
        public void registerSmartspaceUpdates(SmartspaceSessionId sessionId, ISmartspaceCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterSmartspaceUpdates(SmartspaceSessionId sessionId, ISmartspaceCallback callback) throws RemoteException {
        }

        @Override
        public void destroySmartspaceSession(SmartspaceSessionId sessionId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

