/*
 * Decompiled with CFR 0.152.
 */
package android.app.servertransaction;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityClient;
import android.app.ActivityThread;
import android.app.ClientTransactionHandler;
import android.app.servertransaction.ActivityLifecycleItem;
import android.app.servertransaction.PendingTransactionActions;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Trace;

public class ResumeActivityItem
extends ActivityLifecycleItem {
    private final int mProcState;
    private final boolean mIsForward;
    private final boolean mShouldSendCompatFakeFocus;
    @NonNull
    public static final Parcelable.Creator<ResumeActivityItem> CREATOR = new Parcelable.Creator<ResumeActivityItem>(){

        @Override
        public ResumeActivityItem createFromParcel(Parcel in) {
            return new ResumeActivityItem(in);
        }

        public ResumeActivityItem[] newArray(int size) {
            return new ResumeActivityItem[size];
        }
    };

    public ResumeActivityItem(@NonNull IBinder activityToken, boolean isForward, boolean shouldSendCompatFakeFocus) {
        this(activityToken, -1, isForward, shouldSendCompatFakeFocus);
    }

    public ResumeActivityItem(@NonNull IBinder activityToken, int procState, boolean isForward, boolean shouldSendCompatFakeFocus) {
        super(activityToken);
        this.mProcState = procState;
        this.mIsForward = isForward;
        this.mShouldSendCompatFakeFocus = shouldSendCompatFakeFocus;
    }

    @Override
    public void preExecute(@NonNull ClientTransactionHandler client) {
        if (this.mProcState != -1) {
            client.updateProcessState(this.mProcState, false);
        }
    }

    @Override
    public void execute(@NonNull ClientTransactionHandler client, @NonNull ActivityThread.ActivityClientRecord r, @NonNull PendingTransactionActions pendingActions) {
        Trace.traceBegin(64L, "activityResume");
        client.handleResumeActivity(r, true, this.mIsForward, this.mShouldSendCompatFakeFocus, "RESUME_ACTIVITY");
        Trace.traceEnd(64L);
    }

    @Override
    public void postExecute(@NonNull ClientTransactionHandler client, @NonNull PendingTransactionActions pendingActions) {
        ActivityClient.getInstance().activityResumed(this.getActivityToken(), client.isHandleSplashScreenExit(this.getActivityToken()));
    }

    @Override
    public int getTargetState() {
        return 3;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(this.mProcState);
        dest.writeBoolean(this.mIsForward);
        dest.writeBoolean(this.mShouldSendCompatFakeFocus);
    }

    private ResumeActivityItem(@NonNull Parcel in) {
        super(in);
        this.mProcState = in.readInt();
        this.mIsForward = in.readBoolean();
        this.mShouldSendCompatFakeFocus = in.readBoolean();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResumeActivityItem other = (ResumeActivityItem)o;
        return this.mProcState == other.mProcState && this.mIsForward == other.mIsForward && this.mShouldSendCompatFakeFocus == other.mShouldSendCompatFakeFocus;
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + super.hashCode();
        result = 31 * result + this.mProcState;
        result = 31 * result + (this.mIsForward ? 1 : 0);
        result = 31 * result + (this.mShouldSendCompatFakeFocus ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ResumeActivityItem{" + super.toString() + ",procState=" + this.mProcState + ",isForward=" + this.mIsForward + ",shouldSendCompatFakeFocus=" + this.mShouldSendCompatFakeFocus + "}";
    }
}

