/*
 * Decompiled with CFR 0.152.
 */
package android.app.sdksandbox;

import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.Activity;
import android.app.sdksandbox.AppOwnedSdkSandboxInterface;
import android.app.sdksandbox.ILoadSdkCallback;
import android.app.sdksandbox.IRequestSurfacePackageCallback;
import android.app.sdksandbox.ISdkSandboxManager;
import android.app.sdksandbox.ISdkSandboxProcessDeathCallback;
import android.app.sdksandbox.LoadSdkException;
import android.app.sdksandbox.RequestSurfacePackageException;
import android.app.sdksandbox.SandboxLatencyInfo;
import android.app.sdksandbox.SandboxedSdk;
import android.app.sdksandbox.SdkLevel;
import android.app.sdksandbox.SharedPreferencesSyncManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import android.view.SurfaceControlViewHost;
import com.android.internal.annotations.GuardedBy;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;

public class SdkSandboxManager {
    public static final String SDK_SANDBOX_SERVICE = "sdk_sandbox";
    public static final int SDK_SANDBOX_PROCESS_NOT_AVAILABLE = 503;
    public static final int LOAD_SDK_NOT_FOUND = 100;
    public static final int LOAD_SDK_ALREADY_LOADED = 101;
    public static final int LOAD_SDK_SDK_DEFINED_ERROR = 102;
    public static final int LOAD_SDK_SDK_SANDBOX_DISABLED = 103;
    public static final int LOAD_SDK_INTERNAL_ERROR = 500;
    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static final String ACTION_START_SANDBOXED_ACTIVITY = "android.app.sdksandbox.action.START_SANDBOXED_ACTIVITY";
    public static final String EXTRA_SANDBOXED_ACTIVITY_HANDLER = "android.app.sdksandbox.extra.SANDBOXED_ACTIVITY_HANDLER";
    public static final String EXTRA_SANDBOXED_ACTIVITY_INITIATION_TIME = "android.app.sdksandbox.extra.EXTRA_SANDBOXED_ACTIVITY_INITIATION_TIME";
    private static final String TAG = "SdkSandboxManager";
    private TimeProvider mTimeProvider;
    public static final int REQUEST_SURFACE_PACKAGE_INTERNAL_ERROR = 700;
    public static final int REQUEST_SURFACE_PACKAGE_SDK_NOT_LOADED = 701;
    public static final int SDK_SANDBOX_STATE_DISABLED = 0;
    public static final int SDK_SANDBOX_STATE_ENABLED_PROCESS_ISOLATION = 2;
    @Deprecated
    public static final String EXTRA_WIDTH_IN_PIXELS = "android.app.sdksandbox.extra.WIDTH_IN_PIXELS";
    @Deprecated
    public static final String EXTRA_HEIGHT_IN_PIXELS = "android.app.sdksandbox.extra.HEIGHT_IN_PIXELS";
    @Deprecated
    public static final String EXTRA_DISPLAY_ID = "android.app.sdksandbox.extra.DISPLAY_ID";
    @Deprecated
    public static final String EXTRA_HOST_TOKEN = "android.app.sdksandbox.extra.HOST_TOKEN";
    @Deprecated
    public static final String EXTRA_SURFACE_PACKAGE = "android.app.sdksandbox.extra.SURFACE_PACKAGE";
    private final ISdkSandboxManager mService;
    private final Context mContext;
    @GuardedBy(value={"mLifecycleCallbacks"})
    private final ArrayList<SdkSandboxProcessDeathCallbackProxy> mLifecycleCallbacks = new ArrayList();
    private final SharedPreferencesSyncManager mSyncManager;

    public SdkSandboxManager(@NonNull Context context, @NonNull ISdkSandboxManager binder) {
        this.mContext = Objects.requireNonNull(context, "context should not be null");
        this.mService = Objects.requireNonNull(binder, "binder should not be null");
        this.mSyncManager = SharedPreferencesSyncManager.getInstance(context, binder);
        this.mTimeProvider = new TimeProvider();
    }

    public static int getSdkSandboxState() {
        return 2;
    }

    public boolean isSdkSandboxServiceRunning() {
        try {
            return this.mService.isSdkSandboxServiceRunning(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="com.android.app.sdksandbox.permission.STOP_SDK_SANDBOX")
    public void stopSdkSandbox() {
        try {
            this.mService.stopSdkSandbox(this.mContext.getPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSdkSandboxProcessDeathCallback(@NonNull Executor callbackExecutor, @NonNull SdkSandboxProcessDeathCallback callback) {
        Objects.requireNonNull(callbackExecutor, "callbackExecutor should not be null");
        Objects.requireNonNull(callback, "callback should not be null");
        ArrayList<SdkSandboxProcessDeathCallbackProxy> arrayList = this.mLifecycleCallbacks;
        synchronized (arrayList) {
            SdkSandboxProcessDeathCallbackProxy callbackProxy = new SdkSandboxProcessDeathCallbackProxy(callbackExecutor, callback);
            SandboxLatencyInfo sandboxLatencyInfo = new SandboxLatencyInfo(8);
            sandboxLatencyInfo.setTimeAppCalledSystemServer(this.mTimeProvider.elapsedRealtime());
            try {
                this.mService.addSdkSandboxProcessDeathCallback(this.mContext.getPackageName(), sandboxLatencyInfo, callbackProxy);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            this.mLifecycleCallbacks.add(callbackProxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSdkSandboxProcessDeathCallback(@NonNull SdkSandboxProcessDeathCallback callback) {
        Objects.requireNonNull(callback, "callback should not be null");
        ArrayList<SdkSandboxProcessDeathCallbackProxy> arrayList = this.mLifecycleCallbacks;
        synchronized (arrayList) {
            for (int i = this.mLifecycleCallbacks.size() - 1; i >= 0; --i) {
                SdkSandboxProcessDeathCallbackProxy callbackProxy = this.mLifecycleCallbacks.get(i);
                if (callbackProxy.callback != callback) continue;
                SandboxLatencyInfo sandboxLatencyInfo = new SandboxLatencyInfo(9);
                sandboxLatencyInfo.setTimeAppCalledSystemServer(this.mTimeProvider.elapsedRealtime());
                try {
                    this.mService.removeSdkSandboxProcessDeathCallback(this.mContext.getPackageName(), sandboxLatencyInfo, callbackProxy);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
                this.mLifecycleCallbacks.remove(i);
            }
        }
    }

    public void registerAppOwnedSdkSandboxInterface(@NonNull AppOwnedSdkSandboxInterface appOwnedSdkSandboxInterface) {
        SandboxLatencyInfo sandboxLatencyInfo = new SandboxLatencyInfo(11);
        sandboxLatencyInfo.setTimeAppCalledSystemServer(this.mTimeProvider.elapsedRealtime());
        try {
            this.mService.registerAppOwnedSdkSandboxInterface(this.mContext.getPackageName(), appOwnedSdkSandboxInterface, sandboxLatencyInfo);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void unregisterAppOwnedSdkSandboxInterface(@NonNull String name) {
        SandboxLatencyInfo sandboxLatencyInfo = new SandboxLatencyInfo(12);
        sandboxLatencyInfo.setTimeAppCalledSystemServer(this.mTimeProvider.elapsedRealtime());
        try {
            this.mService.unregisterAppOwnedSdkSandboxInterface(this.mContext.getPackageName(), name, sandboxLatencyInfo);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public List<AppOwnedSdkSandboxInterface> getAppOwnedSdkSandboxInterfaces() {
        SandboxLatencyInfo sandboxLatencyInfo = new SandboxLatencyInfo(13);
        sandboxLatencyInfo.setTimeAppCalledSystemServer(this.mTimeProvider.elapsedRealtime());
        try {
            return this.mService.getAppOwnedSdkSandboxInterfaces(this.mContext.getPackageName(), sandboxLatencyInfo);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void loadSdk(@NonNull String sdkName, @NonNull Bundle params, @NonNull Executor executor, @NonNull OutcomeReceiver<SandboxedSdk, LoadSdkException> receiver) {
        Objects.requireNonNull(sdkName, "sdkName should not be null");
        Objects.requireNonNull(params, "params should not be null");
        Objects.requireNonNull(executor, "executor should not be null");
        Objects.requireNonNull(receiver, "receiver should not be null");
        LoadSdkReceiverProxy callbackProxy = new LoadSdkReceiverProxy(executor, receiver, this.mService);
        IBinder appProcessToken = SdkLevel.isAtLeastU() ? this.mContext.getProcessToken() : null;
        SandboxLatencyInfo sandboxLatencyInfo = new SandboxLatencyInfo(1);
        sandboxLatencyInfo.setTimeAppCalledSystemServer(this.mTimeProvider.elapsedRealtime());
        try {
            this.mService.loadSdk(this.mContext.getPackageName(), appProcessToken, sdkName, sandboxLatencyInfo, params, callbackProxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public List<SandboxedSdk> getSandboxedSdks() {
        SandboxLatencyInfo sandboxLatencyInfo = new SandboxLatencyInfo(5);
        sandboxLatencyInfo.setTimeAppCalledSystemServer(this.mTimeProvider.elapsedRealtime());
        try {
            return this.mService.getSandboxedSdks(this.mContext.getPackageName(), sandboxLatencyInfo);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void unloadSdk(@NonNull String sdkName) {
        Objects.requireNonNull(sdkName, "sdkName should not be null");
        try {
            SandboxLatencyInfo sandboxLatencyInfo = new SandboxLatencyInfo(7);
            sandboxLatencyInfo.setTimeAppCalledSystemServer(this.mTimeProvider.elapsedRealtime());
            this.mService.unloadSdk(this.mContext.getPackageName(), sdkName, sandboxLatencyInfo);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void requestSurfacePackage(@NonNull String sdkName, @NonNull Bundle params, @NonNull Executor callbackExecutor, @NonNull OutcomeReceiver<Bundle, RequestSurfacePackageException> receiver) {
        Objects.requireNonNull(sdkName, "sdkName should not be null");
        Objects.requireNonNull(params, "params should not be null");
        Objects.requireNonNull(callbackExecutor, "callbackExecutor should not be null");
        Objects.requireNonNull(receiver, "receiver should not be null");
        try {
            int width = params.getInt(EXTRA_WIDTH_IN_PIXELS, -1);
            if (width <= 0) {
                throw new IllegalArgumentException("Field params should have the entry for the key (android.app.sdksandbox.extra.WIDTH_IN_PIXELS) with positive integer value");
            }
            int height = params.getInt(EXTRA_HEIGHT_IN_PIXELS, -1);
            if (height <= 0) {
                throw new IllegalArgumentException("Field params should have the entry for the key (android.app.sdksandbox.extra.HEIGHT_IN_PIXELS) with positive integer value");
            }
            int displayId = params.getInt(EXTRA_DISPLAY_ID, -1);
            if (displayId < 0) {
                throw new IllegalArgumentException("Field params should have the entry for the key (android.app.sdksandbox.extra.DISPLAY_ID) with integer >= 0");
            }
            IBinder hostToken = params.getBinder(EXTRA_HOST_TOKEN);
            if (hostToken == null) {
                throw new IllegalArgumentException("Field params should have the entry for the key (android.app.sdksandbox.extra.HOST_TOKEN) with not null IBinder value");
            }
            SandboxLatencyInfo sandboxLatencyInfo = new SandboxLatencyInfo(3);
            sandboxLatencyInfo.setTimeAppCalledSystemServer(this.mTimeProvider.elapsedRealtime());
            RequestSurfacePackageReceiverProxy callbackProxy = new RequestSurfacePackageReceiverProxy(callbackExecutor, receiver, this.mService);
            this.mService.requestSurfacePackage(this.mContext.getPackageName(), sdkName, hostToken, displayId, width, height, sandboxLatencyInfo, params, callbackProxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresApi(value=34)
    public void startSdkSandboxActivity(@NonNull Activity fromActivity, @NonNull IBinder sdkActivityToken) {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException();
        }
        long timeEventStarted = this.mTimeProvider.elapsedRealtime();
        Intent intent = new Intent();
        intent.setAction(ACTION_START_SANDBOXED_ACTIVITY);
        intent.setPackage(this.mContext.getPackageManager().getSdkSandboxPackageName());
        Bundle params = new Bundle();
        params.putBinder(EXTRA_SANDBOXED_ACTIVITY_HANDLER, sdkActivityToken);
        params.putLong(EXTRA_SANDBOXED_ACTIVITY_INITIATION_TIME, timeEventStarted);
        intent.putExtras(params);
        fromActivity.startActivity(intent);
        this.logStartSdkSandboxActivityLatency(timeEventStarted);
    }

    @RequiresApi(value=34)
    private void logStartSdkSandboxActivityLatency(long timeEventStarted) {
        try {
            this.mService.logSandboxActivityApiLatency(5, 1, (int)(this.mTimeProvider.elapsedRealtime() - timeEventStarted));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static int getResultCodeForLoadSdkException(LoadSdkException exception) {
        int n;
        switch (exception.getLoadSdkErrorCode()) {
            case 100: {
                n = 1;
                break;
            }
            case 101: {
                n = 2;
                break;
            }
            case 102: {
                n = 3;
                break;
            }
            case 103: {
                n = 4;
                break;
            }
            case 500: {
                n = 5;
                break;
            }
            case 503: {
                n = 6;
                break;
            }
            default: {
                Log.e(TAG, "Unexpected load SDK exception code: " + exception.getLoadSdkErrorCode());
                n = 0;
            }
        }
        return n;
    }

    public void addSyncedSharedPreferencesKeys(@NonNull Set<String> keys) {
        Objects.requireNonNull(keys, "keys cannot be null");
        for (String key : keys) {
            if (key != null) continue;
            throw new IllegalArgumentException("keys cannot contain null");
        }
        this.mSyncManager.addSharedPreferencesSyncKeys(keys);
    }

    public void removeSyncedSharedPreferencesKeys(@NonNull Set<String> keys) {
        for (String key : keys) {
            if (key != null) continue;
            throw new IllegalArgumentException("keys cannot contain null");
        }
        this.mSyncManager.removeSharedPreferencesSyncKeys(keys);
    }

    @NonNull
    public Set<String> getSyncedSharedPreferencesKeys() {
        return this.mSyncManager.getSharedPreferencesSyncKeys();
    }

    public IBinder getAdServicesManager() {
        try {
            return this.mService.getAdServicesManager();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static class TimeProvider {
        TimeProvider() {
        }

        long elapsedRealtime() {
            return SystemClock.elapsedRealtime();
        }
    }

    private static class SdkSandboxProcessDeathCallbackProxy
    extends ISdkSandboxProcessDeathCallback.Stub {
        private final Executor mExecutor;
        public final SdkSandboxProcessDeathCallback callback;

        SdkSandboxProcessDeathCallbackProxy(Executor executor, SdkSandboxProcessDeathCallback lifecycleCallback) {
            this.mExecutor = executor;
            this.callback = lifecycleCallback;
        }

        @Override
        public void onSdkSandboxDied() {
            this.mExecutor.execute(() -> this.callback.onSdkSandboxDied());
        }
    }

    public static interface SdkSandboxProcessDeathCallback {
        public void onSdkSandboxDied();
    }

    private static class LoadSdkReceiverProxy
    extends ILoadSdkCallback.Stub {
        private final Executor mExecutor;
        private final OutcomeReceiver<SandboxedSdk, LoadSdkException> mCallback;
        private final ISdkSandboxManager mService;

        LoadSdkReceiverProxy(Executor executor, OutcomeReceiver<SandboxedSdk, LoadSdkException> callback, ISdkSandboxManager service) {
            this.mExecutor = executor;
            this.mCallback = callback;
            this.mService = service;
        }

        @Override
        public void onLoadSdkSuccess(SandboxedSdk sandboxedSdk, SandboxLatencyInfo sandboxLatencyInfo) {
            this.logSandboxApiLatency(sandboxLatencyInfo);
            this.mExecutor.execute(() -> this.mCallback.onResult(sandboxedSdk));
        }

        @Override
        public void onLoadSdkFailure(LoadSdkException exception, SandboxLatencyInfo sandboxLatencyInfo) {
            sandboxLatencyInfo.setResultCode(SdkSandboxManager.getResultCodeForLoadSdkException(exception));
            this.logSandboxApiLatency(sandboxLatencyInfo);
            this.mExecutor.execute(() -> this.mCallback.onError(exception));
        }

        private void logSandboxApiLatency(SandboxLatencyInfo sandboxLatencyInfo) {
            sandboxLatencyInfo.setTimeAppReceivedCallFromSystemServer(SystemClock.elapsedRealtime());
            try {
                this.mService.logSandboxApiLatency(sandboxLatencyInfo);
            }
            catch (RemoteException e) {
                Log.w(SdkSandboxManager.TAG, "Remote exception while calling logSandboxApiLatency.Error: " + e.getMessage());
            }
        }
    }

    private static class RequestSurfacePackageReceiverProxy
    extends IRequestSurfacePackageCallback.Stub {
        private final Executor mExecutor;
        private final OutcomeReceiver<Bundle, RequestSurfacePackageException> mReceiver;
        private final ISdkSandboxManager mService;

        RequestSurfacePackageReceiverProxy(Executor executor, OutcomeReceiver<Bundle, RequestSurfacePackageException> receiver, ISdkSandboxManager service) {
            this.mExecutor = executor;
            this.mReceiver = receiver;
            this.mService = service;
        }

        @Override
        public void onSurfacePackageReady(SurfaceControlViewHost.SurfacePackage surfacePackage, int surfacePackageId, Bundle params, SandboxLatencyInfo sandboxLatencyInfo) {
            this.logSandboxApiLatency(sandboxLatencyInfo);
            this.mExecutor.execute(() -> {
                params.putParcelable(SdkSandboxManager.EXTRA_SURFACE_PACKAGE, surfacePackage);
                this.mReceiver.onResult(params);
            });
        }

        @Override
        public void onSurfacePackageError(int errorCode, String errorMsg, SandboxLatencyInfo sandboxLatencyInfo) {
            this.logSandboxApiLatency(sandboxLatencyInfo);
            this.mExecutor.execute(() -> this.mReceiver.onError(new RequestSurfacePackageException(errorCode, errorMsg)));
        }

        private void logSandboxApiLatency(SandboxLatencyInfo sandboxLatencyInfo) {
            sandboxLatencyInfo.setTimeAppReceivedCallFromSystemServer(SystemClock.elapsedRealtime());
            try {
                this.mService.logSandboxApiLatency(sandboxLatencyInfo);
            }
            catch (RemoteException e) {
                Log.w(SdkSandboxManager.TAG, "Remote exception while calling logSandboxApiLatency.Error: " + e.getMessage());
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SdkSandboxState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequestSurfacePackageErrorCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LoadSdkErrorCode {
    }
}

