/*
 * Decompiled with CFR 0.152.
 */
package android.app.sdksandbox;

import android.annotation.NonNull;
import android.app.sdksandbox.ISdkToServiceCallback;
import android.app.sdksandbox.sdkprovider.SdkSandboxClientImportanceListener;
import android.app.sdksandbox.sdkprovider.SdkSandboxController;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Objects;

public class SdkSandboxLocalSingleton {
    private static final String TAG = "SandboxLocalSingleton";
    private static SdkSandboxLocalSingleton sInstance = null;
    private final ISdkToServiceCallback mSdkToServiceCallback;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final ArrayList<SdkSandboxController.SdkSandboxClientImportanceListenerProxy> mSdkSandboxClientImportanceListeners = new ArrayList();

    private SdkSandboxLocalSingleton(ISdkToServiceCallback sdkToServiceCallback) {
        this.mSdkToServiceCallback = sdkToServiceCallback;
    }

    public static synchronized void initInstance(@NonNull IBinder sdkToServiceBinder) {
        if (sInstance != null) {
            Log.d(TAG, "Already Initialised");
            return;
        }
        try {
            if (Objects.nonNull(sdkToServiceBinder) && sdkToServiceBinder.getInterfaceDescriptor().equals("android.app.sdksandbox.ISdkToServiceCallback")) {
                sInstance = new SdkSandboxLocalSingleton(ISdkToServiceCallback.Stub.asInterface(sdkToServiceBinder));
                return;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        throw new UnsupportedOperationException("IBinder not supported");
    }

    public static SdkSandboxLocalSingleton getExistingInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("SdkSandboxLocalSingleton not found");
        }
        return sInstance;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static void destroySingleton() {
        sInstance = null;
    }

    public ISdkToServiceCallback getSdkToServiceCallback() {
        return this.mSdkToServiceCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSdkSandboxClientImportanceListener(@NonNull SdkSandboxController.SdkSandboxClientImportanceListenerProxy listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSdkSandboxClientImportanceListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSdkSandboxClientImportanceListener(@NonNull SdkSandboxClientImportanceListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mSdkSandboxClientImportanceListeners.size() - 1; i >= 0; --i) {
                if (this.mSdkSandboxClientImportanceListeners.get((int)i).listener != listener) continue;
                this.mSdkSandboxClientImportanceListeners.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifySdkSandboxClientImportanceChange(boolean isForeground) {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mSdkSandboxClientImportanceListeners.size(); ++i) {
                this.mSdkSandboxClientImportanceListeners.get(i).onForegroundImportanceChanged(isForeground);
            }
        }
    }
}

