/*
 * Decompiled with CFR 0.152.
 */
package android.app.sdksandbox;

import android.app.sdksandbox.AppOwnedSdkSandboxInterface;
import android.app.sdksandbox.ILoadSdkCallback;
import android.app.sdksandbox.SandboxLatencyInfo;
import android.app.sdksandbox.SandboxedSdk;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface ISdkToServiceCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.app.sdksandbox.ISdkToServiceCallback";

    public List<AppOwnedSdkSandboxInterface> getAppOwnedSdkSandboxInterfaces(String var1) throws RemoteException;

    public List<SandboxedSdk> getSandboxedSdks(String var1, SandboxLatencyInfo var2) throws RemoteException;

    public void loadSdk(String var1, String var2, SandboxLatencyInfo var3, Bundle var4, ILoadSdkCallback var5) throws RemoteException;

    public void logLatenciesFromSandbox(SandboxLatencyInfo var1) throws RemoteException;

    public void logSandboxActivityApiLatencyFromSandbox(int var1, int var2, int var3) throws RemoteException;

    public static class _Parcel {
        private static <T extends Parcelable> void writeTypedList(Parcel parcel, List<T> value, int parcelableFlags) {
            if (value == null) {
                parcel.writeInt(-1);
            } else {
                int N2 = value.size();
                parcel.writeInt(N2);
                for (int i = 0; i < N2; ++i) {
                    parcel.writeTypedObject((Parcelable)value.get(i), parcelableFlags);
                }
            }
        }
    }

    public static abstract class Stub
    extends Binder
    implements ISdkToServiceCallback {
        static final int TRANSACTION_getAppOwnedSdkSandboxInterfaces = 1;
        static final int TRANSACTION_getSandboxedSdks = 2;
        static final int TRANSACTION_loadSdk = 3;
        static final int TRANSACTION_logLatenciesFromSandbox = 4;
        static final int TRANSACTION_logSandboxActivityApiLatencyFromSandbox = 5;

        public Stub() {
            this.attachInterface(this, ISdkToServiceCallback.DESCRIPTOR);
        }

        public static ISdkToServiceCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISdkToServiceCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ISdkToServiceCallback) {
                return (ISdkToServiceCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "getAppOwnedSdkSandboxInterfaces";
                }
                case 2: {
                    return "getSandboxedSdks";
                }
                case 3: {
                    return "loadSdk";
                }
                case 4: {
                    return "logLatenciesFromSandbox";
                }
                case 5: {
                    return "logSandboxActivityApiLatencyFromSandbox";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISdkToServiceCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    List<AppOwnedSdkSandboxInterface> _result = this.getAppOwnedSdkSandboxInterfaces(_arg0);
                    reply.writeNoException();
                    _Parcel.writeTypedList(reply, _result, 1);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    SandboxLatencyInfo _arg1 = data.readTypedObject(SandboxLatencyInfo.CREATOR);
                    data.enforceNoDataAvail();
                    List<SandboxedSdk> _result = this.getSandboxedSdks(_arg0, _arg1);
                    reply.writeNoException();
                    _Parcel.writeTypedList(reply, _result, 1);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    SandboxLatencyInfo _arg2 = data.readTypedObject(SandboxLatencyInfo.CREATOR);
                    Bundle _arg3 = data.readTypedObject(Bundle.CREATOR);
                    ILoadSdkCallback _arg4 = ILoadSdkCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.loadSdk(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    SandboxLatencyInfo _arg0 = data.readTypedObject(SandboxLatencyInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.logLatenciesFromSandbox(_arg0);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.logSandboxActivityApiLatencyFromSandbox(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements ISdkToServiceCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISdkToServiceCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AppOwnedSdkSandboxInterface> getAppOwnedSdkSandboxInterfaces(String clientPackageName) throws RemoteException {
                ArrayList<AppOwnedSdkSandboxInterface> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISdkToServiceCallback.DESCRIPTOR);
                    _data.writeString(clientPackageName);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(AppOwnedSdkSandboxInterface.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SandboxedSdk> getSandboxedSdks(String clientPackageName, SandboxLatencyInfo sandboxLatencyInfo) throws RemoteException {
                ArrayList<SandboxedSdk> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISdkToServiceCallback.DESCRIPTOR);
                    _data.writeString(clientPackageName);
                    _data.writeTypedObject(sandboxLatencyInfo, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(SandboxedSdk.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void loadSdk(String callingPackageName, String sdkName, SandboxLatencyInfo sandboxLatencyInfo, Bundle params, ILoadSdkCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISdkToServiceCallback.DESCRIPTOR);
                    _data.writeString(callingPackageName);
                    _data.writeString(sdkName);
                    _data.writeTypedObject(sandboxLatencyInfo, 0);
                    _data.writeTypedObject(params, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void logLatenciesFromSandbox(SandboxLatencyInfo sandboxLatencyInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISdkToServiceCallback.DESCRIPTOR);
                    _data.writeTypedObject(sandboxLatencyInfo, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void logSandboxActivityApiLatencyFromSandbox(int method, int callResult, int latencyMillis) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISdkToServiceCallback.DESCRIPTOR);
                    _data.writeInt(method);
                    _data.writeInt(callResult);
                    _data.writeInt(latencyMillis);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISdkToServiceCallback {
        @Override
        public List<AppOwnedSdkSandboxInterface> getAppOwnedSdkSandboxInterfaces(String clientPackageName) throws RemoteException {
            return null;
        }

        @Override
        public List<SandboxedSdk> getSandboxedSdks(String clientPackageName, SandboxLatencyInfo sandboxLatencyInfo) throws RemoteException {
            return null;
        }

        @Override
        public void loadSdk(String callingPackageName, String sdkName, SandboxLatencyInfo sandboxLatencyInfo, Bundle params, ILoadSdkCallback callback) throws RemoteException {
        }

        @Override
        public void logLatenciesFromSandbox(SandboxLatencyInfo sandboxLatencyInfo) throws RemoteException {
        }

        @Override
        public void logSandboxActivityApiLatencyFromSandbox(int method, int callResult, int latencyMillis) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

