/*
 * Decompiled with CFR 0.152.
 */
package android.app.sdksandbox;

import android.app.sdksandbox.LoadSdkException;
import android.app.sdksandbox.SandboxLatencyInfo;
import android.app.sdksandbox.SandboxedSdk;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ILoadSdkCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.app.sdksandbox.ILoadSdkCallback";

    public void onLoadSdkSuccess(SandboxedSdk var1, SandboxLatencyInfo var2) throws RemoteException;

    public void onLoadSdkFailure(LoadSdkException var1, SandboxLatencyInfo var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILoadSdkCallback {
        static final int TRANSACTION_onLoadSdkSuccess = 1;
        static final int TRANSACTION_onLoadSdkFailure = 2;

        public Stub() {
            this.attachInterface(this, ILoadSdkCallback.DESCRIPTOR);
        }

        public static ILoadSdkCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ILoadSdkCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ILoadSdkCallback) {
                return (ILoadSdkCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onLoadSdkSuccess";
                }
                case 2: {
                    return "onLoadSdkFailure";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ILoadSdkCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    SandboxedSdk _arg0 = data.readTypedObject(SandboxedSdk.CREATOR);
                    SandboxLatencyInfo _arg1 = data.readTypedObject(SandboxLatencyInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onLoadSdkSuccess(_arg0, _arg1);
                    break;
                }
                case 2: {
                    LoadSdkException _arg0 = data.readTypedObject(LoadSdkException.CREATOR);
                    SandboxLatencyInfo _arg1 = data.readTypedObject(SandboxLatencyInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onLoadSdkFailure(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements ILoadSdkCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ILoadSdkCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLoadSdkSuccess(SandboxedSdk sandboxedSdkParcel, SandboxLatencyInfo sandboxLatencyInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ILoadSdkCallback.DESCRIPTOR);
                    _data.writeTypedObject(sandboxedSdkParcel, 0);
                    _data.writeTypedObject(sandboxLatencyInfo, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLoadSdkFailure(LoadSdkException exception, SandboxLatencyInfo sandboxLatencyInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ILoadSdkCallback.DESCRIPTOR);
                    _data.writeTypedObject(exception, 0);
                    _data.writeTypedObject(sandboxLatencyInfo, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ILoadSdkCallback {
        @Override
        public void onLoadSdkSuccess(SandboxedSdk sandboxedSdkParcel, SandboxLatencyInfo sandboxLatencyInfo) throws RemoteException {
        }

        @Override
        public void onLoadSdkFailure(LoadSdkException exception, SandboxLatencyInfo sandboxLatencyInfo) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

