/*
 * Decompiled with CFR 0.152.
 */
package android.app.people;

import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.people.ConversationChannel;
import android.app.people.ConversationStatus;
import android.app.people.IConversationListener;
import android.app.people.IPeopleManager;
import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Pair;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

public class PeopleManager {
    private static final String LOG_TAG = PeopleManager.class.getSimpleName();
    @VisibleForTesting
    public Map<ConversationListener, Pair<Executor, IConversationListener>> mConversationListeners = new HashMap<ConversationListener, Pair<Executor, IConversationListener>>();
    @NonNull
    private Context mContext;
    @NonNull
    private IPeopleManager mService;

    public PeopleManager(@NonNull Context context) throws ServiceManager.ServiceNotFoundException {
        this.mContext = context;
        this.mService = IPeopleManager.Stub.asInterface(ServiceManager.getServiceOrThrow("people"));
    }

    @VisibleForTesting
    public PeopleManager(@NonNull Context context, IPeopleManager service) {
        this.mContext = context;
        this.mService = service;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_PEOPLE_DATA")
    public boolean isConversation(@NonNull String packageName, @NonNull String shortcutId) {
        Preconditions.checkStringNotEmpty(packageName);
        Preconditions.checkStringNotEmpty(shortcutId);
        try {
            return this.mService.isConversation(packageName, this.mContext.getUserId(), shortcutId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void addOrUpdateStatus(@NonNull String conversationId, @NonNull ConversationStatus status) {
        Preconditions.checkStringNotEmpty(conversationId);
        Objects.requireNonNull(status);
        try {
            this.mService.addOrUpdateStatus(this.mContext.getPackageName(), this.mContext.getUserId(), conversationId, status);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void clearStatus(@NonNull String conversationId, @NonNull String statusId) {
        Preconditions.checkStringNotEmpty(conversationId);
        Preconditions.checkStringNotEmpty(statusId);
        try {
            this.mService.clearStatus(this.mContext.getPackageName(), this.mContext.getUserId(), conversationId, statusId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void clearStatuses(@NonNull String conversationId) {
        Preconditions.checkStringNotEmpty(conversationId);
        try {
            this.mService.clearStatuses(this.mContext.getPackageName(), this.mContext.getUserId(), conversationId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public List<ConversationStatus> getStatuses(@NonNull String conversationId) {
        try {
            ParceledListSlice parceledList = this.mService.getStatuses(this.mContext.getPackageName(), this.mContext.getUserId(), conversationId);
            if (parceledList != null) {
                return parceledList.getList();
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return new ArrayList<ConversationStatus>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConversationListener(String packageName, int userId, String shortcutId, ConversationListener listener, Executor executor) {
        Objects.requireNonNull(listener, "Listener cannot be null");
        Objects.requireNonNull(packageName, "Package name cannot be null");
        Objects.requireNonNull(shortcutId, "Shortcut ID cannot be null");
        Map<ConversationListener, Pair<Executor, IConversationListener>> map = this.mConversationListeners;
        synchronized (map) {
            ConversationListenerProxy proxy = new ConversationListenerProxy(executor, listener);
            try {
                this.mService.registerConversationListener(packageName, userId, shortcutId, proxy);
                this.mConversationListeners.put(listener, new Pair<Executor, ConversationListenerProxy>(executor, proxy));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConversationListener(ConversationListener listener) {
        Objects.requireNonNull(listener, "Listener cannot be null");
        Map<ConversationListener, Pair<Executor, IConversationListener>> map = this.mConversationListeners;
        synchronized (map) {
            if (this.mConversationListeners.containsKey(listener)) {
                IConversationListener proxy = (IConversationListener)this.mConversationListeners.remove((Object)listener).second;
                try {
                    this.mService.unregisterConversationListener(proxy);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    private static class ConversationListenerProxy
    extends IConversationListener.Stub {
        private final Executor mExecutor;
        private final ConversationListener mListener;

        ConversationListenerProxy(Executor executor, ConversationListener listener) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        public void onConversationUpdate(@NonNull ConversationChannel conversation) {
            if (this.mListener == null || this.mExecutor == null) {
                Slog.e(LOG_TAG, "Binder is dead");
                return;
            }
            this.mExecutor.execute(() -> this.mListener.onConversationUpdate(conversation));
        }
    }

    public static interface ConversationListener {
        default public void onConversationUpdate(@NonNull ConversationChannel conversation) {
        }
    }
}

