/*
 * Decompiled with CFR 0.152.
 */
package android.app.ondeviceintelligence;

import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.os.RemoteCallback;
import android.os.RemoteException;

public interface IStreamingResponseCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.app.ondeviceintelligence.IStreamingResponseCallback";

    public void onNewContent(Bundle var1) throws RemoteException;

    public void onSuccess(Bundle var1) throws RemoteException;

    public void onFailure(int var1, String var2, PersistableBundle var3) throws RemoteException;

    public void onDataAugmentRequest(Bundle var1, RemoteCallback var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IStreamingResponseCallback {
        static final int TRANSACTION_onNewContent = 2;
        static final int TRANSACTION_onSuccess = 3;
        static final int TRANSACTION_onFailure = 4;
        static final int TRANSACTION_onDataAugmentRequest = 5;

        public Stub() {
            this.attachInterface(this, IStreamingResponseCallback.DESCRIPTOR);
        }

        public static IStreamingResponseCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IStreamingResponseCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IStreamingResponseCallback) {
                return (IStreamingResponseCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 2: {
                    return "onNewContent";
                }
                case 3: {
                    return "onSuccess";
                }
                case 4: {
                    return "onFailure";
                }
                case 5: {
                    return "onDataAugmentRequest";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IStreamingResponseCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 2: {
                    Bundle _arg0 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onNewContent(_arg0);
                    break;
                }
                case 3: {
                    Bundle _arg0 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSuccess(_arg0);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    PersistableBundle _arg2 = data.readTypedObject(PersistableBundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onFailure(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    Bundle _arg0 = data.readTypedObject(Bundle.CREATOR);
                    RemoteCallback _arg1 = data.readTypedObject(RemoteCallback.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDataAugmentRequest(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements IStreamingResponseCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IStreamingResponseCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNewContent(Bundle processedResult) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IStreamingResponseCallback.DESCRIPTOR);
                    _data.writeTypedObject(processedResult, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(Bundle result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IStreamingResponseCallback.DESCRIPTOR);
                    _data.writeTypedObject(result, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(int errorCode, String errorMessage, PersistableBundle errorParams) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IStreamingResponseCallback.DESCRIPTOR);
                    _data.writeInt(errorCode);
                    _data.writeString(errorMessage);
                    _data.writeTypedObject(errorParams, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDataAugmentRequest(Bundle processedContent, RemoteCallback responseCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IStreamingResponseCallback.DESCRIPTOR);
                    _data.writeTypedObject(processedContent, 0);
                    _data.writeTypedObject(responseCallback, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IStreamingResponseCallback {
        @Override
        public void onNewContent(Bundle processedResult) throws RemoteException {
        }

        @Override
        public void onSuccess(Bundle result) throws RemoteException {
        }

        @Override
        public void onFailure(int errorCode, String errorMessage, PersistableBundle errorParams) throws RemoteException {
        }

        @Override
        public void onDataAugmentRequest(Bundle processedContent, RemoteCallback responseCallback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

