/*
 * Decompiled with CFR 0.152.
 */
package android.app.ondeviceintelligence;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import com.android.internal.util.AnnotationValidations;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="android.app.ondeviceintelligence.flags.enable_on_device_intelligence")
public class Feature
implements Parcelable {
    private final int mId;
    @Nullable
    private final String mName;
    @Nullable
    private final String mModelName;
    private final int mType;
    private final int mVariant;
    @NonNull
    private final PersistableBundle mFeatureParams;
    @NonNull
    public static final Parcelable.Creator<Feature> CREATOR = new Parcelable.Creator<Feature>(){

        public Feature[] newArray(int size) {
            return new Feature[size];
        }

        @Override
        public Feature createFromParcel(@NonNull Parcel in) {
            return new Feature(in);
        }
    };

    Feature(int id2, @Nullable String name, @Nullable String modelName, int type, int variant, @NonNull PersistableBundle featureParams) {
        this.mId = id2;
        this.mName = name;
        this.mModelName = modelName;
        this.mType = type;
        this.mVariant = variant;
        this.mFeatureParams = featureParams;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mFeatureParams);
    }

    public int getId() {
        return this.mId;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    @Nullable
    public String getModelName() {
        return this.mModelName;
    }

    public int getType() {
        return this.mType;
    }

    public int getVariant() {
        return this.mVariant;
    }

    @NonNull
    public PersistableBundle getFeatureParams() {
        return this.mFeatureParams;
    }

    public String toString() {
        return "Feature { id = " + this.mId + ", name = " + this.mName + ", modelName = " + this.mModelName + ", type = " + this.mType + ", variant = " + this.mVariant + ", featureParams = " + this.mFeatureParams + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Feature that = (Feature)o;
        return this.mId == that.mId && Objects.equals(this.mName, that.mName) && Objects.equals(this.mModelName, that.mModelName) && this.mType == that.mType && this.mVariant == that.mVariant && Objects.equals(this.mFeatureParams, that.mFeatureParams);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + this.mId;
        _hash = 31 * _hash + Objects.hashCode(this.mName);
        _hash = 31 * _hash + Objects.hashCode(this.mModelName);
        _hash = 31 * _hash + this.mType;
        _hash = 31 * _hash + this.mVariant;
        _hash = 31 * _hash + Objects.hashCode(this.mFeatureParams);
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        byte flg = 0;
        if (this.mName != null) {
            flg = (byte)(flg | 2);
        }
        if (this.mModelName != null) {
            flg = (byte)(flg | 4);
        }
        dest.writeByte(flg);
        dest.writeInt(this.mId);
        if (this.mName != null) {
            dest.writeString(this.mName);
        }
        if (this.mModelName != null) {
            dest.writeString(this.mModelName);
        }
        dest.writeInt(this.mType);
        dest.writeInt(this.mVariant);
        dest.writeTypedObject(this.mFeatureParams, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    Feature(@NonNull Parcel in) {
        byte flg = in.readByte();
        int id2 = in.readInt();
        String name = (flg & 2) == 0 ? null : in.readString();
        String modelName = (flg & 4) == 0 ? null : in.readString();
        int type = in.readInt();
        int variant = in.readInt();
        PersistableBundle featureParams = in.readTypedObject(PersistableBundle.CREATOR);
        this.mId = id2;
        this.mName = name;
        this.mModelName = modelName;
        this.mType = type;
        this.mVariant = variant;
        this.mFeatureParams = featureParams;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mFeatureParams);
    }

    public static class Builder {
        private int mId;
        @Nullable
        private String mName;
        @Nullable
        private String mModelName;
        private int mType;
        private int mVariant;
        @NonNull
        private PersistableBundle mFeatureParams;
        private long mBuilderFieldsSet = 0L;

        public Builder(int id2) {
            this.mId = id2;
            this.mFeatureParams = new PersistableBundle();
        }

        @NonNull
        public Builder setName(@NonNull String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mName = value;
            return this;
        }

        @NonNull
        public Builder setModelName(@NonNull String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mModelName = value;
            return this;
        }

        @NonNull
        public Builder setType(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mType = value;
            return this;
        }

        @NonNull
        public Builder setVariant(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            this.mVariant = value;
            return this;
        }

        @NonNull
        public Builder setFeatureParams(@NonNull PersistableBundle value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x20L;
            this.mFeatureParams = value;
            return this;
        }

        @NonNull
        public Feature build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x40L;
            Feature o = new Feature(this.mId, this.mName, this.mModelName, this.mType, this.mVariant, this.mFeatureParams);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x40L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }
}

