/*
 * Decompiled with CFR 0.152.
 */
package android.app.job;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.job.IUserVisibleJobObserver;
import android.app.job.JobInfo;
import android.app.job.JobSnapshot;
import android.app.job.JobWorkItem;
import android.app.job.PendingJobReasonsInfo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;

public abstract class JobScheduler {
    public static final long THROW_ON_INVALID_DATA_TRANSFER_IMPLEMENTATION = 255371817L;
    public static final int RESULT_FAILURE = 0;
    public static final int RESULT_SUCCESS = 1;
    public static final int PENDING_JOB_REASON_INVALID_JOB_ID = -2;
    public static final int PENDING_JOB_REASON_EXECUTING = -1;
    public static final int PENDING_JOB_REASON_UNDEFINED = 0;
    public static final int PENDING_JOB_REASON_APP = 1;
    public static final int PENDING_JOB_REASON_APP_STANDBY = 2;
    public static final int PENDING_JOB_REASON_BACKGROUND_RESTRICTION = 3;
    public static final int PENDING_JOB_REASON_CONSTRAINT_BATTERY_NOT_LOW = 4;
    public static final int PENDING_JOB_REASON_CONSTRAINT_CHARGING = 5;
    public static final int PENDING_JOB_REASON_CONSTRAINT_CONNECTIVITY = 6;
    public static final int PENDING_JOB_REASON_CONSTRAINT_CONTENT_TRIGGER = 7;
    public static final int PENDING_JOB_REASON_CONSTRAINT_DEVICE_IDLE = 8;
    public static final int PENDING_JOB_REASON_CONSTRAINT_MINIMUM_LATENCY = 9;
    public static final int PENDING_JOB_REASON_CONSTRAINT_PREFETCH = 10;
    public static final int PENDING_JOB_REASON_CONSTRAINT_STORAGE_NOT_LOW = 11;
    public static final int PENDING_JOB_REASON_DEVICE_STATE = 12;
    public static final int PENDING_JOB_REASON_JOB_SCHEDULER_OPTIMIZATION = 13;
    public static final int PENDING_JOB_REASON_QUOTA = 14;
    public static final int PENDING_JOB_REASON_USER = 15;
    @FlaggedApi(value="android.app.job.get_pending_job_reasons_api")
    public static final int PENDING_JOB_REASON_CONSTRAINT_DEADLINE = 16;

    @NonNull
    public JobScheduler forNamespace(@NonNull String namespace) {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @Nullable
    public String getNamespace() {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @Nullable
    public static String sanitizeNamespace(@Nullable String namespace) {
        if (namespace == null) {
            return null;
        }
        return namespace.trim().intern();
    }

    public abstract int schedule(@NonNull JobInfo var1);

    public abstract int enqueue(@NonNull JobInfo var1, @NonNull JobWorkItem var2);

    @SystemApi
    @RequiresPermission(value="android.permission.UPDATE_DEVICE_STATS")
    public abstract int scheduleAsPackage(@NonNull JobInfo var1, @NonNull String var2, int var3, String var4);

    public abstract void cancel(int var1);

    public abstract void cancelAll();

    public void cancelInAllNamespaces() {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @NonNull
    public abstract List<JobInfo> getAllPendingJobs();

    @NonNull
    public Map<String, List<JobInfo>> getPendingJobsInAllNamespaces() {
        throw new RuntimeException("Not implemented. Must override in a subclass.");
    }

    @Nullable
    public abstract JobInfo getPendingJob(int var1);

    public int getPendingJobReason(int jobId) {
        return 0;
    }

    @FlaggedApi(value="android.app.job.get_pending_job_reasons_api")
    @NonNull
    public int[] getPendingJobReasons(int jobId) {
        return new int[]{0};
    }

    @FlaggedApi(value="android.app.job.get_pending_job_reasons_history_api")
    @NonNull
    public List<PendingJobReasonsInfo> getPendingJobReasonsHistory(int jobId) {
        throw new UnsupportedOperationException("Not implemented by " + this.getClass());
    }

    public boolean canRunUserInitiatedJobs() {
        return false;
    }

    public boolean hasRunUserInitiatedJobsPermission(@NonNull String packageName, int userId) {
        return false;
    }

    @Nullable
    public List<JobInfo> getStartedJobs() {
        return null;
    }

    @Nullable
    public List<JobSnapshot> getAllJobSnapshots() {
        return null;
    }

    @RequiresPermission(allOf={"android.permission.MANAGE_ACTIVITY_TASKS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public void registerUserVisibleJobObserver(@NonNull IUserVisibleJobObserver observer) {
    }

    @RequiresPermission(allOf={"android.permission.MANAGE_ACTIVITY_TASKS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public void unregisterUserVisibleJobObserver(@NonNull IUserVisibleJobObserver observer) {
    }

    @RequiresPermission(allOf={"android.permission.MANAGE_ACTIVITY_TASKS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    public void notePendingUserRequestedAppStop(@NonNull String packageName, int userId, @Nullable String debugReason) {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PendingJobReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Result {
    }
}

