/*
 * Decompiled with CFR 0.152.
 */
package android.app.jank;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.jank.RelativeFrameTimeHistogram;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@FlaggedApi(value="android.app.jank.detailed_app_jank_metrics_api")
public class AppJankStats {
    private int mUid;
    private String mWidgetId;
    private String mWidgetCategory;
    private String mWidgetState;
    private long mTotalFrames;
    private long mJankyFrames;
    private RelativeFrameTimeHistogram mRelativeFrameTimeHistogram;
    private String mNavigationComponent;
    public static final String WIDGET_CATEGORY_UNSPECIFIED = "unspecified";
    public static final String WIDGET_CATEGORY_SCROLL = "scroll";
    public static final String WIDGET_CATEGORY_ANIMATION = "animation";
    public static final String WIDGET_CATEGORY_MEDIA = "media";
    public static final String WIDGET_CATEGORY_NAVIGATION = "navigation";
    public static final String WIDGET_CATEGORY_KEYBOARD = "keyboard";
    public static final String WIDGET_CATEGORY_OTHER = "other";
    public static final String WIDGET_STATE_UNSPECIFIED = "unspecified";
    public static final String WIDGET_STATE_NONE = "none";
    public static final String WIDGET_STATE_SCROLLING = "scrolling";
    public static final String WIDGET_STATE_FLINGING = "flinging";
    public static final String WIDGET_STATE_SWIPING = "swiping";
    public static final String WIDGET_STATE_DRAGGING = "dragging";
    public static final String WIDGET_STATE_ZOOMING = "zooming";
    public static final String WIDGET_STATE_ANIMATING = "animating";
    public static final String WIDGET_STATE_PLAYBACK = "playback";
    public static final String WIDGET_STATE_TAPPING = "tapping";
    public static final String WIDGET_STATE_PREDICTIVE_BACK = "predictive_back";

    public AppJankStats(int appUid, @NonNull String widgetId, @Nullable String navigationComponent, @Nullable String widgetCategory, @Nullable String widgetState, long totalFrames, long jankyFrames, @NonNull RelativeFrameTimeHistogram relativeFrameTimeHistogram) {
        this.mUid = appUid;
        this.mWidgetId = widgetId;
        this.mNavigationComponent = navigationComponent;
        this.mWidgetCategory = widgetCategory != null ? widgetCategory : "unspecified";
        this.mWidgetState = widgetState != null ? widgetState : "unspecified";
        this.mTotalFrames = totalFrames;
        this.mJankyFrames = jankyFrames;
        this.mRelativeFrameTimeHistogram = relativeFrameTimeHistogram;
    }

    public int getUid() {
        return this.mUid;
    }

    @NonNull
    public String getWidgetId() {
        return this.mWidgetId;
    }

    @NonNull
    public String getWidgetCategory() {
        return this.mWidgetCategory;
    }

    @NonNull
    public String getWidgetState() {
        return this.mWidgetState;
    }

    public long getJankyFrameCount() {
        return this.mJankyFrames;
    }

    public long getTotalFrameCount() {
        return this.mTotalFrames;
    }

    @NonNull
    public RelativeFrameTimeHistogram getRelativeFrameTimeHistogram() {
        return this.mRelativeFrameTimeHistogram;
    }

    @Nullable
    public String getNavigationComponent() {
        return this.mNavigationComponent;
    }

    @Target(value={ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WidgetState {
    }

    @Target(value={ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface WidgetCategory {
    }
}

