/*
 * Decompiled with CFR 0.152.
 */
package android.app.ecm;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.annotation.TargetApi;
import android.app.ecm.IEnhancedConfirmationManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
@FlaggedApi(value="android.permission.flags.enhanced_confirmation_mode_apis_enabled")
@TargetApi(value=35)
public class EnhancedConfirmationManager {
    public static final String ACTION_SHOW_ECM_RESTRICTED_SETTING_DIALOG = "android.app.ecm.action.SHOW_ECM_RESTRICTED_SETTING_DIALOG";
    public static final String REASON_PHONE_STATE = "phone_state";
    public static final String REASON_PACKAGE_RESTRICTED = "package_restricted";
    private static final String LOG_TAG = EnhancedConfirmationManager.class.getSimpleName();
    private static final ArraySet<String> PROTECTED_SETTINGS = new ArraySet();
    @NonNull
    private final Context mContext;
    private final PackageManager mPackageManager;
    @NonNull
    private final IEnhancedConfirmationManager mService;

    public EnhancedConfirmationManager(@NonNull Context context, @NonNull IEnhancedConfirmationManager service) {
        this.mContext = context;
        this.mPackageManager = context.getPackageManager();
        this.mService = service;
    }

    @RequiresPermission(value="android.permission.MANAGE_ENHANCED_CONFIRMATION_STATES")
    public boolean isRestricted(@NonNull String packageName, @NonNull String settingIdentifier) throws PackageManager.NameNotFoundException {
        try {
            return this.mService.isRestricted(packageName, settingIdentifier, this.mContext.getUser().getIdentifier());
        }
        catch (IllegalArgumentException e) {
            throw new PackageManager.NameNotFoundException(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_ENHANCED_CONFIRMATION_STATES")
    public void clearRestriction(@NonNull String packageName) throws PackageManager.NameNotFoundException {
        try {
            this.mService.clearRestriction(packageName, this.mContext.getUser().getIdentifier());
        }
        catch (IllegalArgumentException e) {
            throw new PackageManager.NameNotFoundException(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_ENHANCED_CONFIRMATION_STATES")
    public boolean isClearRestrictionAllowed(@NonNull String packageName) throws PackageManager.NameNotFoundException {
        try {
            return this.mService.isClearRestrictionAllowed(packageName, this.mContext.getUser().getIdentifier());
        }
        catch (IllegalArgumentException e) {
            throw new PackageManager.NameNotFoundException(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_ENHANCED_CONFIRMATION_STATES")
    public void setClearRestrictionAllowed(@NonNull String packageName) throws PackageManager.NameNotFoundException {
        try {
            this.mService.setClearRestrictionAllowed(packageName, this.mContext.getUser().getIdentifier());
        }
        catch (IllegalArgumentException e) {
            throw new PackageManager.NameNotFoundException(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public Intent createRestrictedSettingDialogIntent(@NonNull String packageName, @NonNull String settingIdentifier) throws PackageManager.NameNotFoundException {
        Intent intent = new Intent(ACTION_SHOW_ECM_RESTRICTED_SETTING_DIALOG);
        intent.putExtra("android.intent.extra.PACKAGE_NAME", packageName);
        int uid = this.getPackageUid(packageName);
        intent.putExtra("android.intent.extra.UID", uid);
        intent.putExtra("android.intent.extra.SUBJECT", settingIdentifier);
        try {
            String restrictionReason = this.mService.getRestrictionReason(packageName, settingIdentifier, UserHandle.getUserHandleForUid(uid).getIdentifier());
            intent.putExtra("android.intent.extra.REASON", restrictionReason);
        }
        catch (RemoteException | SecurityException exception) {
            // empty catch block
        }
        return intent;
    }

    private int getPackageUid(String packageName) throws PackageManager.NameNotFoundException {
        return this.mPackageManager.getApplicationInfoAsUser((String)packageName, (int)0, (UserHandle)this.mContext.getUser()).uid;
    }

    static {
        PROTECTED_SETTINGS.add("android:bind_accessibility_service");
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface EcmState {
        public static final int ECM_STATE_NOT_GUARDED = 0;
        public static final int ECM_STATE_GUARDED = 2;
        public static final int ECM_STATE_GUARDED_AND_ACKNOWLEDGED = 1;
        public static final int ECM_STATE_IMPLICIT = 3;
    }
}

