/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.util;

import android.app.appsearch.GenericDocument;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

public class DocumentIdUtil {
    private static final String NAMESPACE_DELIMITER = "#";
    private static final String NAMESPACE_DELIMITER_REPLACEMENT = "\\#";
    private static final String BACKSLASH_REPLACEMENT = "\\\\";

    private DocumentIdUtil() {
    }

    public static @NonNull String createQualifiedId(@NonNull String packageName, @NonNull String databaseName, @NonNull GenericDocument document) {
        return DocumentIdUtil.createQualifiedId(packageName, databaseName, document.getNamespace(), document.getId());
    }

    public static @NonNull String createQualifiedId(@NonNull String packageName, @NonNull String databaseName, @NonNull String namespace, @NonNull String id2) {
        Objects.requireNonNull(packageName);
        Objects.requireNonNull(databaseName);
        Objects.requireNonNull(namespace);
        Objects.requireNonNull(id2);
        StringBuilder qualifiedId = new StringBuilder(DocumentIdUtil.escapeNsDelimiters(packageName));
        qualifiedId.append('$').append(DocumentIdUtil.escapeNsDelimiters(databaseName)).append('/').append(DocumentIdUtil.escapeNsDelimiters(namespace)).append(NAMESPACE_DELIMITER).append(DocumentIdUtil.escapeNsDelimiters(id2));
        return qualifiedId.toString();
    }

    private static String escapeNsDelimiters(@NonNull String original) {
        StringBuilder escapedString = null;
        for (int i = 0; i < original.length(); ++i) {
            char currentChar = original.charAt(i);
            if (currentChar == '\\') {
                if (escapedString == null) {
                    escapedString = new StringBuilder(original.substring(0, i));
                }
                escapedString.append(BACKSLASH_REPLACEMENT);
                continue;
            }
            if (currentChar == '#') {
                if (escapedString == null) {
                    escapedString = new StringBuilder(original.substring(0, i));
                }
                escapedString.append(NAMESPACE_DELIMITER_REPLACEMENT);
                continue;
            }
            if (escapedString == null) continue;
            escapedString.append(currentChar);
        }
        return escapedString == null ? original : escapedString.toString();
    }
}

