/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.safeparcel;

import android.annotation.SuppressLint;
import android.app.appsearch.AppSearchBlobHandle;
import android.app.appsearch.EmbeddingVector;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.GenericDocumentParcel;
import android.app.appsearch.safeparcel.PropertyParcelCreator;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@SafeParcelable.Class(creator="PropertyParcelCreator")
@SuppressLint(value={"BanParcelableUsage"})
public class PropertyParcel
extends AbstractSafeParcelable
implements Parcelable {
    public static final @NonNull Parcelable.Creator<PropertyParcel> CREATOR = new PropertyParcelCreator();
    @SafeParcelable.Field(id=1, getter="getPropertyName")
    private final @NonNull String mPropertyName;
    @SafeParcelable.Field(id=2, getter="getStringValues")
    private final String @Nullable [] mStringValues;
    @SafeParcelable.Field(id=3, getter="getLongValues")
    private final long @Nullable [] mLongValues;
    @SafeParcelable.Field(id=4, getter="getDoubleValues")
    private final double @Nullable [] mDoubleValues;
    @SafeParcelable.Field(id=5, getter="getBooleanValues")
    private final boolean @Nullable [] mBooleanValues;
    @SafeParcelable.Field(id=6, getter="getBytesValues")
    private final byte @Nullable [][] mBytesValues;
    @SafeParcelable.Field(id=7, getter="getDocumentValues")
    private final GenericDocumentParcel @Nullable [] mDocumentValues;
    @SafeParcelable.Field(id=8, getter="getEmbeddingValues")
    private final EmbeddingVector @Nullable [] mEmbeddingValues;
    @SafeParcelable.Field(id=9, getter="getBlobHandleValues")
    private final AppSearchBlobHandle @Nullable [] mBlobHandleValues;
    private @Nullable Integer mHashCode;

    @SafeParcelable.Constructor
    PropertyParcel(@SafeParcelable.Param(id=1) @NonNull String propertyName, @SafeParcelable.Param(id=2) String @Nullable [] stringValues, @SafeParcelable.Param(id=3) long @Nullable [] longValues, @SafeParcelable.Param(id=4) double @Nullable [] doubleValues, @SafeParcelable.Param(id=5) boolean @Nullable [] booleanValues, @SafeParcelable.Param(id=6) byte @Nullable [][] bytesValues, @SafeParcelable.Param(id=7) GenericDocumentParcel @Nullable [] documentValues, @SafeParcelable.Param(id=8) EmbeddingVector @Nullable [] embeddingValues, @SafeParcelable.Param(id=9) AppSearchBlobHandle @Nullable [] blobHandleValues) {
        this.mPropertyName = Objects.requireNonNull(propertyName);
        this.mStringValues = stringValues;
        this.mLongValues = longValues;
        this.mDoubleValues = doubleValues;
        this.mBooleanValues = booleanValues;
        this.mBytesValues = bytesValues;
        this.mDocumentValues = documentValues;
        this.mEmbeddingValues = embeddingValues;
        this.mBlobHandleValues = blobHandleValues;
        this.checkOnlyOneArrayCanBeSet();
    }

    public @NonNull String getPropertyName() {
        return this.mPropertyName;
    }

    public String @Nullable [] getStringValues() {
        return this.mStringValues;
    }

    public long @Nullable [] getLongValues() {
        return this.mLongValues;
    }

    public double @Nullable [] getDoubleValues() {
        return this.mDoubleValues;
    }

    public boolean @Nullable [] getBooleanValues() {
        return this.mBooleanValues;
    }

    public byte @Nullable [][] getBytesValues() {
        return this.mBytesValues;
    }

    public GenericDocumentParcel @Nullable [] getDocumentValues() {
        return this.mDocumentValues;
    }

    public EmbeddingVector @Nullable [] getEmbeddingValues() {
        return this.mEmbeddingValues;
    }

    public AppSearchBlobHandle @Nullable [] getBlobHandleValues() {
        return this.mBlobHandleValues;
    }

    public @Nullable Object getValues() {
        if (this.mStringValues != null) {
            return this.mStringValues;
        }
        if (this.mLongValues != null) {
            return this.mLongValues;
        }
        if (this.mDoubleValues != null) {
            return this.mDoubleValues;
        }
        if (this.mBooleanValues != null) {
            return this.mBooleanValues;
        }
        if (this.mBytesValues != null) {
            return this.mBytesValues;
        }
        if (this.mDocumentValues != null) {
            return this.mDocumentValues;
        }
        if (this.mEmbeddingValues != null) {
            return this.mEmbeddingValues;
        }
        if (this.mBlobHandleValues != null) {
            return this.mBlobHandleValues;
        }
        return null;
    }

    private void checkOnlyOneArrayCanBeSet() {
        int notNullCount = 0;
        if (this.mStringValues != null) {
            ++notNullCount;
        }
        if (this.mLongValues != null) {
            ++notNullCount;
        }
        if (this.mDoubleValues != null) {
            ++notNullCount;
        }
        if (this.mBooleanValues != null) {
            ++notNullCount;
        }
        if (this.mBytesValues != null) {
            ++notNullCount;
        }
        if (this.mDocumentValues != null) {
            ++notNullCount;
        }
        if (this.mEmbeddingValues != null) {
            ++notNullCount;
        }
        if (this.mBlobHandleValues != null) {
            ++notNullCount;
        }
        if (notNullCount == 0 || notNullCount > 1) {
            throw new IllegalArgumentException("One and only one type array can be set in PropertyParcel");
        }
    }

    public int hashCode() {
        if (this.mHashCode == null) {
            int hashCode = 0;
            if (this.mStringValues != null) {
                hashCode = Arrays.hashCode(this.mStringValues);
            } else if (this.mLongValues != null) {
                hashCode = Arrays.hashCode(this.mLongValues);
            } else if (this.mDoubleValues != null) {
                hashCode = Arrays.hashCode(this.mDoubleValues);
            } else if (this.mBooleanValues != null) {
                hashCode = Arrays.hashCode(this.mBooleanValues);
            } else if (this.mBytesValues != null) {
                hashCode = Arrays.deepHashCode((Object[])this.mBytesValues);
            } else if (this.mDocumentValues != null) {
                hashCode = Arrays.hashCode(this.mDocumentValues);
            } else if (this.mEmbeddingValues != null) {
                hashCode = Arrays.deepHashCode(this.mEmbeddingValues);
            } else if (this.mBlobHandleValues != null) {
                hashCode = Arrays.deepHashCode(this.mBlobHandleValues);
            }
            this.mHashCode = Objects.hash(this.mPropertyName, hashCode);
        }
        return this.mHashCode;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PropertyParcel)) {
            return false;
        }
        PropertyParcel otherPropertyParcel = (PropertyParcel)other;
        if (!this.mPropertyName.equals(otherPropertyParcel.mPropertyName)) {
            return false;
        }
        return Arrays.equals(this.mStringValues, otherPropertyParcel.mStringValues) && Arrays.equals(this.mLongValues, otherPropertyParcel.mLongValues) && Arrays.equals(this.mDoubleValues, otherPropertyParcel.mDoubleValues) && Arrays.equals(this.mBooleanValues, otherPropertyParcel.mBooleanValues) && Arrays.deepEquals((Object[])this.mBytesValues, (Object[])otherPropertyParcel.mBytesValues) && Arrays.equals(this.mDocumentValues, otherPropertyParcel.mDocumentValues) && Arrays.deepEquals(this.mEmbeddingValues, otherPropertyParcel.mEmbeddingValues) && Arrays.deepEquals(this.mBlobHandleValues, otherPropertyParcel.mBlobHandleValues);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        PropertyParcelCreator.writeToParcel(this, dest, flags);
    }

    public static class Builder {
        private String mPropertyName;
        private String[] mStringValues;
        private long[] mLongValues;
        private double[] mDoubleValues;
        private boolean[] mBooleanValues;
        private byte[][] mBytesValues;
        private GenericDocumentParcel[] mDocumentValues;
        private EmbeddingVector[] mEmbeddingValues;
        private AppSearchBlobHandle[] mBlobHandleValues;

        public Builder(@NonNull String propertyName) {
            this.mPropertyName = Objects.requireNonNull(propertyName);
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setStringValues(String @NonNull [] stringValues) {
            this.mStringValues = Objects.requireNonNull(stringValues);
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setLongValues(long @NonNull [] longValues) {
            this.mLongValues = Objects.requireNonNull(longValues);
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setDoubleValues(double @NonNull [] doubleValues) {
            this.mDoubleValues = Objects.requireNonNull(doubleValues);
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setBooleanValues(boolean @NonNull [] booleanValues) {
            this.mBooleanValues = Objects.requireNonNull(booleanValues);
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setBytesValues(byte @NonNull [][] bytesValues) {
            this.mBytesValues = Objects.requireNonNull(bytesValues);
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setDocumentValues(GenericDocumentParcel @NonNull [] documentValues) {
            this.mDocumentValues = Objects.requireNonNull(documentValues);
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setEmbeddingValues(EmbeddingVector @NonNull [] embeddingValues) {
            this.mEmbeddingValues = Objects.requireNonNull(embeddingValues);
            return this;
        }

        @CanIgnoreReturnValue
        public @NonNull Builder setBlobHandleValues(AppSearchBlobHandle @NonNull [] blobHandleValues) {
            this.mBlobHandleValues = Objects.requireNonNull(blobHandleValues);
            return this;
        }

        public @NonNull PropertyParcel build() {
            return new PropertyParcel(this.mPropertyName, this.mStringValues, this.mLongValues, this.mDoubleValues, this.mBooleanValues, this.mBytesValues, this.mDocumentValues, this.mEmbeddingValues, this.mBlobHandleValues);
        }
    }
}

