/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.safeparcel;

import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.DocumentIndexingConfigParcelCreator;
import android.app.appsearch.safeparcel.EmbeddingIndexingConfigParcelCreator;
import android.app.appsearch.safeparcel.IntegerIndexingConfigParcelCreator;
import android.app.appsearch.safeparcel.JoinableConfigParcelCreator;
import android.app.appsearch.safeparcel.PropertyConfigParcelCreator;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.app.appsearch.safeparcel.StringIndexingConfigParcelCreator;
import android.os.Parcel;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@SafeParcelable.Class(creator="PropertyConfigParcelCreator")
public class PropertyConfigParcel
extends AbstractSafeParcelable {
    public static final  @NonNull Parcelable.Creator<PropertyConfigParcel> CREATOR = new PropertyConfigParcelCreator();
    @SafeParcelable.Field(id=1, getter="getName")
    private final String mName;
    @SafeParcelable.Field(id=2, getter="getDataType")
    private final int mDataType;
    @SafeParcelable.Field(id=3, getter="getCardinality")
    private final int mCardinality;
    @SafeParcelable.Field(id=4, getter="getSchemaType")
    private final @Nullable String mSchemaType;
    @SafeParcelable.Field(id=5, getter="getStringIndexingConfigParcel")
    private final @Nullable StringIndexingConfigParcel mStringIndexingConfigParcel;
    @SafeParcelable.Field(id=6, getter="getDocumentIndexingConfigParcel")
    private final @Nullable DocumentIndexingConfigParcel mDocumentIndexingConfigParcel;
    @SafeParcelable.Field(id=7, getter="getIntegerIndexingConfigParcel")
    private final @Nullable IntegerIndexingConfigParcel mIntegerIndexingConfigParcel;
    @SafeParcelable.Field(id=8, getter="getJoinableConfigParcel")
    private final @Nullable JoinableConfigParcel mJoinableConfigParcel;
    @SafeParcelable.Field(id=9, getter="getDescription")
    private final String mDescription;
    @SafeParcelable.Field(id=10, getter="getEmbeddingIndexingConfigParcel")
    private final EmbeddingIndexingConfigParcel mEmbeddingIndexingConfigParcel;
    @SafeParcelable.Field(id=11, getter="isScoringEnabled")
    private final boolean mScoringEnabled;
    private @Nullable Integer mHashCode;

    @SafeParcelable.Constructor
    PropertyConfigParcel(@SafeParcelable.Param(id=1) @NonNull String name, @SafeParcelable.Param(id=2) int dataType, @SafeParcelable.Param(id=3) int cardinality, @SafeParcelable.Param(id=4) @Nullable String schemaType, @SafeParcelable.Param(id=5) @Nullable StringIndexingConfigParcel stringIndexingConfigParcel, @SafeParcelable.Param(id=6) @Nullable DocumentIndexingConfigParcel documentIndexingConfigParcel, @SafeParcelable.Param(id=7) @Nullable IntegerIndexingConfigParcel integerIndexingConfigParcel, @SafeParcelable.Param(id=8) @Nullable JoinableConfigParcel joinableConfigParcel, @SafeParcelable.Param(id=9) @NonNull String description, @SafeParcelable.Param(id=10) @Nullable EmbeddingIndexingConfigParcel embeddingIndexingConfigParcel, @SafeParcelable.Param(id=11) boolean scoringEnabled) {
        this.mName = Objects.requireNonNull(name);
        this.mDataType = dataType;
        this.mCardinality = cardinality;
        this.mSchemaType = schemaType;
        this.mStringIndexingConfigParcel = stringIndexingConfigParcel;
        this.mDocumentIndexingConfigParcel = documentIndexingConfigParcel;
        this.mIntegerIndexingConfigParcel = integerIndexingConfigParcel;
        this.mJoinableConfigParcel = joinableConfigParcel;
        this.mDescription = Objects.requireNonNull(description);
        this.mEmbeddingIndexingConfigParcel = embeddingIndexingConfigParcel;
        this.mScoringEnabled = scoringEnabled;
    }

    public static @NonNull PropertyConfigParcel createForString(@NonNull String propertyName, @NonNull String description, int cardinality, @NonNull StringIndexingConfigParcel stringIndexingConfigParcel, @NonNull JoinableConfigParcel joinableConfigParcel) {
        return new PropertyConfigParcel(Objects.requireNonNull(propertyName), 1, cardinality, null, Objects.requireNonNull(stringIndexingConfigParcel), null, null, Objects.requireNonNull(joinableConfigParcel), Objects.requireNonNull(description), null, false);
    }

    public static @NonNull PropertyConfigParcel createForLong(@NonNull String propertyName, @NonNull String description, int cardinality, int indexingType, boolean scoringEnabled) {
        return new PropertyConfigParcel(Objects.requireNonNull(propertyName), 2, cardinality, null, null, null, new IntegerIndexingConfigParcel(indexingType), null, Objects.requireNonNull(description), null, scoringEnabled);
    }

    public static @NonNull PropertyConfigParcel createForDouble(@NonNull String propertyName, @NonNull String description, int cardinality, boolean scoringEnabled) {
        return new PropertyConfigParcel(Objects.requireNonNull(propertyName), 3, cardinality, null, null, null, null, null, Objects.requireNonNull(description), null, scoringEnabled);
    }

    public static @NonNull PropertyConfigParcel createForBoolean(@NonNull String propertyName, @NonNull String description, int cardinality, boolean scoringEnabled) {
        return new PropertyConfigParcel(Objects.requireNonNull(propertyName), 4, cardinality, null, null, null, null, null, Objects.requireNonNull(description), null, scoringEnabled);
    }

    public static @NonNull PropertyConfigParcel createForBytes(@NonNull String propertyName, @NonNull String description, int cardinality) {
        return new PropertyConfigParcel(Objects.requireNonNull(propertyName), 5, cardinality, null, null, null, null, null, Objects.requireNonNull(description), null, false);
    }

    public static @NonNull PropertyConfigParcel createForDocument(@NonNull String propertyName, @NonNull String description, int cardinality, @NonNull String schemaType, @NonNull DocumentIndexingConfigParcel documentIndexingConfigParcel) {
        return new PropertyConfigParcel(Objects.requireNonNull(propertyName), 6, cardinality, Objects.requireNonNull(schemaType), null, Objects.requireNonNull(documentIndexingConfigParcel), null, null, Objects.requireNonNull(description), null, false);
    }

    public static @NonNull PropertyConfigParcel createForEmbedding(@NonNull String propertyName, @NonNull String description, int cardinality, int indexingType, int quantizationType) {
        return new PropertyConfigParcel(Objects.requireNonNull(propertyName), 7, cardinality, null, null, null, null, null, Objects.requireNonNull(description), new EmbeddingIndexingConfigParcel(indexingType, quantizationType), false);
    }

    public static @NonNull PropertyConfigParcel createForBlobHandle(@NonNull String propertyName, @NonNull String description, int cardinality) {
        return new PropertyConfigParcel(Objects.requireNonNull(propertyName), 8, cardinality, null, null, null, null, null, Objects.requireNonNull(description), null, false);
    }

    public @NonNull String getName() {
        return this.mName;
    }

    public @NonNull String getDescription() {
        return this.mDescription;
    }

    public int getDataType() {
        return this.mDataType;
    }

    public int getCardinality() {
        return this.mCardinality;
    }

    public @Nullable String getSchemaType() {
        return this.mSchemaType;
    }

    public @Nullable StringIndexingConfigParcel getStringIndexingConfigParcel() {
        return this.mStringIndexingConfigParcel;
    }

    public @Nullable DocumentIndexingConfigParcel getDocumentIndexingConfigParcel() {
        return this.mDocumentIndexingConfigParcel;
    }

    public @Nullable IntegerIndexingConfigParcel getIntegerIndexingConfigParcel() {
        return this.mIntegerIndexingConfigParcel;
    }

    public @Nullable JoinableConfigParcel getJoinableConfigParcel() {
        return this.mJoinableConfigParcel;
    }

    public @Nullable EmbeddingIndexingConfigParcel getEmbeddingIndexingConfigParcel() {
        return this.mEmbeddingIndexingConfigParcel;
    }

    public boolean isScoringEnabled() {
        return this.mScoringEnabled;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        PropertyConfigParcelCreator.writeToParcel(this, dest, flags);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PropertyConfigParcel)) {
            return false;
        }
        PropertyConfigParcel otherProperty = (PropertyConfigParcel)other;
        return Objects.equals(this.mName, otherProperty.mName) && Objects.equals(this.mDescription, otherProperty.mDescription) && Objects.equals(this.mDataType, otherProperty.mDataType) && Objects.equals(this.mCardinality, otherProperty.mCardinality) && Objects.equals(this.mSchemaType, otherProperty.mSchemaType) && Objects.equals(this.mStringIndexingConfigParcel, otherProperty.mStringIndexingConfigParcel) && Objects.equals(this.mDocumentIndexingConfigParcel, otherProperty.mDocumentIndexingConfigParcel) && Objects.equals(this.mIntegerIndexingConfigParcel, otherProperty.mIntegerIndexingConfigParcel) && Objects.equals(this.mJoinableConfigParcel, otherProperty.mJoinableConfigParcel) && Objects.equals(this.mEmbeddingIndexingConfigParcel, otherProperty.mEmbeddingIndexingConfigParcel) && this.mScoringEnabled == otherProperty.mScoringEnabled;
    }

    public int hashCode() {
        if (this.mHashCode == null) {
            this.mHashCode = Objects.hash(this.mName, this.mDescription, this.mDataType, this.mCardinality, this.mSchemaType, this.mStringIndexingConfigParcel, this.mDocumentIndexingConfigParcel, this.mIntegerIndexingConfigParcel, this.mJoinableConfigParcel, this.mEmbeddingIndexingConfigParcel, this.mScoringEnabled);
        }
        return this.mHashCode;
    }

    public @NonNull String toString() {
        return "{name: " + this.mName + ", description: " + this.mDescription + ", dataType: " + this.mDataType + ", cardinality: " + this.mCardinality + ", schemaType: " + this.mSchemaType + ", stringIndexingConfigParcel: " + this.mStringIndexingConfigParcel + ", documentIndexingConfigParcel: " + this.mDocumentIndexingConfigParcel + ", integerIndexingConfigParcel: " + this.mIntegerIndexingConfigParcel + ", joinableConfigParcel: " + this.mJoinableConfigParcel + ", embeddingIndexingConfigParcel: " + this.mEmbeddingIndexingConfigParcel + ", isScoringEnabled: " + this.mScoringEnabled + "}";
    }

    @SafeParcelable.Class(creator="StringIndexingConfigParcelCreator")
    public static class StringIndexingConfigParcel
    extends AbstractSafeParcelable {
        public static final  @NonNull Parcelable.Creator<StringIndexingConfigParcel> CREATOR = new StringIndexingConfigParcelCreator();
        @SafeParcelable.Field(id=1, getter="getIndexingType")
        private final int mIndexingType;
        @SafeParcelable.Field(id=2, getter="getTokenizerType")
        private final int mTokenizerType;

        @SafeParcelable.Constructor
        public StringIndexingConfigParcel(@SafeParcelable.Param(id=1) int indexingType, @SafeParcelable.Param(id=2) int tokenizerType) {
            this.mIndexingType = indexingType;
            this.mTokenizerType = tokenizerType;
        }

        public int getIndexingType() {
            return this.mIndexingType;
        }

        public int getTokenizerType() {
            return this.mTokenizerType;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            StringIndexingConfigParcelCreator.writeToParcel(this, dest, flags);
        }

        public int hashCode() {
            return Objects.hash(this.mIndexingType, this.mTokenizerType);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StringIndexingConfigParcel)) {
                return false;
            }
            StringIndexingConfigParcel otherObject = (StringIndexingConfigParcel)other;
            return this.mIndexingType == otherObject.mIndexingType && Objects.equals(this.mTokenizerType, otherObject.mTokenizerType);
        }

        public @NonNull String toString() {
            return "{indexingType: " + this.mIndexingType + ", tokenizerType: " + this.mTokenizerType + "}";
        }
    }

    @SafeParcelable.Class(creator="DocumentIndexingConfigParcelCreator")
    public static class DocumentIndexingConfigParcel
    extends AbstractSafeParcelable {
        public static final  @NonNull Parcelable.Creator<DocumentIndexingConfigParcel> CREATOR = new DocumentIndexingConfigParcelCreator();
        @SafeParcelable.Field(id=1, getter="shouldIndexNestedProperties")
        private final boolean mIndexNestedProperties;
        @SafeParcelable.Field(id=2, getter="getIndexableNestedPropertiesList")
        private final @NonNull List<String> mIndexableNestedPropertiesList;

        @SafeParcelable.Constructor
        public DocumentIndexingConfigParcel(@SafeParcelable.Param(id=1) boolean indexNestedProperties, @SafeParcelable.Param(id=2) @NonNull List<String> indexableNestedPropertiesList) {
            this.mIndexNestedProperties = indexNestedProperties;
            this.mIndexableNestedPropertiesList = Objects.requireNonNull(indexableNestedPropertiesList);
        }

        public boolean shouldIndexNestedProperties() {
            return this.mIndexNestedProperties;
        }

        public @NonNull List<String> getIndexableNestedPropertiesList() {
            return this.mIndexableNestedPropertiesList;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            DocumentIndexingConfigParcelCreator.writeToParcel(this, dest, flags);
        }

        public int hashCode() {
            return Objects.hash(this.mIndexNestedProperties, this.mIndexableNestedPropertiesList);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DocumentIndexingConfigParcel)) {
                return false;
            }
            DocumentIndexingConfigParcel otherObject = (DocumentIndexingConfigParcel)other;
            return Objects.equals(this.mIndexNestedProperties, otherObject.mIndexNestedProperties) && Objects.equals(this.mIndexableNestedPropertiesList, otherObject.mIndexableNestedPropertiesList);
        }

        public @NonNull String toString() {
            return "{indexNestedProperties: " + this.mIndexNestedProperties + ", indexableNestedPropertiesList: " + this.mIndexableNestedPropertiesList + "}";
        }
    }

    @SafeParcelable.Class(creator="IntegerIndexingConfigParcelCreator")
    public static class IntegerIndexingConfigParcel
    extends AbstractSafeParcelable {
        public static final  @NonNull Parcelable.Creator<IntegerIndexingConfigParcel> CREATOR = new IntegerIndexingConfigParcelCreator();
        @SafeParcelable.Field(id=1, getter="getIndexingType")
        private final int mIndexingType;

        @SafeParcelable.Constructor
        public IntegerIndexingConfigParcel(@SafeParcelable.Param(id=1) int indexingType) {
            this.mIndexingType = indexingType;
        }

        public int getIndexingType() {
            return this.mIndexingType;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            IntegerIndexingConfigParcelCreator.writeToParcel(this, dest, flags);
        }

        public int hashCode() {
            return Objects.hashCode(this.mIndexingType);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IntegerIndexingConfigParcel)) {
                return false;
            }
            IntegerIndexingConfigParcel otherObject = (IntegerIndexingConfigParcel)other;
            return this.mIndexingType == otherObject.mIndexingType;
        }

        public @NonNull String toString() {
            return "{indexingType: " + this.mIndexingType + "}";
        }
    }

    @SafeParcelable.Class(creator="JoinableConfigParcelCreator")
    public static class JoinableConfigParcel
    extends AbstractSafeParcelable {
        public static final  @NonNull Parcelable.Creator<JoinableConfigParcel> CREATOR = new JoinableConfigParcelCreator();
        @SafeParcelable.Field(id=1, getter="getJoinableValueType")
        private final int mJoinableValueType;
        @SafeParcelable.Field(id=3, getter="getDeletePropagationType")
        private final int mDeletePropagationType;

        @SafeParcelable.Constructor
        public JoinableConfigParcel(@SafeParcelable.Param(id=1) int joinableValueType, @SafeParcelable.Param(id=3) int deletePropagationType) {
            this.mJoinableValueType = joinableValueType;
            this.mDeletePropagationType = deletePropagationType;
        }

        public int getJoinableValueType() {
            return this.mJoinableValueType;
        }

        public int getDeletePropagationType() {
            return this.mDeletePropagationType;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            JoinableConfigParcelCreator.writeToParcel(this, dest, flags);
        }

        public int hashCode() {
            return Objects.hash(this.mJoinableValueType, this.mDeletePropagationType);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JoinableConfigParcel)) {
                return false;
            }
            JoinableConfigParcel otherObject = (JoinableConfigParcel)other;
            return Objects.equals(this.mJoinableValueType, otherObject.mJoinableValueType) && this.mDeletePropagationType == otherObject.mDeletePropagationType;
        }

        public @NonNull String toString() {
            return "{joinableValueType: " + this.mJoinableValueType + ", deletePropagationType: " + this.mDeletePropagationType + "}";
        }
    }

    @SafeParcelable.Class(creator="EmbeddingIndexingConfigParcelCreator")
    public static class EmbeddingIndexingConfigParcel
    extends AbstractSafeParcelable {
        public static final  @NonNull Parcelable.Creator<EmbeddingIndexingConfigParcel> CREATOR = new EmbeddingIndexingConfigParcelCreator();
        @SafeParcelable.Field(id=1, getter="getIndexingType")
        private final int mIndexingType;
        @SafeParcelable.Field(id=2, getter="getQuantizationType")
        private final int mQuantizationType;

        @SafeParcelable.Constructor
        public EmbeddingIndexingConfigParcel(@SafeParcelable.Param(id=1) int indexingType, @SafeParcelable.Param(id=2) int quantizationType) {
            this.mIndexingType = indexingType;
            this.mQuantizationType = quantizationType;
        }

        public int getIndexingType() {
            return this.mIndexingType;
        }

        public int getQuantizationType() {
            return this.mQuantizationType;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            EmbeddingIndexingConfigParcelCreator.writeToParcel(this, dest, flags);
        }

        public int hashCode() {
            return Objects.hash(this.mIndexingType, this.mQuantizationType);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EmbeddingIndexingConfigParcel)) {
                return false;
            }
            EmbeddingIndexingConfigParcel otherObject = (EmbeddingIndexingConfigParcel)other;
            return this.mIndexingType == otherObject.mIndexingType && this.mQuantizationType == otherObject.mQuantizationType;
        }

        public @NonNull String toString() {
            return "{indexingType: " + this.mIndexingType + ", quantizationType: " + this.mQuantizationType + "}";
        }
    }
}

