/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.safeparcel;

import android.annotation.FlaggedApi;
import android.annotation.SuppressLint;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.PackageIdentifierParcelCreator;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@SafeParcelable.Class(creator="PackageIdentifierParcelCreator")
@SuppressLint(value={"BanParcelableUsage"})
public class PackageIdentifierParcel
extends AbstractSafeParcelable
implements Parcelable {
    public static final @NonNull Parcelable.Creator<PackageIdentifierParcel> CREATOR = new PackageIdentifierParcelCreator();
    @SafeParcelable.Field(id=1, getter="getPackageName")
    private final String mPackageName;
    @SafeParcelable.Field(id=2, getter="getSha256Certificate")
    private final byte[] mSha256Certificate;

    @SafeParcelable.Constructor
    public PackageIdentifierParcel(@SafeParcelable.Param(id=1) @NonNull String packageName, @SafeParcelable.Param(id=2) byte @NonNull [] sha256Certificate) {
        this.mPackageName = Objects.requireNonNull(packageName);
        this.mSha256Certificate = Objects.requireNonNull(sha256Certificate);
    }

    public @NonNull String getPackageName() {
        return this.mPackageName;
    }

    public byte @NonNull [] getSha256Certificate() {
        return this.mSha256Certificate;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PackageIdentifierParcel)) {
            return false;
        }
        PackageIdentifierParcel other = (PackageIdentifierParcel)obj;
        return this.mPackageName.equals(other.mPackageName) && Arrays.equals(this.mSha256Certificate, other.mSha256Certificate);
    }

    public int hashCode() {
        return Objects.hash(this.mPackageName, Arrays.hashCode(this.mSha256Certificate));
    }

    @Override
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        PackageIdentifierParcelCreator.writeToParcel(this, dest, flags);
    }
}

