/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.app.appsearch.AppSearchSchema;
import android.app.appsearch.Migrator;
import android.app.appsearch.PackageIdentifier;
import android.app.appsearch.SchemaVisibilityConfig;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.internal.util.Preconditions;
import android.util.ArrayMap;
import android.util.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SetSchemaRequest {
    public static final int READ_SMS = 1;
    public static final int READ_CALENDAR = 2;
    public static final int READ_CONTACTS = 3;
    public static final int READ_EXTERNAL_STORAGE = 4;
    public static final int READ_HOME_APP_SEARCH_DATA = 5;
    public static final int READ_ASSISTANT_APP_SEARCH_DATA = 6;
    public static final int ENTERPRISE_ACCESS = 7;
    public static final int MANAGED_PROFILE_CONTACTS_ACCESS = 8;
    public static final int EXECUTE_APP_FUNCTIONS = 9;
    public static final int EXECUTE_APP_FUNCTIONS_TRUSTED = 10;
    public static final int PACKAGE_USAGE_STATS = 11;
    private final Set<AppSearchSchema> mSchemas;
    private final Set<String> mSchemasNotDisplayedBySystem;
    private final Map<String, Set<PackageIdentifier>> mSchemasVisibleToPackages;
    private final Map<String, Set<Set<Integer>>> mSchemasVisibleToPermissions;
    private final Map<String, PackageIdentifier> mPubliclyVisibleSchemas;
    private final Map<String, Set<SchemaVisibilityConfig>> mSchemasVisibleToConfigs;
    private final Map<String, Migrator> mMigrators;
    private final boolean mForceOverride;
    private final int mVersion;

    SetSchemaRequest(@NonNull Set<AppSearchSchema> schemas, @NonNull Set<String> schemasNotDisplayedBySystem, @NonNull Map<String, Set<PackageIdentifier>> schemasVisibleToPackages, @NonNull Map<String, Set<Set<Integer>>> schemasVisibleToPermissions, @NonNull Map<String, PackageIdentifier> publiclyVisibleSchemas, @NonNull Map<String, Set<SchemaVisibilityConfig>> schemasVisibleToConfigs, @NonNull Map<String, Migrator> migrators, boolean forceOverride, int version) {
        this.mSchemas = Objects.requireNonNull(schemas);
        this.mSchemasNotDisplayedBySystem = Objects.requireNonNull(schemasNotDisplayedBySystem);
        this.mSchemasVisibleToPackages = Objects.requireNonNull(schemasVisibleToPackages);
        this.mSchemasVisibleToPermissions = Objects.requireNonNull(schemasVisibleToPermissions);
        this.mPubliclyVisibleSchemas = Objects.requireNonNull(publiclyVisibleSchemas);
        this.mSchemasVisibleToConfigs = Objects.requireNonNull(schemasVisibleToConfigs);
        this.mMigrators = Objects.requireNonNull(migrators);
        this.mForceOverride = forceOverride;
        this.mVersion = version;
    }

    @NonNull
    public Set<AppSearchSchema> getSchemas() {
        return Collections.unmodifiableSet(this.mSchemas);
    }

    @NonNull
    public Set<String> getSchemasNotDisplayedBySystem() {
        return Collections.unmodifiableSet(this.mSchemasNotDisplayedBySystem);
    }

    @NonNull
    public Map<String, Set<PackageIdentifier>> getSchemasVisibleToPackages() {
        ArrayMap<String, Set<PackageIdentifier>> copy = new ArrayMap<String, Set<PackageIdentifier>>();
        for (Map.Entry<String, Set<PackageIdentifier>> entry : this.mSchemasVisibleToPackages.entrySet()) {
            copy.put(entry.getKey(), new ArraySet(entry.getValue()));
        }
        return copy;
    }

    @SuppressLint(value={"RequiresPermission"})
    @NonNull
    public Map<String, Set<Set<Integer>>> getRequiredPermissionsForSchemaTypeVisibility() {
        return SetSchemaRequest.deepCopy(this.mSchemasVisibleToPermissions);
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_set_publicly_visible_schema")
    @NonNull
    public Map<String, PackageIdentifier> getPubliclyVisibleSchemas() {
        return Collections.unmodifiableMap(this.mPubliclyVisibleSchemas);
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_set_schema_visible_to_configs")
    @NonNull
    public Map<String, Set<SchemaVisibilityConfig>> getSchemasVisibleToConfigs() {
        ArrayMap<String, Set<SchemaVisibilityConfig>> copy = new ArrayMap<String, Set<SchemaVisibilityConfig>>();
        for (Map.Entry<String, Set<SchemaVisibilityConfig>> entry : this.mSchemasVisibleToConfigs.entrySet()) {
            copy.put(entry.getKey(), new ArraySet(entry.getValue()));
        }
        return copy;
    }

    @NonNull
    public Map<String, Migrator> getMigrators() {
        return Collections.unmodifiableMap(this.mMigrators);
    }

    @NonNull
    public Map<String, Set<PackageIdentifier>> getSchemasVisibleToPackagesInternal() {
        return this.mSchemasVisibleToPackages;
    }

    public boolean isForceOverride() {
        return this.mForceOverride;
    }

    public int getVersion() {
        return this.mVersion;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SetSchemaRequest)) {
            return false;
        }
        SetSchemaRequest otherRequest = (SetSchemaRequest)other;
        return this.mSchemas.equals(otherRequest.mSchemas) && this.mSchemasNotDisplayedBySystem.equals(otherRequest.mSchemasNotDisplayedBySystem) && this.mSchemasVisibleToPackages.equals(otherRequest.mSchemasVisibleToPackages) && this.mSchemasVisibleToPermissions.equals(otherRequest.mSchemasVisibleToPermissions) && this.mPubliclyVisibleSchemas.equals(otherRequest.mPubliclyVisibleSchemas) && this.mSchemasVisibleToConfigs.equals(otherRequest.mSchemasVisibleToConfigs) && this.mMigrators.equals(otherRequest.mMigrators) && this.mForceOverride == otherRequest.mForceOverride && this.mVersion == otherRequest.mVersion;
    }

    public int hashCode() {
        return Objects.hash(this.mSchemas, this.mSchemasNotDisplayedBySystem, this.mSchemasVisibleToPackages, this.mSchemasVisibleToPermissions, this.mPubliclyVisibleSchemas, this.mSchemasVisibleToConfigs, this.mMigrators, this.mForceOverride, this.mVersion);
    }

    private static ArrayMap<String, Set<Set<Integer>>> deepCopy(@NonNull Map<String, Set<Set<Integer>>> original) {
        ArrayMap<String, Set<Set<Integer>>> copy = new ArrayMap<String, Set<Set<Integer>>>(original.size());
        for (Map.Entry<String, Set<Set<Integer>>> entry : original.entrySet()) {
            ArraySet<ArraySet<Integer>> valueCopy = new ArraySet<ArraySet<Integer>>();
            for (Set<Integer> innerValue : entry.getValue()) {
                valueCopy.add(new ArraySet<Integer>(innerValue));
            }
            copy.put(entry.getKey(), valueCopy);
        }
        return copy;
    }

    public static class Builder {
        private static final int DEFAULT_VERSION = 1;
        private ArraySet<AppSearchSchema> mSchemas = new ArraySet();
        private ArraySet<String> mSchemasNotDisplayedBySystem = new ArraySet();
        private ArrayMap<String, Set<PackageIdentifier>> mSchemasVisibleToPackages = new ArrayMap();
        private ArrayMap<String, Set<Set<Integer>>> mSchemasVisibleToPermissions = new ArrayMap();
        private ArrayMap<String, PackageIdentifier> mPubliclyVisibleSchemas = new ArrayMap();
        private ArrayMap<String, Set<SchemaVisibilityConfig>> mSchemaVisibleToConfigs = new ArrayMap();
        private ArrayMap<String, Migrator> mMigrators = new ArrayMap();
        private boolean mForceOverride = false;
        private int mVersion = 1;
        private boolean mBuilt = false;

        public Builder() {
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        public Builder(@NonNull SetSchemaRequest request) {
            this.mSchemas.addAll(request.mSchemas);
            this.mSchemasNotDisplayedBySystem.addAll(request.mSchemasNotDisplayedBySystem);
            for (Map.Entry<String, Set<PackageIdentifier>> entry : request.mSchemasVisibleToPackages.entrySet()) {
                this.mSchemasVisibleToPackages.put(entry.getKey(), new ArraySet(entry.getValue()));
            }
            this.mSchemasVisibleToPermissions = SetSchemaRequest.deepCopy(request.mSchemasVisibleToPermissions);
            this.mPubliclyVisibleSchemas.putAll(request.mPubliclyVisibleSchemas);
            for (Map.Entry<String, Set<Object>> entry : request.mSchemasVisibleToConfigs.entrySet()) {
                this.mSchemaVisibleToConfigs.put(entry.getKey(), new ArraySet(entry.getValue()));
            }
            this.mMigrators.putAll(request.mMigrators);
            this.mForceOverride = request.mForceOverride;
            this.mVersion = request.mVersion;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addSchemas(AppSearchSchema ... schemas) {
            Objects.requireNonNull(schemas);
            this.resetIfBuilt();
            return this.addSchemas(Arrays.asList(schemas));
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addSchemas(@NonNull Collection<AppSearchSchema> schemas) {
            Objects.requireNonNull(schemas);
            this.resetIfBuilt();
            this.mSchemas.addAll(schemas);
            return this;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder clearSchemas() {
            this.resetIfBuilt();
            this.mSchemas.clear();
            return this;
        }

        @CanIgnoreReturnValue
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NonNull
        public Builder setSchemaTypeDisplayedBySystem(@NonNull String schemaType, boolean displayed) {
            Objects.requireNonNull(schemaType);
            this.resetIfBuilt();
            if (displayed) {
                this.mSchemasNotDisplayedBySystem.remove(schemaType);
            } else {
                this.mSchemasNotDisplayedBySystem.add(schemaType);
            }
            return this;
        }

        @CanIgnoreReturnValue
        @SuppressLint(value={"MissingGetterMatchingBuilder", "RequiresPermission"})
        @NonNull
        public Builder addRequiredPermissionsForSchemaTypeVisibility(@NonNull String schemaType, @NonNull Set<Integer> permissions) {
            Objects.requireNonNull(schemaType);
            Objects.requireNonNull(permissions);
            for (int permission2 : permissions) {
                Preconditions.checkArgumentInRange(permission2, 1, 11, "permission");
            }
            this.resetIfBuilt();
            Set<Set<Integer>> visibleToPermissions = this.mSchemasVisibleToPermissions.get(schemaType);
            if (visibleToPermissions == null) {
                visibleToPermissions = new ArraySet<Set<Integer>>();
                this.mSchemasVisibleToPermissions.put(schemaType, visibleToPermissions);
            }
            visibleToPermissions.add(permissions);
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder clearRequiredPermissionsForSchemaTypeVisibility(@NonNull String schemaType) {
            Objects.requireNonNull(schemaType);
            this.resetIfBuilt();
            this.mSchemasVisibleToPermissions.remove(schemaType);
            return this;
        }

        @CanIgnoreReturnValue
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NonNull
        public Builder setSchemaTypeVisibilityForPackage(@NonNull String schemaType, boolean visible, @NonNull PackageIdentifier packageIdentifier) {
            Objects.requireNonNull(schemaType);
            Objects.requireNonNull(packageIdentifier);
            this.resetIfBuilt();
            Set<PackageIdentifier> packageIdentifiers = this.mSchemasVisibleToPackages.get(schemaType);
            if (visible) {
                if (packageIdentifiers == null) {
                    packageIdentifiers = new ArraySet<PackageIdentifier>();
                }
                packageIdentifiers.add(packageIdentifier);
                this.mSchemasVisibleToPackages.put(schemaType, packageIdentifiers);
            } else {
                if (packageIdentifiers == null) {
                    return this;
                }
                packageIdentifiers.remove(packageIdentifier);
                if (packageIdentifiers.isEmpty()) {
                    this.mSchemasVisibleToPackages.remove(schemaType);
                }
            }
            return this;
        }

        @CanIgnoreReturnValue
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @FlaggedApi(value="com.android.appsearch.flags.enable_set_publicly_visible_schema")
        @NonNull
        public Builder setPubliclyVisibleSchema(@NonNull String schema, @Nullable PackageIdentifier packageIdentifier) {
            Objects.requireNonNull(schema);
            this.resetIfBuilt();
            if (packageIdentifier == null || packageIdentifier.getPackageName().isEmpty()) {
                this.mPubliclyVisibleSchemas.remove(schema);
                return this;
            }
            this.mPubliclyVisibleSchemas.put(schema, packageIdentifier);
            return this;
        }

        @CanIgnoreReturnValue
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @FlaggedApi(value="com.android.appsearch.flags.enable_set_schema_visible_to_configs")
        @NonNull
        public Builder addSchemaTypeVisibleToConfig(@NonNull String schemaType, @NonNull SchemaVisibilityConfig schemaVisibilityConfig) {
            Objects.requireNonNull(schemaType);
            Objects.requireNonNull(schemaVisibilityConfig);
            this.resetIfBuilt();
            Set<SchemaVisibilityConfig> visibleToConfigs = this.mSchemaVisibleToConfigs.get(schemaType);
            if (visibleToConfigs == null) {
                visibleToConfigs = new ArraySet<SchemaVisibilityConfig>();
                this.mSchemaVisibleToConfigs.put(schemaType, visibleToConfigs);
            }
            visibleToConfigs.add(schemaVisibilityConfig);
            return this;
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_set_schema_visible_to_configs")
        @NonNull
        public Builder clearSchemaTypeVisibleToConfigs(@NonNull String schemaType) {
            Objects.requireNonNull(schemaType);
            this.resetIfBuilt();
            this.mSchemaVisibleToConfigs.remove(schemaType);
            return this;
        }

        @CanIgnoreReturnValue
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @NonNull
        public Builder setMigrator(@NonNull String schemaType, @NonNull Migrator migrator) {
            Objects.requireNonNull(schemaType);
            Objects.requireNonNull(migrator);
            this.resetIfBuilt();
            this.mMigrators.put(schemaType, migrator);
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setMigrators(@NonNull Map<String, Migrator> migrators) {
            Objects.requireNonNull(migrators);
            this.resetIfBuilt();
            this.mMigrators.putAll(migrators);
            return this;
        }

        @FlaggedApi(value="com.android.appsearch.flags.enable_additional_builder_copy_constructors")
        @CanIgnoreReturnValue
        @NonNull
        public Builder clearMigrators() {
            this.resetIfBuilt();
            this.mMigrators.clear();
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setForceOverride(boolean forceOverride) {
            this.resetIfBuilt();
            this.mForceOverride = forceOverride;
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setVersion(int version) {
            Preconditions.checkArgument(version >= 1, "Version must be a positive number.");
            this.resetIfBuilt();
            this.mVersion = version;
            return this;
        }

        @NonNull
        public SetSchemaRequest build() {
            ArraySet<String> referencedSchemas = new ArraySet<String>(this.mSchemasNotDisplayedBySystem);
            referencedSchemas.addAll(this.mSchemasVisibleToPackages.keySet());
            referencedSchemas.addAll(this.mSchemasVisibleToPermissions.keySet());
            referencedSchemas.addAll(this.mPubliclyVisibleSchemas.keySet());
            referencedSchemas.addAll(this.mSchemaVisibleToConfigs.keySet());
            for (AppSearchSchema schema : this.mSchemas) {
                referencedSchemas.remove(schema.getSchemaType());
            }
            if (!referencedSchemas.isEmpty()) {
                throw new IllegalArgumentException("Schema types " + referencedSchemas + " referenced, but were not added.");
            }
            if (this.mSchemas.isEmpty() && this.mVersion != 1) {
                throw new IllegalArgumentException("Cannot set version to the request if schema is empty.");
            }
            this.mBuilt = true;
            return new SetSchemaRequest(this.mSchemas, this.mSchemasNotDisplayedBySystem, this.mSchemasVisibleToPackages, this.mSchemasVisibleToPermissions, this.mPubliclyVisibleSchemas, this.mSchemaVisibleToConfigs, this.mMigrators, this.mForceOverride, this.mVersion);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                ArrayMap schemasVisibleToPackages = new ArrayMap(this.mSchemasVisibleToPackages.size());
                for (Map.Entry<String, Set<PackageIdentifier>> entry : this.mSchemasVisibleToPackages.entrySet()) {
                    schemasVisibleToPackages.put(entry.getKey(), new ArraySet(entry.getValue()));
                }
                this.mSchemasVisibleToPackages = schemasVisibleToPackages;
                this.mPubliclyVisibleSchemas = new ArrayMap<String, PackageIdentifier>(this.mPubliclyVisibleSchemas);
                this.mSchemasVisibleToPermissions = SetSchemaRequest.deepCopy(this.mSchemasVisibleToPermissions);
                ArrayMap schemaVisibleToConfigs = new ArrayMap(this.mSchemaVisibleToConfigs.size());
                for (Map.Entry<String, Set<SchemaVisibilityConfig>> entry : this.mSchemaVisibleToConfigs.entrySet()) {
                    schemaVisibleToConfigs.put(entry.getKey(), new ArraySet(entry.getValue()));
                }
                this.mSchemaVisibleToConfigs = schemaVisibleToConfigs;
                this.mSchemas = new ArraySet<AppSearchSchema>(this.mSchemas);
                this.mSchemasNotDisplayedBySystem = new ArraySet<String>(this.mSchemasNotDisplayedBySystem);
                this.mMigrators = new ArrayMap<String, Migrator>(this.mMigrators);
                this.mBuilt = false;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AppSearchSupportedPermission {
    }
}

