/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.app.appsearch.PropertyPath;
import android.app.appsearch.SearchSuggestionSpecCreator;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.internal.util.Preconditions;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.app.appsearch.util.BundleUtil;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.ArraySet;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@SafeParcelable.Class(creator="SearchSuggestionSpecCreator")
public class SearchSuggestionSpec
extends AbstractSafeParcelable {
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    @NonNull
    public static final Parcelable.Creator<SearchSuggestionSpec> CREATOR = new SearchSuggestionSpecCreator();
    @SafeParcelable.Field(id=1, getter="getFilterNamespaces")
    @NonNull
    private final List<String> mFilterNamespaces;
    @SafeParcelable.Field(id=2, getter="getFilterSchemas")
    @NonNull
    private final List<String> mFilterSchemas;
    @SafeParcelable.Field(id=3)
    @NonNull
    final Bundle mFilterProperties;
    @SafeParcelable.Field(id=4)
    @NonNull
    final Bundle mFilterDocumentIds;
    @SafeParcelable.Field(id=5, getter="getRankingStrategy")
    private final int mRankingStrategy;
    @SafeParcelable.Field(id=6, getter="getMaximumResultCount")
    private final int mMaximumResultCount;
    @SafeParcelable.Field(id=7, getter="getSearchStringParameters")
    @NonNull
    private final List<String> mSearchStringParameters;
    public static final int SUGGESTION_RANKING_STRATEGY_DOCUMENT_COUNT = 0;
    public static final int SUGGESTION_RANKING_STRATEGY_TERM_FREQUENCY = 1;
    public static final int SUGGESTION_RANKING_STRATEGY_NONE = 2;

    @SafeParcelable.Constructor
    public SearchSuggestionSpec(@SafeParcelable.Param(id=1) @NonNull List<String> filterNamespaces, @SafeParcelable.Param(id=2) @NonNull List<String> filterSchemas, @SafeParcelable.Param(id=3) @NonNull Bundle filterProperties, @SafeParcelable.Param(id=4) @NonNull Bundle filterDocumentIds, @SafeParcelable.Param(id=5) int rankingStrategy, @SafeParcelable.Param(id=6) int maximumResultCount, @SafeParcelable.Param(id=7) @Nullable List<String> searchStringParameters) {
        Preconditions.checkArgument(maximumResultCount >= 1, "MaximumResultCount must be positive.");
        this.mFilterNamespaces = Objects.requireNonNull(filterNamespaces);
        this.mFilterSchemas = Objects.requireNonNull(filterSchemas);
        this.mFilterProperties = Objects.requireNonNull(filterProperties);
        this.mFilterDocumentIds = Objects.requireNonNull(filterDocumentIds);
        this.mRankingStrategy = rankingStrategy;
        this.mMaximumResultCount = maximumResultCount;
        this.mSearchStringParameters = searchStringParameters != null ? Collections.unmodifiableList(searchStringParameters) : Collections.emptyList();
    }

    public int getMaximumResultCount() {
        return this.mMaximumResultCount;
    }

    @NonNull
    public List<String> getFilterNamespaces() {
        if (this.mFilterNamespaces == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.mFilterNamespaces);
    }

    public int getRankingStrategy() {
        return this.mRankingStrategy;
    }

    @NonNull
    public List<String> getFilterSchemas() {
        if (this.mFilterSchemas == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.mFilterSchemas);
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_search_spec_filter_properties")
    @NonNull
    public Map<String, List<String>> getFilterProperties() {
        Set<String> schemas = this.mFilterProperties.keySet();
        ArrayMap<String, List<String>> typePropertyPathsMap = new ArrayMap<String, List<String>>(schemas.size());
        for (String schema : schemas) {
            typePropertyPathsMap.put(schema, (List<String>)Objects.requireNonNull(this.mFilterProperties.getStringArrayList(schema)));
        }
        return typePropertyPathsMap;
    }

    @NonNull
    public Map<String, List<String>> getFilterDocumentIds() {
        Set<String> namespaces = this.mFilterDocumentIds.keySet();
        ArrayMap<String, List<String>> documentIdsMap = new ArrayMap<String, List<String>>(namespaces.size());
        for (String namespace : namespaces) {
            documentIdsMap.put(namespace, (List<String>)Objects.requireNonNull(this.mFilterDocumentIds.getStringArrayList(namespace)));
        }
        return documentIdsMap;
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_search_spec_search_string_parameters")
    @NonNull
    public List<String> getSearchStringParameters() {
        return this.mSearchStringParameters;
    }

    @Override
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        SearchSuggestionSpecCreator.writeToParcel(this, dest, flags);
    }

    public static class Builder {
        private ArrayList<String> mNamespaces = new ArrayList();
        private ArrayList<String> mSchemas = new ArrayList();
        private Bundle mTypePropertyFilters = new Bundle();
        private Bundle mDocumentIds = new Bundle();
        private final int mTotalResultCount;
        private int mRankingStrategy = 0;
        private List<String> mSearchStringParameters = new ArrayList<String>();
        private boolean mBuilt = false;

        public Builder(int maximumResultCount) {
            Preconditions.checkArgument(maximumResultCount >= 1, "maximumResultCount must be positive.");
            this.mTotalResultCount = maximumResultCount;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addFilterNamespaces(String ... namespaces) {
            Objects.requireNonNull(namespaces);
            this.resetIfBuilt();
            return this.addFilterNamespaces(Arrays.asList(namespaces));
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addFilterNamespaces(@NonNull Collection<String> namespaces) {
            Objects.requireNonNull(namespaces);
            this.resetIfBuilt();
            this.mNamespaces.addAll(namespaces);
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setRankingStrategy(int rankingStrategy) {
            Preconditions.checkArgumentInRange(rankingStrategy, 0, 2, "Suggestion ranking strategy");
            this.resetIfBuilt();
            this.mRankingStrategy = rankingStrategy;
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addFilterSchemas(String ... schemaTypes) {
            Objects.requireNonNull(schemaTypes);
            this.resetIfBuilt();
            return this.addFilterSchemas(Arrays.asList(schemaTypes));
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addFilterSchemas(@NonNull Collection<String> schemaTypes) {
            Objects.requireNonNull(schemaTypes);
            this.resetIfBuilt();
            this.mSchemas.addAll(schemaTypes);
            return this;
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_search_spec_filter_properties")
        @NonNull
        public Builder addFilterProperties(@NonNull String schema, @NonNull Collection<String> propertyPaths) {
            Objects.requireNonNull(schema);
            Objects.requireNonNull(propertyPaths);
            this.resetIfBuilt();
            ArrayList<String> propertyPathsArrayList = new ArrayList<String>(propertyPaths.size());
            for (String propertyPath : propertyPaths) {
                Objects.requireNonNull(propertyPath);
                propertyPathsArrayList.add(propertyPath);
            }
            this.mTypePropertyFilters.putStringArrayList(schema, propertyPathsArrayList);
            return this;
        }

        @CanIgnoreReturnValue
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @FlaggedApi(value="com.android.appsearch.flags.enable_search_spec_filter_properties")
        @NonNull
        public Builder addFilterPropertyPaths(@NonNull String schema, @NonNull Collection<PropertyPath> propertyPaths) {
            Objects.requireNonNull(schema);
            Objects.requireNonNull(propertyPaths);
            ArrayList<String> propertyPathsArrayList = new ArrayList<String>(propertyPaths.size());
            for (PropertyPath propertyPath : propertyPaths) {
                propertyPathsArrayList.add(propertyPath.toString());
            }
            return this.addFilterProperties(schema, propertyPathsArrayList);
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addFilterDocumentIds(@NonNull String namespace, String ... documentIds) {
            Objects.requireNonNull(namespace);
            Objects.requireNonNull(documentIds);
            this.resetIfBuilt();
            return this.addFilterDocumentIds(namespace, Arrays.asList(documentIds));
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addFilterDocumentIds(@NonNull String namespace, @NonNull Collection<String> documentIds) {
            Objects.requireNonNull(namespace);
            Objects.requireNonNull(documentIds);
            this.resetIfBuilt();
            ArrayList<String> documentIdList = new ArrayList<String>(documentIds.size());
            for (String documentId : documentIds) {
                documentIdList.add(Objects.requireNonNull(documentId));
            }
            this.mDocumentIds.putStringArrayList(namespace, documentIdList);
            return this;
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_search_spec_search_string_parameters")
        @NonNull
        public Builder addSearchStringParameters(String ... searchStringParameters) {
            Objects.requireNonNull(searchStringParameters);
            this.resetIfBuilt();
            return this.addSearchStringParameters(Arrays.asList(searchStringParameters));
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_search_spec_search_string_parameters")
        @NonNull
        public Builder addSearchStringParameters(@NonNull List<String> searchStringParameters) {
            Objects.requireNonNull(searchStringParameters);
            this.resetIfBuilt();
            this.mSearchStringParameters.addAll(searchStringParameters);
            return this;
        }

        @NonNull
        public SearchSuggestionSpec build() {
            if (!this.mSchemas.isEmpty()) {
                ArraySet<String> schemaFilter = new ArraySet<String>(this.mSchemas);
                for (String schema : this.mTypePropertyFilters.keySet()) {
                    if (schemaFilter.contains(schema)) continue;
                    throw new IllegalStateException("The schema: " + schema + " exists in the property filter but doesn't exist in the schema filter.");
                }
            }
            if (!this.mNamespaces.isEmpty()) {
                ArraySet<String> namespaceFilter = new ArraySet<String>(this.mNamespaces);
                for (String namespace : this.mDocumentIds.keySet()) {
                    if (namespaceFilter.contains(namespace)) continue;
                    throw new IllegalStateException("The namespace: " + namespace + " exists in the document id filter but doesn't exist in the namespace filter.");
                }
            }
            this.mBuilt = true;
            return new SearchSuggestionSpec(this.mNamespaces, this.mSchemas, this.mTypePropertyFilters, this.mDocumentIds, this.mRankingStrategy, this.mTotalResultCount, this.mSearchStringParameters);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mNamespaces = new ArrayList<String>(this.mNamespaces);
                this.mSchemas = new ArrayList<String>(this.mSchemas);
                this.mTypePropertyFilters = BundleUtil.deepCopy(this.mTypePropertyFilters);
                this.mDocumentIds = BundleUtil.deepCopy(this.mDocumentIds);
                this.mSearchStringParameters = new ArrayList<String>(this.mSearchStringParameters);
                this.mBuilt = false;
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SuggestionRankingStrategy {
    }
}

