/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.appsearch.SearchSuggestionResultCreator;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.internal.util.Preconditions;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SafeParcelable.Class(creator="SearchSuggestionResultCreator")
public class SearchSuggestionResult
extends AbstractSafeParcelable {
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    @NonNull
    public static final Parcelable.Creator<SearchSuggestionResult> CREATOR = new SearchSuggestionResultCreator();
    @SafeParcelable.Field(id=1, getter="getSuggestedResult")
    private final String mSuggestedResult;
    @Nullable
    private Integer mHashCode;

    @SafeParcelable.Constructor
    SearchSuggestionResult(@SafeParcelable.Param(id=1) String suggestedResult) {
        this.mSuggestedResult = Objects.requireNonNull(suggestedResult);
    }

    @NonNull
    public String getSuggestedResult() {
        return this.mSuggestedResult;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SearchSuggestionResult)) {
            return false;
        }
        SearchSuggestionResult otherResult = (SearchSuggestionResult)other;
        return this.mSuggestedResult.equals(otherResult.mSuggestedResult);
    }

    public int hashCode() {
        if (this.mHashCode == null) {
            this.mHashCode = this.mSuggestedResult.hashCode();
        }
        return this.mHashCode;
    }

    @Override
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        SearchSuggestionResultCreator.writeToParcel(this, dest, flags);
    }

    public static class Builder {
        private String mSuggestedResult = "";

        @CanIgnoreReturnValue
        @NonNull
        public Builder setSuggestedResult(@NonNull String suggestedResult) {
            Objects.requireNonNull(suggestedResult);
            Preconditions.checkStringNotEmpty(suggestedResult);
            this.mSuggestedResult = suggestedResult;
            return this;
        }

        @NonNull
        public SearchSuggestionResult build() {
            return new SearchSuggestionResult(this.mSuggestedResult);
        }
    }
}

