/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.NonNull;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import com.android.internal.lang.System_Delegate;
import java.util.Objects;

public class ReportSystemUsageRequest {
    private final String mPackageName;
    private final String mDatabase;
    private final String mNamespace;
    private final String mDocumentId;
    private final long mUsageTimestampMillis;

    ReportSystemUsageRequest(@NonNull String packageName, @NonNull String database, @NonNull String namespace, @NonNull String documentId, long usageTimestampMillis) {
        this.mPackageName = Objects.requireNonNull(packageName);
        this.mDatabase = Objects.requireNonNull(database);
        this.mNamespace = Objects.requireNonNull(namespace);
        this.mDocumentId = Objects.requireNonNull(documentId);
        this.mUsageTimestampMillis = usageTimestampMillis;
    }

    @NonNull
    public String getPackageName() {
        return this.mPackageName;
    }

    @NonNull
    public String getDatabaseName() {
        return this.mDatabase;
    }

    @NonNull
    public String getNamespace() {
        return this.mNamespace;
    }

    @NonNull
    public String getDocumentId() {
        return this.mDocumentId;
    }

    public long getUsageTimestampMillis() {
        return this.mUsageTimestampMillis;
    }

    public static class Builder {
        private final String mPackageName;
        private final String mDatabase;
        private final String mNamespace;
        private final String mDocumentId;
        private Long mUsageTimestampMillis;

        public Builder(@NonNull String packageName, @NonNull String databaseName, @NonNull String namespace, @NonNull String documentId) {
            this.mPackageName = Objects.requireNonNull(packageName);
            this.mDatabase = Objects.requireNonNull(databaseName);
            this.mNamespace = Objects.requireNonNull(namespace);
            this.mDocumentId = Objects.requireNonNull(documentId);
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder setUsageTimestampMillis(long usageTimestampMillis) {
            this.mUsageTimestampMillis = usageTimestampMillis;
            return this;
        }

        @NonNull
        public ReportSystemUsageRequest build() {
            if (this.mUsageTimestampMillis == null) {
                this.mUsageTimestampMillis = System_Delegate.currentTimeMillis();
            }
            return new ReportSystemUsageRequest(this.mPackageName, this.mDatabase, this.mNamespace, this.mDocumentId, this.mUsageTimestampMillis);
        }
    }
}

