/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.appsearch.RemoveByDocumentIdRequestCreator;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@SafeParcelable.Class(creator="RemoveByDocumentIdRequestCreator")
public class RemoveByDocumentIdRequest
extends AbstractSafeParcelable {
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    @NonNull
    public static final Parcelable.Creator<RemoveByDocumentIdRequest> CREATOR = new RemoveByDocumentIdRequestCreator();
    @SafeParcelable.Field(id=1, getter="getNamespace")
    @NonNull
    private final String mNamespace;
    @SafeParcelable.Field(id=2)
    @NonNull
    final List<String> mIds;
    @Nullable
    private Set<String> mIdsCached;

    @SafeParcelable.Constructor
    RemoveByDocumentIdRequest(@SafeParcelable.Param(id=1) @NonNull String namespace, @SafeParcelable.Param(id=2) @NonNull List<String> ids) {
        this.mNamespace = Objects.requireNonNull(namespace);
        this.mIds = Objects.requireNonNull(ids);
    }

    @NonNull
    public String getNamespace() {
        return this.mNamespace;
    }

    @NonNull
    public Set<String> getIds() {
        if (this.mIdsCached == null) {
            this.mIdsCached = Collections.unmodifiableSet(new ArraySet<String>(this.mIds));
        }
        return this.mIdsCached;
    }

    @Override
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        RemoveByDocumentIdRequestCreator.writeToParcel(this, dest, flags);
    }

    public static class Builder {
        private final String mNamespace;
        private ArraySet<String> mIds = new ArraySet();
        private boolean mBuilt = false;

        public Builder(@NonNull String namespace) {
            this.mNamespace = Objects.requireNonNull(namespace);
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addIds(String ... ids) {
            Objects.requireNonNull(ids);
            this.resetIfBuilt();
            return this.addIds(Arrays.asList(ids));
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addIds(@NonNull Collection<String> ids) {
            Objects.requireNonNull(ids);
            this.resetIfBuilt();
            this.mIds.addAll(ids);
            return this;
        }

        @NonNull
        public RemoveByDocumentIdRequest build() {
            this.mBuilt = true;
            return new RemoveByDocumentIdRequest(this.mNamespace, new ArrayList<String>(this.mIds));
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mIds = new ArraySet<String>(this.mIds);
                this.mBuilt = false;
            }
        }
    }
}

