/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.app.appsearch.GenericDocument;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.exceptions.AppSearchException;
import android.util.ArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class PutDocumentsRequest {
    private final List<GenericDocument> mDocuments;
    private final List<GenericDocument> mTakenActions;

    PutDocumentsRequest(List<GenericDocument> documents, List<GenericDocument> takenActions) {
        this.mDocuments = documents;
        this.mTakenActions = takenActions;
    }

    @NonNull
    public List<GenericDocument> getGenericDocuments() {
        return Collections.unmodifiableList(this.mDocuments);
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_put_documents_request_add_taken_actions")
    @NonNull
    public List<GenericDocument> getTakenActionGenericDocuments() {
        return Collections.unmodifiableList(this.mTakenActions);
    }

    public static class Builder {
        private ArrayList<GenericDocument> mDocuments = new ArrayList();
        private ArrayList<GenericDocument> mTakenActions = new ArrayList();
        private boolean mBuilt = false;

        @CanIgnoreReturnValue
        @NonNull
        public Builder addGenericDocuments(GenericDocument ... documents) {
            Objects.requireNonNull(documents);
            this.resetIfBuilt();
            return this.addGenericDocuments(Arrays.asList(documents));
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addGenericDocuments(@NonNull Collection<? extends GenericDocument> documents) {
            Objects.requireNonNull(documents);
            this.resetIfBuilt();
            this.mDocuments.addAll(documents);
            return this;
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_put_documents_request_add_taken_actions")
        @NonNull
        public Builder addTakenActionGenericDocuments(GenericDocument ... takenActionGenericDocuments) throws AppSearchException {
            Objects.requireNonNull(takenActionGenericDocuments);
            this.resetIfBuilt();
            return this.addTakenActionGenericDocuments(Arrays.asList(takenActionGenericDocuments));
        }

        @CanIgnoreReturnValue
        @FlaggedApi(value="com.android.appsearch.flags.enable_put_documents_request_add_taken_actions")
        @NonNull
        public Builder addTakenActionGenericDocuments(@NonNull Collection<? extends GenericDocument> takenActionGenericDocuments) throws AppSearchException {
            Objects.requireNonNull(takenActionGenericDocuments);
            this.resetIfBuilt();
            this.mTakenActions.addAll(takenActionGenericDocuments);
            return this;
        }

        @NonNull
        public PutDocumentsRequest build() {
            int i;
            this.mBuilt = true;
            ArraySet<String> idSet = new ArraySet<String>();
            for (i = 0; i < this.mDocuments.size(); ++i) {
                idSet.add(this.mDocuments.get(i).getId());
            }
            for (i = 0; i < this.mTakenActions.size(); ++i) {
                GenericDocument takenAction = this.mTakenActions.get(i);
                if (!idSet.contains(takenAction.getId())) continue;
                throw new IllegalArgumentException("Document id " + takenAction.getId() + " cannot exist in both taken action and normal document");
            }
            return new PutDocumentsRequest(this.mDocuments, this.mTakenActions);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mDocuments = new ArrayList<GenericDocument>(this.mDocuments);
                this.mTakenActions = new ArrayList<GenericDocument>(this.mTakenActions);
                this.mBuilt = false;
            }
        }
    }
}

