/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.appsearch.EmbeddingVectorCreator;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;

@FlaggedApi(value="com.android.appsearch.flags.enable_schema_embedding_property_config")
@SafeParcelable.Class(creator="EmbeddingVectorCreator")
public class EmbeddingVector
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<EmbeddingVector> CREATOR = new EmbeddingVectorCreator();
    @SafeParcelable.Field(id=1, getter="getValues")
    @NonNull
    private final float[] mValues;
    @SafeParcelable.Field(id=2, getter="getModelSignature")
    @NonNull
    private final String mModelSignature;
    @Nullable
    private Integer mHashCode;

    @SafeParcelable.Constructor
    public EmbeddingVector(@SafeParcelable.Param(id=1) @NonNull float[] values, @SafeParcelable.Param(id=2) @NonNull String modelSignature) {
        this.mValues = Objects.requireNonNull(values);
        if (this.mValues.length == 0) {
            throw new IllegalArgumentException("Embedding values cannot be empty.");
        }
        this.mModelSignature = Objects.requireNonNull(modelSignature);
    }

    @NonNull
    public float[] getValues() {
        return this.mValues;
    }

    @NonNull
    public String getModelSignature() {
        return this.mModelSignature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof EmbeddingVector)) {
            return false;
        }
        EmbeddingVector that = (EmbeddingVector)o;
        return Arrays.equals(this.mValues, that.mValues) && this.mModelSignature.equals(that.mModelSignature);
    }

    public int hashCode() {
        if (this.mHashCode == null) {
            this.mHashCode = Objects.hash(Arrays.hashCode(this.mValues), this.mModelSignature);
        }
        return this.mHashCode;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        EmbeddingVectorCreator.writeToParcel(this, dest, flags);
    }
}

