/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.app.appsearch.AppSearchEnvironmentFactory;
import android.app.appsearch.AppSearchResult;
import android.app.appsearch.AppSearchSession;
import android.app.appsearch.EnterpriseGlobalSearchSession;
import android.app.appsearch.GlobalSearchSession;
import android.app.appsearch.aidl.AppSearchAttributionSource;
import android.app.appsearch.aidl.IAppSearchManager;
import android.app.appsearch.internal.util.Preconditions;
import android.content.Context;
import android.os.Process;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class AppSearchManager {
    private final IAppSearchManager mService;
    private final Context mContext;

    public AppSearchManager(@NonNull Context context, @NonNull IAppSearchManager service) {
        this.mContext = Objects.requireNonNull(context);
        this.mService = Objects.requireNonNull(service);
    }

    public void createSearchSession(@NonNull SearchContext searchContext, @NonNull Executor executor, @NonNull Consumer<AppSearchResult<AppSearchSession>> callback) {
        Objects.requireNonNull(searchContext);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        AppSearchSession.createSearchSession(searchContext, this.mService, this.mContext.getUser(), AppSearchAttributionSource.createAttributionSource(this.mContext, Process.myPid()), AppSearchEnvironmentFactory.getEnvironmentInstance().getCacheDir(this.mContext), executor, callback);
    }

    public void createGlobalSearchSession(@NonNull Executor executor, @NonNull Consumer<AppSearchResult<GlobalSearchSession>> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        GlobalSearchSession.createGlobalSearchSession(this.mService, this.mContext.getUser(), AppSearchAttributionSource.createAttributionSource(this.mContext, Process.myPid()), executor, callback);
    }

    @FlaggedApi(value="com.android.appsearch.flags.enable_enterprise_global_search_session")
    public void createEnterpriseGlobalSearchSession(@NonNull Executor executor, @NonNull Consumer<AppSearchResult<EnterpriseGlobalSearchSession>> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        EnterpriseGlobalSearchSession.createEnterpriseGlobalSearchSession(this.mService, this.mContext.getUser(), AppSearchAttributionSource.createAttributionSource(this.mContext, Process.myPid()), executor, callback);
    }

    public static class SearchContext {
        final String mDatabaseName;

        SearchContext(@NonNull String databaseName) {
            this.mDatabaseName = Objects.requireNonNull(databaseName);
        }

        @NonNull
        public String getDatabaseName() {
            return this.mDatabaseName;
        }

        public static class Builder {
            private final String mDatabaseName;
            private boolean mBuilt = false;

            public Builder(@NonNull String databaseName) {
                Objects.requireNonNull(databaseName);
                Preconditions.checkArgument(!databaseName.contains("/"), "Database name cannot contain '/'");
                this.mDatabaseName = databaseName;
            }

            @NonNull
            public SearchContext build() {
                Preconditions.checkState(!this.mBuilt, "Builder has already been used");
                this.mBuilt = true;
                return new SearchContext(this.mDatabaseName);
            }
        }
    }
}

