/*
 * Decompiled with CFR 0.152.
 */
package android.app.appfunctions;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.app.appfunctions.AppFunctionRuntimeMetadata;
import android.app.appfunctions.AppFunctionStaticMetadataHelper;
import android.app.appsearch.AppSearchManager;
import android.app.appsearch.AppSearchResult;
import android.app.appsearch.GlobalSearchSession;
import android.app.appsearch.JoinSpec;
import android.app.appsearch.PropertyPath;
import android.app.appsearch.SearchResult;
import android.app.appsearch.SearchResults;
import android.app.appsearch.SearchSpec;
import android.os.OutcomeReceiver;
import android.text.TextUtils;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

@FlaggedApi(value="android.app.appfunctions.flags.enable_app_function_manager")
public class AppFunctionManagerHelper {
    public static void isAppFunctionEnabled(@NonNull String functionIdentifier, @NonNull String targetPackage, @NonNull AppSearchManager appSearchManager, @NonNull Executor executor, @NonNull OutcomeReceiver<Boolean, Exception> callback) {
        Objects.requireNonNull(functionIdentifier);
        Objects.requireNonNull(targetPackage);
        Objects.requireNonNull(appSearchManager);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        appSearchManager.createGlobalSearchSession(executor, searchSessionResult -> {
            if (!searchSessionResult.isSuccess()) {
                callback.onError(AppFunctionManagerHelper.failedResultToException(searchSessionResult));
                return;
            }
            try (GlobalSearchSession searchSession = (GlobalSearchSession)searchSessionResult.getResultValue();){
                SearchResults results = AppFunctionManagerHelper.searchJoinedStaticWithRuntimeAppFunctions(Objects.requireNonNull(searchSession), targetPackage, functionIdentifier);
                results.getNextPage(executor, listAppSearchResult -> {
                    if (listAppSearchResult.isSuccess()) {
                        callback.onResult(AppFunctionManagerHelper.getEffectiveEnabledStateFromSearchResults(Objects.requireNonNull((List)listAppSearchResult.getResultValue())));
                    } else {
                        callback.onError(AppFunctionManagerHelper.failedResultToException(listAppSearchResult));
                    }
                });
                results.close();
            }
            catch (Exception e) {
                callback.onError(e);
            }
        });
    }

    @NonNull
    private static SearchResults searchJoinedStaticWithRuntimeAppFunctions(@NonNull GlobalSearchSession session, @NonNull String targetPackage, @NonNull String functionIdentifier) {
        SearchSpec runtimeSearchSpec = AppFunctionManagerHelper.getAppFunctionRuntimeMetadataSearchSpecByPackageName(targetPackage);
        JoinSpec joinSpec = new JoinSpec.Builder("appFunctionStaticMetadataQualifiedId").setNestedSearch(AppFunctionManagerHelper.buildFilerRuntimeMetadataByFunctionIdQuery(functionIdentifier), runtimeSearchSpec).build();
        SearchSpec joinedStaticWithRuntimeSearchSpec = new SearchSpec.Builder().addFilterPackageNames("android").addFilterSchemas(AppFunctionStaticMetadataHelper.getStaticSchemaNameForPackage(targetPackage)).addProjectionPaths("*", List.of(new PropertyPath("enabledByDefault"))).setJoinSpec(joinSpec).setVerbatimSearchEnabled(true).build();
        return session.search(AppFunctionManagerHelper.buildFilerStaticMetadataByFunctionIdQuery(functionIdentifier), joinedStaticWithRuntimeSearchSpec);
    }

    private static boolean getEffectiveEnabledStateFromSearchResults(@NonNull List<SearchResult> joinedStaticRuntimeResults) {
        if (joinedStaticRuntimeResults.isEmpty()) {
            throw new IllegalArgumentException("App function not found.");
        }
        List<SearchResult> runtimeMetadataResults = joinedStaticRuntimeResults.getFirst().getJoinedResults();
        if (runtimeMetadataResults.isEmpty()) {
            throw new IllegalArgumentException("App function not found.");
        }
        long enabled = runtimeMetadataResults.getFirst().getGenericDocument().getPropertyLong("enabled");
        if (enabled != 0L) {
            return enabled == 1L;
        }
        return joinedStaticRuntimeResults.getFirst().getGenericDocument().getPropertyBoolean("enabledByDefault");
    }

    @NonNull
    private static SearchSpec getAppFunctionRuntimeMetadataSearchSpecByPackageName(@NonNull String targetPackage) {
        return new SearchSpec.Builder().addFilterPackageNames("android").addFilterSchemas(AppFunctionRuntimeMetadata.getRuntimeSchemaNameForPackage(targetPackage)).setVerbatimSearchEnabled(true).build();
    }

    private static String buildFilerRuntimeMetadataByFunctionIdQuery(String functionIdentifier) {
        return TextUtils.formatSimple("%s:\"%s\"", "functionId", functionIdentifier);
    }

    private static String buildFilerStaticMetadataByFunctionIdQuery(String functionIdentifier) {
        return TextUtils.formatSimple("%s:\"%s\"", "functionId", functionIdentifier);
    }

    @NonNull
    private static Exception failedResultToException(@NonNull AppSearchResult appSearchResult) {
        Exception exception;
        switch (appSearchResult.getResultCode()) {
            case 3: {
                exception = new AppFunctionNotFoundException(appSearchResult.getErrorMessage());
                break;
            }
            case 4: {
                exception = new IOException(appSearchResult.getErrorMessage());
                break;
            }
            case 8: {
                exception = new SecurityException(appSearchResult.getErrorMessage());
                break;
            }
            default: {
                exception = new IllegalStateException(appSearchResult.getErrorMessage());
            }
        }
        return exception;
    }

    public static class AppFunctionNotFoundException
    extends RuntimeException {
        private AppFunctionNotFoundException(@NonNull String errorMessage) {
            super(errorMessage);
        }
    }
}

