/*
 * Decompiled with CFR 0.152.
 */
package android.app.adservices;

import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.app.adservices.IAdServicesManager;
import android.app.adservices.consent.ConsentParcel;
import android.app.adservices.topics.TopicParcel;
import android.app.sdksandbox.SdkSandboxManager;
import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.os._Original_Build;
import com.android.adservices.LogUtil;
import com.android.internal.annotations.GuardedBy;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Objects;

@RequiresApi(value=31)
public class AdServicesManager {
    public static final String AD_SERVICES_SYSTEM_SERVICE = "adservices_manager";
    private static final Object SINGLETON_LOCK = new Object();
    @SuppressLint(value={"StaticFieldLeak"})
    @GuardedBy(value={"SINGLETON_LOCK"})
    private static Context sContext;
    @GuardedBy(value={"SINGLETON_LOCK"})
    private static AdServicesManager sSingleton;
    private final IAdServicesManager mService;
    public static final int MEASUREMENT_DELETION = 0;

    public AdServicesManager(IAdServicesManager service) {
        this.mService = Objects.requireNonNull(service, "IAdServicesManager cannot be null!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static AdServicesManager getInstance(Context context) {
        Objects.requireNonNull(context, "context cannot be null");
        Object object = SINGLETON_LOCK;
        synchronized (object) {
            if (sContext == null) {
                LogUtil.i("Setting AdServicesManager static context as %s", context);
                sContext = context;
            } else if (sContext != context) {
                throw new IllegalArgumentException("getInstance(" + context + "): context already set as " + sContext);
            }
            if (sSingleton == null && _Original_Build.VERSION.SDK_INT >= 33) {
                if (_Original_Build.VERSION.SDK_INT < 34) {
                    LogUtil.d("AdServicesManager.getInstance(): getting binder from SdkSandboxManager on TM");
                    IBinder iBinder = context.getSystemService(SdkSandboxManager.class).getAdServicesManager();
                    sSingleton = new AdServicesManager(IAdServicesManager.Stub.asInterface(iBinder));
                } else {
                    LogUtil.d("AdServicesManager.getInstance(): getting binder from AdServicesManager on UDC+");
                    sSingleton = context.getSystemService(AdServicesManager.class);
                }
                LogUtil.v("AdServicesManager.getInstance(): singleton set as %s", sSingleton);
            }
            return sSingleton;
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public ConsentParcel getConsent(int consentApiType) {
        try {
            return this.mService.getConsent(consentApiType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public ConsentParcel getConsentNullable(int consentApiType) {
        try {
            return this.mService.getConsentNullable(consentApiType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void setConsent(ConsentParcel consentParcel) {
        Objects.requireNonNull(consentParcel);
        try {
            this.mService.setConsent(consentParcel);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void recordNotificationDisplayed(boolean wasNotificationDisplayed) {
        try {
            this.mService.recordNotificationDisplayed(wasNotificationDisplayed);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public boolean wasNotificationDisplayed() {
        try {
            return this.mService.wasNotificationDisplayed();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void recordGaUxNotificationDisplayed(boolean wasNotificationDisplayed) {
        try {
            this.mService.recordGaUxNotificationDisplayed(wasNotificationDisplayed);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public int getUserManualInteractionWithConsent() {
        try {
            return this.mService.getUserManualInteractionWithConsent();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void recordUserManualInteractionWithConsent(int interaction) {
        try {
            this.mService.recordUserManualInteractionWithConsent(interaction);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public boolean wasGaUxNotificationDisplayed() {
        try {
            return this.mService.wasGaUxNotificationDisplayed();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public boolean wasPasNotificationDisplayed() {
        try {
            return this.mService.wasPasNotificationDisplayed();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void recordPasNotificationDisplayed(boolean wasNotificationDisplayed) {
        try {
            this.mService.recordPasNotificationDisplayed(wasNotificationDisplayed);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public boolean wasPasNotificationOpened() {
        try {
            return this.mService.wasPasNotificationOpened();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void recordPasNotificationOpened(boolean wasNotificationOpened) {
        try {
            this.mService.recordPasNotificationOpened(wasNotificationOpened);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void recordBlockedTopic(List<TopicParcel> blockedTopicParcels) {
        try {
            this.mService.recordBlockedTopic(blockedTopicParcels);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void removeBlockedTopic(TopicParcel blockedTopicParcel) {
        try {
            this.mService.removeBlockedTopic(blockedTopicParcel);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public List<TopicParcel> retrieveAllBlockedTopics() {
        try {
            return this.mService.retrieveAllBlockedTopics();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void clearAllBlockedTopics() {
        try {
            this.mService.clearAllBlockedTopics();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public List<String> getKnownAppsWithConsent(List<String> installedPackages) {
        try {
            return this.mService.getKnownAppsWithConsent(installedPackages);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public List<String> getAppsWithRevokedConsent(List<String> installedPackages) {
        try {
            return this.mService.getAppsWithRevokedConsent(installedPackages);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void setConsentForApp(String packageName, int packageUid, boolean isConsentRevoked) {
        try {
            this.mService.setConsentForApp(packageName, packageUid, isConsentRevoked);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void clearKnownAppsWithConsent() {
        try {
            this.mService.clearKnownAppsWithConsent();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void clearAllAppConsentData() {
        try {
            this.mService.clearAllAppConsentData();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public boolean isConsentRevokedForApp(String packageName, int packageUid) {
        try {
            return this.mService.isConsentRevokedForApp(packageName, packageUid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public boolean setConsentForAppIfNew(String packageName, int packageUid, boolean isConsentRevoked) {
        try {
            return this.mService.setConsentForAppIfNew(packageName, packageUid, isConsentRevoked);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void clearConsentForUninstalledApp(String packageName, int packageUid) {
        try {
            this.mService.clearConsentForUninstalledApp(packageName, packageUid);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void recordAdServicesDeletionOccurred(int deletionType) {
        try {
            this.mService.recordAdServicesDeletionOccurred(deletionType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void recordDefaultConsent(boolean defaultConsent) {
        try {
            this.mService.recordDefaultConsent(defaultConsent);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void recordTopicsDefaultConsent(boolean defaultConsent) {
        try {
            this.mService.recordTopicsDefaultConsent(defaultConsent);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void recordFledgeDefaultConsent(boolean defaultConsent) {
        try {
            this.mService.recordFledgeDefaultConsent(defaultConsent);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void recordMeasurementDefaultConsent(boolean defaultConsent) {
        try {
            this.mService.recordMeasurementDefaultConsent(defaultConsent);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void recordDefaultAdIdState(boolean defaultAdIdState) {
        try {
            this.mService.recordDefaultAdIdState(defaultAdIdState);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public boolean needsToHandleRollbackReconciliation(int deletionType) {
        try {
            return this.mService.needsToHandleRollbackReconciliation(deletionType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public boolean getDefaultConsent() {
        try {
            return this.mService.getDefaultConsent();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public boolean getTopicsDefaultConsent() {
        try {
            return this.mService.getTopicsDefaultConsent();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public boolean getFledgeDefaultConsent() {
        try {
            return this.mService.getFledgeDefaultConsent();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public boolean getMeasurementDefaultConsent() {
        try {
            return this.mService.getMeasurementDefaultConsent();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public boolean getDefaultAdIdState() {
        try {
            return this.mService.getDefaultAdIdState();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public String getCurrentPrivacySandboxFeature() {
        try {
            return this.mService.getCurrentPrivacySandboxFeature();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void setCurrentPrivacySandboxFeature(String featureType) {
        try {
            this.mService.setCurrentPrivacySandboxFeature(featureType);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public boolean isAdIdEnabled() {
        try {
            return this.mService.isAdIdEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void setAdIdEnabled(boolean isAdIdEnabled) {
        try {
            this.mService.setAdIdEnabled(isAdIdEnabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public boolean isU18Account() {
        try {
            return this.mService.isU18Account();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void setU18Account(boolean isU18Account) {
        try {
            this.mService.setU18Account(isU18Account);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public boolean isEntryPointEnabled() {
        try {
            return this.mService.isEntryPointEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void setEntryPointEnabled(boolean isEntryPointEnabled) {
        try {
            this.mService.setEntryPointEnabled(isEntryPointEnabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public boolean isAdultAccount() {
        try {
            return this.mService.isAdultAccount();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void setAdultAccount(boolean isAdultAccount) {
        try {
            this.mService.setAdultAccount(isAdultAccount);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public boolean wasU18NotificationDisplayed() {
        try {
            return this.mService.wasU18NotificationDisplayed();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void setU18NotificationDisplayed(boolean wasU18NotificationDisplayed) {
        try {
            this.mService.setU18NotificationDisplayed(wasU18NotificationDisplayed);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public String getUx() {
        try {
            return this.mService.getUx();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void setUx(String ux) {
        try {
            this.mService.setUx(ux);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public String getEnrollmentChannel() {
        try {
            return this.mService.getEnrollmentChannel();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void setEnrollmentChannel(String enrollmentChannel) {
        try {
            this.mService.setEnrollmentChannel(enrollmentChannel);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public boolean isMeasurementDataReset() {
        try {
            return this.mService.isMeasurementDataReset();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void setMeasurementDataReset(boolean isMeasurementDataReset) {
        try {
            this.mService.setMeasurementDataReset(isMeasurementDataReset);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public boolean isPaDataReset() {
        try {
            return this.mService.isPaDataReset();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void setPaDataReset(boolean isPaDataReset) {
        try {
            this.mService.setPaDataReset(isPaDataReset);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public String getModuleEnrollmentState() {
        try {
            return this.mService.getModuleEnrollmentState();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_MANAGER")
    public void setModuleEnrollmentState(String enrollmentState) {
        try {
            this.mService.setModuleEnrollmentState(enrollmentState);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.DUMP")
    public static void dump(PrintWriter pw) {
        Objects.requireNonNull(pw, "PrintWriter cannot be null");
        pw.printf("AdServicesManager: ", new Object[0]);
        Object object = SINGLETON_LOCK;
        synchronized (object) {
            pw.printf("sContext=%s, sSingleton=%s", sContext, sSingleton);
            if (sSingleton != null) {
                pw.printf(" (service=%s)", AdServicesManager.sSingleton.mService);
            }
            pw.println();
            return;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeletionApiType {
    }
}

