/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.admin.NoArgsPolicyKey;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.IOException;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParserException;

@SystemApi
@SuppressLint(value={"ParcelNotFinal", "ParcelCreator"})
public abstract class PolicyKey
implements Parcelable {
    static final String TAG = "PolicyKey";
    static final String ATTR_POLICY_IDENTIFIER = "policy-identifier";
    private final String mIdentifier;

    protected PolicyKey(@NonNull String identifier) {
        this.mIdentifier = Objects.requireNonNull(identifier);
    }

    @NonNull
    public String getIdentifier() {
        return this.mIdentifier;
    }

    public boolean hasSameIdentifierAs(PolicyKey other) {
        if (other == null) {
            return false;
        }
        return this.mIdentifier.equals(other.mIdentifier);
    }

    @Nullable
    public static PolicyKey readGenericPolicyKeyFromXml(TypedXmlPullParser parser) {
        String identifier = parser.getAttributeValue(null, ATTR_POLICY_IDENTIFIER);
        if (identifier == null) {
            Log.wtf(TAG, "Error parsing generic policy key, identifier is null.");
            return null;
        }
        return new NoArgsPolicyKey(identifier);
    }

    public void saveToXml(TypedXmlSerializer serializer) throws IOException {
        serializer.attribute(null, ATTR_POLICY_IDENTIFIER, this.mIdentifier);
    }

    public PolicyKey readFromXml(TypedXmlPullParser parser) throws XmlPullParserException, IOException {
        return this;
    }

    public abstract void writeToBundle(Bundle var1);

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyKey other = (PolicyKey)o;
        return Objects.equals(this.mIdentifier, other.mIdentifier);
    }

    public int hashCode() {
        return Objects.hash(this.mIdentifier);
    }
}

