/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.RequiresPermission;
import android.app.ActivityManager;
import android.app.IRequestFinishCallback;
import android.app.PictureInPictureParams;
import android.content.ComponentName;
import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IRemoteCallback;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.RemoteAnimationDefinition;
import android.window.SizeConfigurationBuckets;
import com.android.internal.policy.IKeyguardDismissCallback;

public interface IActivityClientController
extends IInterface {
    public static final String DESCRIPTOR = "android.app.IActivityClientController";

    public void activityIdle(IBinder var1, Configuration var2, boolean var3) throws RemoteException;

    public void activityResumed(IBinder var1, boolean var2) throws RemoteException;

    public void activityRefreshed(IBinder var1) throws RemoteException;

    public void activityTopResumedStateLost() throws RemoteException;

    public void activityPaused(IBinder var1) throws RemoteException;

    public void activityStopped(IBinder var1, Bundle var2, PersistableBundle var3, CharSequence var4) throws RemoteException;

    public void activityDestroyed(IBinder var1) throws RemoteException;

    public void activityLocalRelaunch(IBinder var1) throws RemoteException;

    public void activityRelaunched(IBinder var1) throws RemoteException;

    public void reportSizeConfigurations(IBinder var1, SizeConfigurationBuckets var2) throws RemoteException;

    public boolean moveActivityTaskToBack(IBinder var1, boolean var2) throws RemoteException;

    public boolean shouldUpRecreateTask(IBinder var1, String var2) throws RemoteException;

    public boolean navigateUpTo(IBinder var1, Intent var2, String var3, int var4, Intent var5) throws RemoteException;

    public boolean releaseActivityInstance(IBinder var1) throws RemoteException;

    public boolean finishActivity(IBinder var1, int var2, Intent var3, int var4) throws RemoteException;

    public boolean finishActivityAffinity(IBinder var1) throws RemoteException;

    public void finishSubActivity(IBinder var1, String var2, int var3) throws RemoteException;

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    public void setForceSendResultForMediaProjection(IBinder var1) throws RemoteException;

    public boolean isTopOfTask(IBinder var1) throws RemoteException;

    public boolean willActivityBeVisible(IBinder var1) throws RemoteException;

    public int getDisplayId(IBinder var1) throws RemoteException;

    public int getTaskForActivity(IBinder var1, boolean var2) throws RemoteException;

    public Configuration getTaskConfiguration(IBinder var1) throws RemoteException;

    public IBinder getActivityTokenBelow(IBinder var1) throws RemoteException;

    public ComponentName getCallingActivity(IBinder var1) throws RemoteException;

    public String getCallingPackage(IBinder var1) throws RemoteException;

    public int getLaunchedFromUid(IBinder var1) throws RemoteException;

    public int getActivityCallerUid(IBinder var1, IBinder var2) throws RemoteException;

    public String getLaunchedFromPackage(IBinder var1) throws RemoteException;

    public String getActivityCallerPackage(IBinder var1, IBinder var2) throws RemoteException;

    public int checkActivityCallerContentUriPermission(IBinder var1, IBinder var2, Uri var3, int var4, int var5) throws RemoteException;

    public void setRequestedOrientation(IBinder var1, int var2) throws RemoteException;

    public int getRequestedOrientation(IBinder var1) throws RemoteException;

    public boolean convertFromTranslucent(IBinder var1) throws RemoteException;

    public boolean convertToTranslucent(IBinder var1, Bundle var2) throws RemoteException;

    public boolean isImmersive(IBinder var1) throws RemoteException;

    public void setImmersive(IBinder var1, boolean var2) throws RemoteException;

    public boolean isHandoffEnabled(IBinder var1) throws RemoteException;

    public boolean isHandoffFullTaskRecreationAllowed(IBinder var1) throws RemoteException;

    public void setHandoffEnabled(IBinder var1, boolean var2, boolean var3) throws RemoteException;

    public boolean enterPictureInPictureMode(IBinder var1, PictureInPictureParams var2) throws RemoteException;

    public void setPictureInPictureParams(IBinder var1, PictureInPictureParams var2) throws RemoteException;

    public void setShouldDockBigOverlays(IBinder var1, boolean var2) throws RemoteException;

    public void toggleFreeformWindowingMode(IBinder var1) throws RemoteException;

    public void requestMultiwindowFullscreen(IBinder var1, int var2, IRemoteCallback var3) throws RemoteException;

    public void startLockTaskModeByToken(IBinder var1) throws RemoteException;

    public void stopLockTaskModeByToken(IBinder var1) throws RemoteException;

    public void showLockTaskEscapeMessage(IBinder var1) throws RemoteException;

    public void setTaskDescription(IBinder var1, ActivityManager.TaskDescription var2) throws RemoteException;

    public boolean showAssistFromActivity(IBinder var1, Bundle var2) throws RemoteException;

    public boolean isRootVoiceInteraction(IBinder var1) throws RemoteException;

    public void startLocalVoiceInteraction(IBinder var1, Bundle var2) throws RemoteException;

    public void stopLocalVoiceInteraction(IBinder var1) throws RemoteException;

    public void setShowWhenLocked(IBinder var1, boolean var2) throws RemoteException;

    public void setInheritShowWhenLocked(IBinder var1, boolean var2) throws RemoteException;

    public void setTurnScreenOn(IBinder var1, boolean var2) throws RemoteException;

    public void setAllowCrossUidActivitySwitchFromBelow(IBinder var1, boolean var2) throws RemoteException;

    public void reportActivityFullyDrawn(IBinder var1, boolean var2) throws RemoteException;

    public void overrideActivityTransition(IBinder var1, boolean var2, int var3, int var4, int var5) throws RemoteException;

    public void clearOverrideActivityTransition(IBinder var1, boolean var2) throws RemoteException;

    public void overridePendingTransition(IBinder var1, String var2, int var3, int var4, int var5) throws RemoteException;

    public int setVrMode(IBinder var1, boolean var2, ComponentName var3) throws RemoteException;

    public void setRecentsScreenshotEnabled(IBinder var1, boolean var2) throws RemoteException;

    public void invalidateHomeTaskSnapshot(IBinder var1) throws RemoteException;

    public void dismissKeyguard(IBinder var1, IKeyguardDismissCallback var2, CharSequence var3) throws RemoteException;

    public void registerRemoteAnimations(IBinder var1, RemoteAnimationDefinition var2) throws RemoteException;

    public void unregisterRemoteAnimations(IBinder var1) throws RemoteException;

    public void onBackPressed(IBinder var1, IRequestFinishCallback var2) throws RemoteException;

    public void splashScreenAttached(IBinder var1) throws RemoteException;

    public void enableTaskLocaleOverride(IBinder var1) throws RemoteException;

    public boolean isRequestedToLaunchInTaskFragment(IBinder var1, IBinder var2) throws RemoteException;

    @RequiresPermission(value="android.permission.INTERNAL_SYSTEM_WINDOW")
    public void setActivityRecordInputSinkEnabled(IBinder var1, boolean var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IActivityClientController {
        static final int TRANSACTION_activityIdle = 1;
        static final int TRANSACTION_activityResumed = 2;
        static final int TRANSACTION_activityRefreshed = 3;
        static final int TRANSACTION_activityTopResumedStateLost = 4;
        static final int TRANSACTION_activityPaused = 5;
        static final int TRANSACTION_activityStopped = 6;
        static final int TRANSACTION_activityDestroyed = 7;
        static final int TRANSACTION_activityLocalRelaunch = 8;
        static final int TRANSACTION_activityRelaunched = 9;
        static final int TRANSACTION_reportSizeConfigurations = 10;
        static final int TRANSACTION_moveActivityTaskToBack = 11;
        static final int TRANSACTION_shouldUpRecreateTask = 12;
        static final int TRANSACTION_navigateUpTo = 13;
        static final int TRANSACTION_releaseActivityInstance = 14;
        static final int TRANSACTION_finishActivity = 15;
        static final int TRANSACTION_finishActivityAffinity = 16;
        static final int TRANSACTION_finishSubActivity = 17;
        static final int TRANSACTION_setForceSendResultForMediaProjection = 18;
        static final int TRANSACTION_isTopOfTask = 19;
        static final int TRANSACTION_willActivityBeVisible = 20;
        static final int TRANSACTION_getDisplayId = 21;
        static final int TRANSACTION_getTaskForActivity = 22;
        static final int TRANSACTION_getTaskConfiguration = 23;
        static final int TRANSACTION_getActivityTokenBelow = 24;
        static final int TRANSACTION_getCallingActivity = 25;
        static final int TRANSACTION_getCallingPackage = 26;
        static final int TRANSACTION_getLaunchedFromUid = 27;
        static final int TRANSACTION_getActivityCallerUid = 28;
        static final int TRANSACTION_getLaunchedFromPackage = 29;
        static final int TRANSACTION_getActivityCallerPackage = 30;
        static final int TRANSACTION_checkActivityCallerContentUriPermission = 31;
        static final int TRANSACTION_setRequestedOrientation = 32;
        static final int TRANSACTION_getRequestedOrientation = 33;
        static final int TRANSACTION_convertFromTranslucent = 34;
        static final int TRANSACTION_convertToTranslucent = 35;
        static final int TRANSACTION_isImmersive = 36;
        static final int TRANSACTION_setImmersive = 37;
        static final int TRANSACTION_isHandoffEnabled = 38;
        static final int TRANSACTION_isHandoffFullTaskRecreationAllowed = 39;
        static final int TRANSACTION_setHandoffEnabled = 40;
        static final int TRANSACTION_enterPictureInPictureMode = 41;
        static final int TRANSACTION_setPictureInPictureParams = 42;
        static final int TRANSACTION_setShouldDockBigOverlays = 43;
        static final int TRANSACTION_toggleFreeformWindowingMode = 44;
        static final int TRANSACTION_requestMultiwindowFullscreen = 45;
        static final int TRANSACTION_startLockTaskModeByToken = 46;
        static final int TRANSACTION_stopLockTaskModeByToken = 47;
        static final int TRANSACTION_showLockTaskEscapeMessage = 48;
        static final int TRANSACTION_setTaskDescription = 49;
        static final int TRANSACTION_showAssistFromActivity = 50;
        static final int TRANSACTION_isRootVoiceInteraction = 51;
        static final int TRANSACTION_startLocalVoiceInteraction = 52;
        static final int TRANSACTION_stopLocalVoiceInteraction = 53;
        static final int TRANSACTION_setShowWhenLocked = 54;
        static final int TRANSACTION_setInheritShowWhenLocked = 55;
        static final int TRANSACTION_setTurnScreenOn = 56;
        static final int TRANSACTION_setAllowCrossUidActivitySwitchFromBelow = 57;
        static final int TRANSACTION_reportActivityFullyDrawn = 58;
        static final int TRANSACTION_overrideActivityTransition = 59;
        static final int TRANSACTION_clearOverrideActivityTransition = 60;
        static final int TRANSACTION_overridePendingTransition = 61;
        static final int TRANSACTION_setVrMode = 62;
        static final int TRANSACTION_setRecentsScreenshotEnabled = 63;
        static final int TRANSACTION_invalidateHomeTaskSnapshot = 64;
        static final int TRANSACTION_dismissKeyguard = 65;
        static final int TRANSACTION_registerRemoteAnimations = 66;
        static final int TRANSACTION_unregisterRemoteAnimations = 67;
        static final int TRANSACTION_onBackPressed = 68;
        static final int TRANSACTION_splashScreenAttached = 69;
        static final int TRANSACTION_enableTaskLocaleOverride = 70;
        static final int TRANSACTION_isRequestedToLaunchInTaskFragment = 71;
        static final int TRANSACTION_setActivityRecordInputSinkEnabled = 72;

        public Stub() {
            this.attachInterface(this, IActivityClientController.DESCRIPTOR);
        }

        public static IActivityClientController asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IActivityClientController.DESCRIPTOR);
            if (iin != null && iin instanceof IActivityClientController) {
                return (IActivityClientController)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "activityIdle";
                }
                case 2: {
                    return "activityResumed";
                }
                case 3: {
                    return "activityRefreshed";
                }
                case 4: {
                    return "activityTopResumedStateLost";
                }
                case 5: {
                    return "activityPaused";
                }
                case 6: {
                    return "activityStopped";
                }
                case 7: {
                    return "activityDestroyed";
                }
                case 8: {
                    return "activityLocalRelaunch";
                }
                case 9: {
                    return "activityRelaunched";
                }
                case 10: {
                    return "reportSizeConfigurations";
                }
                case 11: {
                    return "moveActivityTaskToBack";
                }
                case 12: {
                    return "shouldUpRecreateTask";
                }
                case 13: {
                    return "navigateUpTo";
                }
                case 14: {
                    return "releaseActivityInstance";
                }
                case 15: {
                    return "finishActivity";
                }
                case 16: {
                    return "finishActivityAffinity";
                }
                case 17: {
                    return "finishSubActivity";
                }
                case 18: {
                    return "setForceSendResultForMediaProjection";
                }
                case 19: {
                    return "isTopOfTask";
                }
                case 20: {
                    return "willActivityBeVisible";
                }
                case 21: {
                    return "getDisplayId";
                }
                case 22: {
                    return "getTaskForActivity";
                }
                case 23: {
                    return "getTaskConfiguration";
                }
                case 24: {
                    return "getActivityTokenBelow";
                }
                case 25: {
                    return "getCallingActivity";
                }
                case 26: {
                    return "getCallingPackage";
                }
                case 27: {
                    return "getLaunchedFromUid";
                }
                case 28: {
                    return "getActivityCallerUid";
                }
                case 29: {
                    return "getLaunchedFromPackage";
                }
                case 30: {
                    return "getActivityCallerPackage";
                }
                case 31: {
                    return "checkActivityCallerContentUriPermission";
                }
                case 32: {
                    return "setRequestedOrientation";
                }
                case 33: {
                    return "getRequestedOrientation";
                }
                case 34: {
                    return "convertFromTranslucent";
                }
                case 35: {
                    return "convertToTranslucent";
                }
                case 36: {
                    return "isImmersive";
                }
                case 37: {
                    return "setImmersive";
                }
                case 38: {
                    return "isHandoffEnabled";
                }
                case 39: {
                    return "isHandoffFullTaskRecreationAllowed";
                }
                case 40: {
                    return "setHandoffEnabled";
                }
                case 41: {
                    return "enterPictureInPictureMode";
                }
                case 42: {
                    return "setPictureInPictureParams";
                }
                case 43: {
                    return "setShouldDockBigOverlays";
                }
                case 44: {
                    return "toggleFreeformWindowingMode";
                }
                case 45: {
                    return "requestMultiwindowFullscreen";
                }
                case 46: {
                    return "startLockTaskModeByToken";
                }
                case 47: {
                    return "stopLockTaskModeByToken";
                }
                case 48: {
                    return "showLockTaskEscapeMessage";
                }
                case 49: {
                    return "setTaskDescription";
                }
                case 50: {
                    return "showAssistFromActivity";
                }
                case 51: {
                    return "isRootVoiceInteraction";
                }
                case 52: {
                    return "startLocalVoiceInteraction";
                }
                case 53: {
                    return "stopLocalVoiceInteraction";
                }
                case 54: {
                    return "setShowWhenLocked";
                }
                case 55: {
                    return "setInheritShowWhenLocked";
                }
                case 56: {
                    return "setTurnScreenOn";
                }
                case 57: {
                    return "setAllowCrossUidActivitySwitchFromBelow";
                }
                case 58: {
                    return "reportActivityFullyDrawn";
                }
                case 59: {
                    return "overrideActivityTransition";
                }
                case 60: {
                    return "clearOverrideActivityTransition";
                }
                case 61: {
                    return "overridePendingTransition";
                }
                case 62: {
                    return "setVrMode";
                }
                case 63: {
                    return "setRecentsScreenshotEnabled";
                }
                case 64: {
                    return "invalidateHomeTaskSnapshot";
                }
                case 65: {
                    return "dismissKeyguard";
                }
                case 66: {
                    return "registerRemoteAnimations";
                }
                case 67: {
                    return "unregisterRemoteAnimations";
                }
                case 68: {
                    return "onBackPressed";
                }
                case 69: {
                    return "splashScreenAttached";
                }
                case 70: {
                    return "enableTaskLocaleOverride";
                }
                case 71: {
                    return "isRequestedToLaunchInTaskFragment";
                }
                case 72: {
                    return "setActivityRecordInputSinkEnabled";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IActivityClientController.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IBinder _arg0 = data.readStrongBinder();
                    Configuration _arg1 = data.readTypedObject(Configuration.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.activityIdle(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.activityResumed(_arg0, _arg1);
                    break;
                }
                case 3: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.activityRefreshed(_arg0);
                    break;
                }
                case 4: {
                    this.activityTopResumedStateLost();
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.activityPaused(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    IBinder _arg0 = data.readStrongBinder();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    PersistableBundle _arg2 = data.readTypedObject(PersistableBundle.CREATOR);
                    CharSequence _arg3 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    data.enforceNoDataAvail();
                    this.activityStopped(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 7: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.activityDestroyed(_arg0);
                    break;
                }
                case 8: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.activityLocalRelaunch(_arg0);
                    break;
                }
                case 9: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.activityRelaunched(_arg0);
                    break;
                }
                case 10: {
                    IBinder _arg0 = data.readStrongBinder();
                    SizeConfigurationBuckets _arg1 = data.readTypedObject(SizeConfigurationBuckets.CREATOR);
                    data.enforceNoDataAvail();
                    this.reportSizeConfigurations(_arg0, _arg1);
                    break;
                }
                case 11: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    boolean _result = this.moveActivityTaskToBack(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.shouldUpRecreateTask(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 13: {
                    IBinder _arg0 = data.readStrongBinder();
                    Intent _arg1 = data.readTypedObject(Intent.CREATOR);
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    Intent _arg4 = data.readTypedObject(Intent.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.navigateUpTo(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 14: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.releaseActivityInstance(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 15: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    Intent _arg2 = data.readTypedObject(Intent.CREATOR);
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.finishActivity(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 16: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.finishActivityAffinity(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 17: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.finishSubActivity(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.setForceSendResultForMediaProjection(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.isTopOfTask(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 20: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.willActivityBeVisible(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 21: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    int _result = this.getDisplayId(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 22: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    int _result = this.getTaskForActivity(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 23: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    Configuration _result = this.getTaskConfiguration(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 24: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    IBinder _result = this.getActivityTokenBelow(_arg0);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result);
                    break;
                }
                case 25: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    ComponentName _result = this.getCallingActivity(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 26: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    String _result = this.getCallingPackage(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 27: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    int _result = this.getLaunchedFromUid(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 28: {
                    IBinder _arg0 = data.readStrongBinder();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    int _result = this.getActivityCallerUid(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 29: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    String _result = this.getLaunchedFromPackage(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 30: {
                    IBinder _arg0 = data.readStrongBinder();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    String _result = this.getActivityCallerPackage(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    break;
                }
                case 31: {
                    IBinder _arg0 = data.readStrongBinder();
                    IBinder _arg1 = data.readStrongBinder();
                    Uri _arg2 = data.readTypedObject(Uri.CREATOR);
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.checkActivityCallerContentUriPermission(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 32: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setRequestedOrientation(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 33: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    int _result = this.getRequestedOrientation(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 34: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.convertFromTranslucent(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 35: {
                    IBinder _arg0 = data.readStrongBinder();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.convertToTranslucent(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 36: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.isImmersive(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 37: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setImmersive(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.isHandoffEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 39: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.isHandoffFullTaskRecreationAllowed(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 40: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setHandoffEnabled(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    IBinder _arg0 = data.readStrongBinder();
                    PictureInPictureParams _arg1 = data.readTypedObject(PictureInPictureParams.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.enterPictureInPictureMode(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 42: {
                    IBinder _arg0 = data.readStrongBinder();
                    PictureInPictureParams _arg1 = data.readTypedObject(PictureInPictureParams.CREATOR);
                    data.enforceNoDataAvail();
                    this.setPictureInPictureParams(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 43: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setShouldDockBigOverlays(_arg0, _arg1);
                    break;
                }
                case 44: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.toggleFreeformWindowingMode(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    IRemoteCallback _arg2 = IRemoteCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.requestMultiwindowFullscreen(_arg0, _arg1, _arg2);
                    break;
                }
                case 46: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.startLockTaskModeByToken(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 47: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.stopLockTaskModeByToken(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 48: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.showLockTaskEscapeMessage(_arg0);
                    break;
                }
                case 49: {
                    IBinder _arg0 = data.readStrongBinder();
                    ActivityManager.TaskDescription _arg1 = data.readTypedObject(ActivityManager.TaskDescription.CREATOR);
                    data.enforceNoDataAvail();
                    this.setTaskDescription(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 50: {
                    IBinder _arg0 = data.readStrongBinder();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.showAssistFromActivity(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 51: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.isRootVoiceInteraction(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 52: {
                    IBinder _arg0 = data.readStrongBinder();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.startLocalVoiceInteraction(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 53: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.stopLocalVoiceInteraction(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 54: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setShowWhenLocked(_arg0, _arg1);
                    break;
                }
                case 55: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setInheritShowWhenLocked(_arg0, _arg1);
                    break;
                }
                case 56: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setTurnScreenOn(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 57: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setAllowCrossUidActivitySwitchFromBelow(_arg0, _arg1);
                    break;
                }
                case 58: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.reportActivityFullyDrawn(_arg0, _arg1);
                    break;
                }
                case 59: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.overrideActivityTransition(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 60: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.clearOverrideActivityTransition(_arg0, _arg1);
                    break;
                }
                case 61: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    this.overridePendingTransition(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 62: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    ComponentName _arg2 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.setVrMode(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 63: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setRecentsScreenshotEnabled(_arg0, _arg1);
                    break;
                }
                case 64: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.invalidateHomeTaskSnapshot(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 65: {
                    IBinder _arg0 = data.readStrongBinder();
                    IKeyguardDismissCallback _arg1 = IKeyguardDismissCallback.Stub.asInterface(data.readStrongBinder());
                    CharSequence _arg2 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    data.enforceNoDataAvail();
                    this.dismissKeyguard(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 66: {
                    IBinder _arg0 = data.readStrongBinder();
                    RemoteAnimationDefinition _arg1 = data.readTypedObject(RemoteAnimationDefinition.CREATOR);
                    data.enforceNoDataAvail();
                    this.registerRemoteAnimations(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 67: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.unregisterRemoteAnimations(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 68: {
                    IBinder _arg0 = data.readStrongBinder();
                    IRequestFinishCallback _arg1 = IRequestFinishCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onBackPressed(_arg0, _arg1);
                    break;
                }
                case 69: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.splashScreenAttached(_arg0);
                    break;
                }
                case 70: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.enableTaskLocaleOverride(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 71: {
                    IBinder _arg0 = data.readStrongBinder();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.isRequestedToLaunchInTaskFragment(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 72: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setActivityRecordInputSinkEnabled(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 71;
        }

        private static class Proxy
        implements IActivityClientController {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IActivityClientController.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void activityIdle(IBinder token, Configuration config, boolean stopProfiling) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(config, 0);
                    _data.writeBoolean(stopProfiling);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void activityResumed(IBinder token, boolean handleSplashScreenExit) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeBoolean(handleSplashScreenExit);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void activityRefreshed(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void activityTopResumedStateLost() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void activityPaused(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void activityStopped(IBinder token, Bundle state, PersistableBundle persistentState, CharSequence description) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(state, 0);
                    _data.writeTypedObject(persistentState, 0);
                    if (description != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(description, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void activityDestroyed(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void activityLocalRelaunch(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void activityRelaunched(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportSizeConfigurations(IBinder token, SizeConfigurationBuckets sizeConfigurations) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(sizeConfigurations, 0);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean moveActivityTaskToBack(IBinder token, boolean nonRoot) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeBoolean(nonRoot);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldUpRecreateTask(IBinder token, String destAffinity) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(destAffinity);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean navigateUpTo(IBinder token, Intent target, String resolvedType, int resultCode, Intent resultData) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(target, 0);
                    _data.writeString(resolvedType);
                    _data.writeInt(resultCode);
                    _data.writeTypedObject(resultData, 0);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean releaseActivityInstance(IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean finishActivity(IBinder token, int code, Intent data, int finishTask) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(code);
                    _data.writeTypedObject(data, 0);
                    _data.writeInt(finishTask);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean finishActivityAffinity(IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishSubActivity(IBinder token, String resultWho, int requestCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(resultWho);
                    _data.writeInt(requestCode);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setForceSendResultForMediaProjection(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTopOfTask(IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean willActivityBeVisible(IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDisplayId(IBinder activityToken) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(activityToken);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getTaskForActivity(IBinder token, boolean onlyRoot) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeBoolean(onlyRoot);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Configuration getTaskConfiguration(IBinder activityToken) throws RemoteException {
                Configuration _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(activityToken);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Configuration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IBinder getActivityTokenBelow(IBinder token) throws RemoteException {
                IBinder _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readStrongBinder();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ComponentName getCallingActivity(IBinder token) throws RemoteException {
                ComponentName _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ComponentName.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getCallingPackage(IBinder token) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getLaunchedFromUid(IBinder token) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getActivityCallerUid(IBinder activityToken, IBinder callerToken) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(activityToken);
                    _data.writeStrongBinder(callerToken);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getLaunchedFromPackage(IBinder token) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getActivityCallerPackage(IBinder activityToken, IBinder callerToken) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(activityToken);
                    _data.writeStrongBinder(callerToken);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int checkActivityCallerContentUriPermission(IBinder activityToken, IBinder callerToken, Uri uri, int modeFlags, int userId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(activityToken);
                    _data.writeStrongBinder(callerToken);
                    _data.writeTypedObject(uri, 0);
                    _data.writeInt(modeFlags);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRequestedOrientation(IBinder token, int requestedOrientation) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(requestedOrientation);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRequestedOrientation(IBinder token) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean convertFromTranslucent(IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean convertToTranslucent(IBinder token, Bundle options) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isImmersive(IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setImmersive(IBinder token, boolean immersive) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeBoolean(immersive);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHandoffEnabled(IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHandoffFullTaskRecreationAllowed(IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHandoffEnabled(IBinder token, boolean handoffEnabled, boolean allowFullTaskRecreation) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeBoolean(handoffEnabled);
                    _data.writeBoolean(allowFullTaskRecreation);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enterPictureInPictureMode(IBinder token, PictureInPictureParams params) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(params, 0);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPictureInPictureParams(IBinder token, PictureInPictureParams params) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(params, 0);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShouldDockBigOverlays(IBinder token, boolean shouldDockBigOverlays) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeBoolean(shouldDockBigOverlays);
                    boolean bl = this.mRemote.transact(43, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void toggleFreeformWindowingMode(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestMultiwindowFullscreen(IBinder token, int request, IRemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(request);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(45, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startLockTaskModeByToken(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopLockTaskModeByToken(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showLockTaskEscapeMessage(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean bl = this.mRemote.transact(48, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTaskDescription(IBinder token, ActivityManager.TaskDescription values) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(values, 0);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean showAssistFromActivity(IBinder token, Bundle args) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(args, 0);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRootVoiceInteraction(IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startLocalVoiceInteraction(IBinder token, Bundle options) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopLocalVoiceInteraction(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShowWhenLocked(IBinder token, boolean showWhenLocked) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeBoolean(showWhenLocked);
                    boolean bl = this.mRemote.transact(54, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInheritShowWhenLocked(IBinder token, boolean setInheritShownWhenLocked) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeBoolean(setInheritShownWhenLocked);
                    boolean bl = this.mRemote.transact(55, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTurnScreenOn(IBinder token, boolean turnScreenOn) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeBoolean(turnScreenOn);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAllowCrossUidActivitySwitchFromBelow(IBinder token, boolean allowed) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeBoolean(allowed);
                    boolean bl = this.mRemote.transact(57, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportActivityFullyDrawn(IBinder token, boolean restoredFromBundle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeBoolean(restoredFromBundle);
                    boolean bl = this.mRemote.transact(58, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void overrideActivityTransition(IBinder token, boolean open, int enterAnim, int exitAnim, int backgroundColor) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeBoolean(open);
                    _data.writeInt(enterAnim);
                    _data.writeInt(exitAnim);
                    _data.writeInt(backgroundColor);
                    boolean bl = this.mRemote.transact(59, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearOverrideActivityTransition(IBinder token, boolean open) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeBoolean(open);
                    boolean bl = this.mRemote.transact(60, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void overridePendingTransition(IBinder token, String packageName, int enterAnim, int exitAnim, int backgroundColor) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(packageName);
                    _data.writeInt(enterAnim);
                    _data.writeInt(exitAnim);
                    _data.writeInt(backgroundColor);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setVrMode(IBinder token, boolean enabled, ComponentName packageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeBoolean(enabled);
                    _data.writeTypedObject(packageName, 0);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRecentsScreenshotEnabled(IBinder token, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(63, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invalidateHomeTaskSnapshot(IBinder homeToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(homeToken);
                    boolean _status = this.mRemote.transact(64, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dismissKeyguard(IBinder token, IKeyguardDismissCallback callback, CharSequence message) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeStrongInterface(callback);
                    if (message != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(message, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(65, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerRemoteAnimations(IBinder token, RemoteAnimationDefinition definition) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeTypedObject(definition, 0);
                    boolean _status = this.mRemote.transact(66, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterRemoteAnimations(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(67, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBackPressed(IBinder activityToken, IRequestFinishCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(activityToken);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(68, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void splashScreenAttached(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean bl = this.mRemote.transact(69, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableTaskLocaleOverride(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(70, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRequestedToLaunchInTaskFragment(IBinder activityToken, IBinder taskFragmentToken) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(activityToken);
                    _data.writeStrongBinder(taskFragmentToken);
                    boolean _status = this.mRemote.transact(71, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setActivityRecordInputSinkEnabled(IBinder activityToken, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IActivityClientController.DESCRIPTOR);
                    _data.writeStrongBinder(activityToken);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(72, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IActivityClientController {
        @Override
        public void activityIdle(IBinder token, Configuration config, boolean stopProfiling) throws RemoteException {
        }

        @Override
        public void activityResumed(IBinder token, boolean handleSplashScreenExit) throws RemoteException {
        }

        @Override
        public void activityRefreshed(IBinder token) throws RemoteException {
        }

        @Override
        public void activityTopResumedStateLost() throws RemoteException {
        }

        @Override
        public void activityPaused(IBinder token) throws RemoteException {
        }

        @Override
        public void activityStopped(IBinder token, Bundle state, PersistableBundle persistentState, CharSequence description) throws RemoteException {
        }

        @Override
        public void activityDestroyed(IBinder token) throws RemoteException {
        }

        @Override
        public void activityLocalRelaunch(IBinder token) throws RemoteException {
        }

        @Override
        public void activityRelaunched(IBinder token) throws RemoteException {
        }

        @Override
        public void reportSizeConfigurations(IBinder token, SizeConfigurationBuckets sizeConfigurations) throws RemoteException {
        }

        @Override
        public boolean moveActivityTaskToBack(IBinder token, boolean nonRoot) throws RemoteException {
            return false;
        }

        @Override
        public boolean shouldUpRecreateTask(IBinder token, String destAffinity) throws RemoteException {
            return false;
        }

        @Override
        public boolean navigateUpTo(IBinder token, Intent target, String resolvedType, int resultCode, Intent resultData) throws RemoteException {
            return false;
        }

        @Override
        public boolean releaseActivityInstance(IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public boolean finishActivity(IBinder token, int code, Intent data, int finishTask) throws RemoteException {
            return false;
        }

        @Override
        public boolean finishActivityAffinity(IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public void finishSubActivity(IBinder token, String resultWho, int requestCode) throws RemoteException {
        }

        @Override
        public void setForceSendResultForMediaProjection(IBinder token) throws RemoteException {
        }

        @Override
        public boolean isTopOfTask(IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public boolean willActivityBeVisible(IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public int getDisplayId(IBinder activityToken) throws RemoteException {
            return 0;
        }

        @Override
        public int getTaskForActivity(IBinder token, boolean onlyRoot) throws RemoteException {
            return 0;
        }

        @Override
        public Configuration getTaskConfiguration(IBinder activityToken) throws RemoteException {
            return null;
        }

        @Override
        public IBinder getActivityTokenBelow(IBinder token) throws RemoteException {
            return null;
        }

        @Override
        public ComponentName getCallingActivity(IBinder token) throws RemoteException {
            return null;
        }

        @Override
        public String getCallingPackage(IBinder token) throws RemoteException {
            return null;
        }

        @Override
        public int getLaunchedFromUid(IBinder token) throws RemoteException {
            return 0;
        }

        @Override
        public int getActivityCallerUid(IBinder activityToken, IBinder callerToken) throws RemoteException {
            return 0;
        }

        @Override
        public String getLaunchedFromPackage(IBinder token) throws RemoteException {
            return null;
        }

        @Override
        public String getActivityCallerPackage(IBinder activityToken, IBinder callerToken) throws RemoteException {
            return null;
        }

        @Override
        public int checkActivityCallerContentUriPermission(IBinder activityToken, IBinder callerToken, Uri uri, int modeFlags, int userId) throws RemoteException {
            return 0;
        }

        @Override
        public void setRequestedOrientation(IBinder token, int requestedOrientation) throws RemoteException {
        }

        @Override
        public int getRequestedOrientation(IBinder token) throws RemoteException {
            return 0;
        }

        @Override
        public boolean convertFromTranslucent(IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public boolean convertToTranslucent(IBinder token, Bundle options) throws RemoteException {
            return false;
        }

        @Override
        public boolean isImmersive(IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public void setImmersive(IBinder token, boolean immersive) throws RemoteException {
        }

        @Override
        public boolean isHandoffEnabled(IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public boolean isHandoffFullTaskRecreationAllowed(IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public void setHandoffEnabled(IBinder token, boolean handoffEnabled, boolean allowFullTaskRecreation) throws RemoteException {
        }

        @Override
        public boolean enterPictureInPictureMode(IBinder token, PictureInPictureParams params) throws RemoteException {
            return false;
        }

        @Override
        public void setPictureInPictureParams(IBinder token, PictureInPictureParams params) throws RemoteException {
        }

        @Override
        public void setShouldDockBigOverlays(IBinder token, boolean shouldDockBigOverlays) throws RemoteException {
        }

        @Override
        public void toggleFreeformWindowingMode(IBinder token) throws RemoteException {
        }

        @Override
        public void requestMultiwindowFullscreen(IBinder token, int request, IRemoteCallback callback) throws RemoteException {
        }

        @Override
        public void startLockTaskModeByToken(IBinder token) throws RemoteException {
        }

        @Override
        public void stopLockTaskModeByToken(IBinder token) throws RemoteException {
        }

        @Override
        public void showLockTaskEscapeMessage(IBinder token) throws RemoteException {
        }

        @Override
        public void setTaskDescription(IBinder token, ActivityManager.TaskDescription values) throws RemoteException {
        }

        @Override
        public boolean showAssistFromActivity(IBinder token, Bundle args) throws RemoteException {
            return false;
        }

        @Override
        public boolean isRootVoiceInteraction(IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public void startLocalVoiceInteraction(IBinder token, Bundle options) throws RemoteException {
        }

        @Override
        public void stopLocalVoiceInteraction(IBinder token) throws RemoteException {
        }

        @Override
        public void setShowWhenLocked(IBinder token, boolean showWhenLocked) throws RemoteException {
        }

        @Override
        public void setInheritShowWhenLocked(IBinder token, boolean setInheritShownWhenLocked) throws RemoteException {
        }

        @Override
        public void setTurnScreenOn(IBinder token, boolean turnScreenOn) throws RemoteException {
        }

        @Override
        public void setAllowCrossUidActivitySwitchFromBelow(IBinder token, boolean allowed) throws RemoteException {
        }

        @Override
        public void reportActivityFullyDrawn(IBinder token, boolean restoredFromBundle) throws RemoteException {
        }

        @Override
        public void overrideActivityTransition(IBinder token, boolean open, int enterAnim, int exitAnim, int backgroundColor) throws RemoteException {
        }

        @Override
        public void clearOverrideActivityTransition(IBinder token, boolean open) throws RemoteException {
        }

        @Override
        public void overridePendingTransition(IBinder token, String packageName, int enterAnim, int exitAnim, int backgroundColor) throws RemoteException {
        }

        @Override
        public int setVrMode(IBinder token, boolean enabled, ComponentName packageName) throws RemoteException {
            return 0;
        }

        @Override
        public void setRecentsScreenshotEnabled(IBinder token, boolean enabled) throws RemoteException {
        }

        @Override
        public void invalidateHomeTaskSnapshot(IBinder homeToken) throws RemoteException {
        }

        @Override
        public void dismissKeyguard(IBinder token, IKeyguardDismissCallback callback, CharSequence message) throws RemoteException {
        }

        @Override
        public void registerRemoteAnimations(IBinder token, RemoteAnimationDefinition definition) throws RemoteException {
        }

        @Override
        public void unregisterRemoteAnimations(IBinder token) throws RemoteException {
        }

        @Override
        public void onBackPressed(IBinder activityToken, IRequestFinishCallback callback) throws RemoteException {
        }

        @Override
        public void splashScreenAttached(IBinder token) throws RemoteException {
        }

        @Override
        public void enableTaskLocaleOverride(IBinder token) throws RemoteException {
        }

        @Override
        public boolean isRequestedToLaunchInTaskFragment(IBinder activityToken, IBinder taskFragmentToken) throws RemoteException {
            return false;
        }

        @Override
        public void setActivityRecordInputSinkEnabled(IBinder activityToken, boolean enabled) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

