/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.app.ActivityManager;
import android.app.ActivityTaskManager;
import android.app.IActivityClientController;
import android.app.IRequestFinishCallback;
import android.app.PictureInPictureParams;
import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Singleton;
import android.view.RemoteAnimationDefinition;
import android.window.SizeConfigurationBuckets;
import com.android.internal.policy.IKeyguardDismissCallback;

public class ActivityClient {
    private static final Singleton<ActivityClient> sInstance = new Singleton<ActivityClient>(){

        @Override
        protected ActivityClient create() {
            return new ActivityClient();
        }
    };
    private static final ActivityClientControllerSingleton INTERFACE_SINGLETON = new ActivityClientControllerSingleton();

    private ActivityClient() {
    }

    public void activityIdle(IBinder token, Configuration config, boolean stopProfiling) {
        try {
            ActivityClient.getActivityClientController().activityIdle(token, config, stopProfiling);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void activityResumed(IBinder token, boolean handleSplashScreenExit) {
        try {
            ActivityClient.getActivityClientController().activityResumed(token, handleSplashScreenExit);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void activityRefreshed(IBinder token) {
        try {
            ActivityClient.getActivityClientController().activityRefreshed(token);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void activityTopResumedStateLost() {
        try {
            ActivityClient.getActivityClientController().activityTopResumedStateLost();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void activityPaused(IBinder token) {
        try {
            ActivityClient.getActivityClientController().activityPaused(token);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void activityStopped(IBinder token, Bundle state, PersistableBundle persistentState, CharSequence description) {
        try {
            ActivityClient.getActivityClientController().activityStopped(token, state, persistentState, description);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void activityDestroyed(IBinder token) {
        try {
            ActivityClient.getActivityClientController().activityDestroyed(token);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void activityLocalRelaunch(IBinder token) {
        try {
            ActivityClient.getActivityClientController().activityLocalRelaunch(token);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void activityRelaunched(IBinder token) {
        try {
            ActivityClient.getActivityClientController().activityRelaunched(token);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void reportSizeConfigurations(IBinder token, SizeConfigurationBuckets sizeConfigurations) {
        try {
            ActivityClient.getActivityClientController().reportSizeConfigurations(token, sizeConfigurations);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public boolean moveActivityTaskToBack(IBinder token, boolean nonRoot) {
        try {
            return ActivityClient.getActivityClientController().moveActivityTaskToBack(token, nonRoot);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    boolean shouldUpRecreateTask(IBinder token, String destAffinity) {
        try {
            return ActivityClient.getActivityClientController().shouldUpRecreateTask(token, destAffinity);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    boolean navigateUpTo(IBinder token, Intent destIntent, String resolvedType, int resultCode, Intent resultData) {
        try {
            return ActivityClient.getActivityClientController().navigateUpTo(token, destIntent, resolvedType, resultCode, resultData);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    boolean releaseActivityInstance(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().releaseActivityInstance(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean finishActivity(IBinder token, int resultCode, Intent resultData, int finishTask) {
        try {
            return ActivityClient.getActivityClientController().finishActivity(token, resultCode, resultData, finishTask);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    boolean finishActivityAffinity(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().finishActivityAffinity(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void finishSubActivity(IBinder token, String resultWho, int requestCode) {
        try {
            ActivityClient.getActivityClientController().finishSubActivity(token, resultWho, requestCode);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_MEDIA_PROJECTION")
    void setForceSendResultForMediaProjection(IBinder token) {
        try {
            ActivityClient.getActivityClientController().setForceSendResultForMediaProjection(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isTopOfTask(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().isTopOfTask(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    boolean willActivityBeVisible(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().willActivityBeVisible(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getDisplayId(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().getDisplayId(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getTaskForActivity(IBinder token, boolean onlyRoot) {
        try {
            return ActivityClient.getActivityClientController().getTaskForActivity(token, onlyRoot);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    public Configuration getTaskConfiguration(IBinder activityToken) {
        try {
            return ActivityClient.getActivityClientController().getTaskConfiguration(activityToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    public IBinder getActivityTokenBelow(IBinder activityToken) {
        try {
            return ActivityClient.getActivityClientController().getActivityTokenBelow(activityToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    ComponentName getCallingActivity(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().getCallingActivity(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    String getCallingPackage(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().getCallingPackage(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getLaunchedFromUid(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().getLaunchedFromUid(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public String getLaunchedFromPackage(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().getLaunchedFromPackage(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getActivityCallerUid(IBinder activityToken, IBinder callerToken) {
        try {
            return ActivityClient.getActivityClientController().getActivityCallerUid(activityToken, callerToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public String getActivityCallerPackage(IBinder activityToken, IBinder callerToken) {
        try {
            return ActivityClient.getActivityClientController().getActivityCallerPackage(activityToken, callerToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int checkActivityCallerContentUriPermission(IBinder activityToken, IBinder callerToken, Uri uri, int modeFlags) {
        try {
            return ActivityClient.getActivityClientController().checkActivityCallerContentUriPermission(activityToken, callerToken, ContentProvider.getUriWithoutUserId(uri), modeFlags, ContentProvider.getUserIdFromUri(uri, UserHandle.getCallingUserId()));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setRequestedOrientation(IBinder token, int requestedOrientation) {
        try {
            ActivityClient.getActivityClientController().setRequestedOrientation(token, requestedOrientation);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    int getRequestedOrientation(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().getRequestedOrientation(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    boolean convertFromTranslucent(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().convertFromTranslucent(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    boolean convertToTranslucent(IBinder token, Bundle options) {
        try {
            return ActivityClient.getActivityClientController().convertToTranslucent(token, options);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void reportActivityFullyDrawn(IBinder token, boolean restoredFromBundle) {
        try {
            ActivityClient.getActivityClientController().reportActivityFullyDrawn(token, restoredFromBundle);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    boolean isHandoffEnabled(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().isHandoffEnabled(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    boolean isHandoffFullTaskRecreationAllowed(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().isHandoffFullTaskRecreationAllowed(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void setHandoffEnabled(IBinder token, boolean handoffEnabled, boolean allowFullTaskRecreation) {
        try {
            ActivityClient.getActivityClientController().setHandoffEnabled(token, handoffEnabled, allowFullTaskRecreation);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    boolean isImmersive(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().isImmersive(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void setImmersive(IBinder token, boolean immersive) {
        try {
            ActivityClient.getActivityClientController().setImmersive(token, immersive);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    boolean enterPictureInPictureMode(IBinder token, PictureInPictureParams params) {
        try {
            return ActivityClient.getActivityClientController().enterPictureInPictureMode(token, params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void setPictureInPictureParams(IBinder token, PictureInPictureParams params) {
        try {
            ActivityClient.getActivityClientController().setPictureInPictureParams(token, params);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void setShouldDockBigOverlays(IBinder token, boolean shouldDockBigOverlays) {
        try {
            ActivityClient.getActivityClientController().setShouldDockBigOverlays(token, shouldDockBigOverlays);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void toggleFreeformWindowingMode(IBinder token) {
        try {
            ActivityClient.getActivityClientController().toggleFreeformWindowingMode(token);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void requestMultiwindowFullscreen(IBinder token, int request, IRemoteCallback callback) {
        try {
            ActivityClient.getActivityClientController().requestMultiwindowFullscreen(token, request, callback);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void startLockTaskModeByToken(IBinder token) {
        try {
            ActivityClient.getActivityClientController().startLockTaskModeByToken(token);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void stopLockTaskModeByToken(IBinder token) {
        try {
            ActivityClient.getActivityClientController().stopLockTaskModeByToken(token);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void showLockTaskEscapeMessage(IBinder token) {
        try {
            ActivityClient.getActivityClientController().showLockTaskEscapeMessage(token);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void setTaskDescription(IBinder token, ActivityManager.TaskDescription td) {
        try {
            ActivityClient.getActivityClientController().setTaskDescription(token, td);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    boolean showAssistFromActivity(IBinder token, Bundle args) {
        try {
            return ActivityClient.getActivityClientController().showAssistFromActivity(token, args);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    boolean isRootVoiceInteraction(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().isRootVoiceInteraction(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void startLocalVoiceInteraction(IBinder callingActivity, Bundle options) {
        try {
            ActivityClient.getActivityClientController().startLocalVoiceInteraction(callingActivity, options);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void stopLocalVoiceInteraction(IBinder callingActivity) {
        try {
            ActivityClient.getActivityClientController().stopLocalVoiceInteraction(callingActivity);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void setShowWhenLocked(IBinder token, boolean showWhenLocked) {
        try {
            ActivityClient.getActivityClientController().setShowWhenLocked(token, showWhenLocked);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void setInheritShowWhenLocked(IBinder token, boolean inheritShowWhenLocked) {
        try {
            ActivityClient.getActivityClientController().setInheritShowWhenLocked(token, inheritShowWhenLocked);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void setTurnScreenOn(IBinder token, boolean turnScreenOn) {
        try {
            ActivityClient.getActivityClientController().setTurnScreenOn(token, turnScreenOn);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void setAllowCrossUidActivitySwitchFromBelow(IBinder token, boolean allowed) {
        try {
            ActivityClient.getActivityClientController().setAllowCrossUidActivitySwitchFromBelow(token, allowed);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    int setVrMode(IBinder token, boolean enabled, ComponentName packageName) {
        try {
            return ActivityClient.getActivityClientController().setVrMode(token, enabled, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void overrideActivityTransition(IBinder token, boolean open, int enterAnim, int exitAnim, int backgroundColor) {
        try {
            ActivityClient.getActivityClientController().overrideActivityTransition(token, open, enterAnim, exitAnim, backgroundColor);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void clearOverrideActivityTransition(IBinder token, boolean open) {
        try {
            ActivityClient.getActivityClientController().clearOverrideActivityTransition(token, open);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void overridePendingTransition(IBinder token, String packageName, int enterAnim, int exitAnim, int backgroundColor) {
        try {
            ActivityClient.getActivityClientController().overridePendingTransition(token, packageName, enterAnim, exitAnim, backgroundColor);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void setRecentsScreenshotEnabled(IBinder token, boolean enabled) {
        try {
            ActivityClient.getActivityClientController().setRecentsScreenshotEnabled(token, enabled);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void invalidateHomeTaskSnapshot(IBinder homeToken) {
        try {
            ActivityClient.getActivityClientController().invalidateHomeTaskSnapshot(homeToken);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void dismissKeyguard(IBinder token, IKeyguardDismissCallback callback, CharSequence message) {
        try {
            ActivityClient.getActivityClientController().dismissKeyguard(token, callback, message);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void registerRemoteAnimations(IBinder token, RemoteAnimationDefinition definition) {
        try {
            ActivityClient.getActivityClientController().registerRemoteAnimations(token, definition);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void unregisterRemoteAnimations(IBinder token) {
        try {
            ActivityClient.getActivityClientController().unregisterRemoteAnimations(token);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void onBackPressed(IBinder token, IRequestFinishCallback callback) {
        try {
            ActivityClient.getActivityClientController().onBackPressed(token, callback);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void reportSplashScreenAttached(IBinder token) {
        try {
            ActivityClient.getActivityClientController().splashScreenAttached(token);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void enableTaskLocaleOverride(IBinder token) {
        try {
            ActivityClient.getActivityClientController().enableTaskLocaleOverride(token);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public boolean isRequestedToLaunchInTaskFragment(IBinder activityToken, IBinder taskFragmentToken) {
        try {
            return ActivityClient.getActivityClientController().isRequestedToLaunchInTaskFragment(activityToken, taskFragmentToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.INTERNAL_SYSTEM_WINDOW")
    void setActivityRecordInputSinkEnabled(IBinder activityToken, boolean enabled) {
        try {
            ActivityClient.getActivityClientController().setActivityRecordInputSinkEnabled(activityToken, enabled);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public static ActivityClient getInstance() {
        return sInstance.get();
    }

    public static IActivityClientController setActivityClientController(IActivityClientController activityClientController) {
        ActivityClient.INTERFACE_SINGLETON.mKnownInstance = activityClientController;
        return ActivityClient.INTERFACE_SINGLETON.mKnownInstance;
    }

    private static IActivityClientController getActivityClientController() {
        IActivityClientController controller = ActivityClient.INTERFACE_SINGLETON.mKnownInstance;
        return controller != null ? controller : (IActivityClientController)INTERFACE_SINGLETON.get();
    }

    private static class ActivityClientControllerSingleton
    extends Singleton<IActivityClientController> {
        IActivityClientController mKnownInstance;

        private ActivityClientControllerSingleton() {
        }

        @Override
        protected IActivityClientController create() {
            try {
                return ActivityTaskManager.getService().getActivityClientController();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }
}

