/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.topics;

import android.adservices.common.AdServicesStatusUtils;
import android.adservices.common.CallerMetadata;
import android.adservices.common.SandboxedSdkContextUtils;
import android.adservices.topics.EncryptedTopic;
import android.adservices.topics.GetTopicsParam;
import android.adservices.topics.GetTopicsRequest;
import android.adservices.topics.GetTopicsResponse;
import android.adservices.topics.GetTopicsResult;
import android.adservices.topics.IGetTopicsCallback;
import android.adservices.topics.ITopicsService;
import android.adservices.topics.Topic;
import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.app.sdksandbox.SandboxedSdkContext;
import android.content.Context;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os._Original_Build;
import android.text.TextUtils;
import com.android.adservices.LoggerFactory;
import com.android.adservices.ServiceBinder;
import com.android.adservices.shared.common.exception.ServiceUnavailableException;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

@RequiresApi(value=31)
public class TopicsManager {
    private static final LoggerFactory.Logger sLogger = LoggerFactory.getTopicsLogger();
    public static final String TOPICS_SERVICE = "topics_service";
    static final String EMPTY_SDK = "";
    static final boolean RECORD_OBSERVATION_DEFAULT = true;
    private Context mContext;
    private ServiceBinder<ITopicsService> mServiceBinder;

    @NonNull
    public static TopicsManager get(@NonNull Context context) {
        if (_Original_Build.VERSION.SDK_INT < 31) {
            throw new ServiceUnavailableException("Service is not available.");
        }
        return _Original_Build.VERSION.SDK_INT >= 33 ? context.getSystemService(TopicsManager.class) : new TopicsManager(context);
    }

    public TopicsManager(Context context) {
        if (_Original_Build.VERSION.SDK_INT < 31) {
            throw new ServiceUnavailableException("Service is not available.");
        }
        this.initialize(context);
    }

    public TopicsManager initialize(Context context) {
        this.mContext = context;
        this.mServiceBinder = ServiceBinder.getServiceBinder(context, "android.adservices.TOPICS_SERVICE", ITopicsService.Stub::asInterface);
        return this;
    }

    @NonNull
    private ITopicsService getService() {
        ITopicsService service = this.mServiceBinder.getService();
        if (service == null) {
            throw new ServiceUnavailableException("Service is not available.");
        }
        return service;
    }

    @NonNull
    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_TOPICS")
    public void getTopics(@NonNull GetTopicsRequest getTopicsRequest, final @NonNull Executor executor, final @NonNull OutcomeReceiver<GetTopicsResponse, Exception> callback) {
        Objects.requireNonNull(getTopicsRequest);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        CallerMetadata callerMetadata = new CallerMetadata.Builder().setBinderElapsedTimestamp(SystemClock.elapsedRealtime()).build();
        ITopicsService service = this.getService();
        String sdkName = getTopicsRequest.getAdsSdkName();
        String appPackageName = EMPTY_SDK;
        String sdkPackageName = EMPTY_SDK;
        SandboxedSdkContext sandboxedSdkContext = SandboxedSdkContextUtils.getAsSandboxedSdkContext(this.mContext);
        if (sandboxedSdkContext != null) {
            sdkPackageName = sandboxedSdkContext.getSdkPackageName();
            appPackageName = sandboxedSdkContext.getClientPackageName();
            if (!TextUtils.isEmpty(sdkName)) {
                throw new IllegalArgumentException("When calling Topics API from Sandbox, caller should not set Ads Sdk Name");
            }
            String sdkNameFromSandboxedContext = sandboxedSdkContext.getSdkName();
            if (null == sdkNameFromSandboxedContext || sdkNameFromSandboxedContext.isEmpty()) {
                throw new IllegalArgumentException("Sdk Name From SandboxedSdkContext should not be null or empty");
            }
            sdkName = sdkNameFromSandboxedContext;
        } else {
            if (null == sdkName) {
                sdkName = EMPTY_SDK;
            }
            appPackageName = this.mContext.getPackageName();
        }
        try {
            service.getTopics(new GetTopicsParam.Builder().setAppPackageName(appPackageName).setSdkName(sdkName).setSdkPackageName(sdkPackageName).setShouldRecordObservation(getTopicsRequest.shouldRecordObservation()).build(), callerMetadata, new IGetTopicsCallback.Stub(){

                @Override
                public void onResult(GetTopicsResult resultParcel) {
                    executor.execute(() -> {
                        if (resultParcel.isSuccess()) {
                            callback.onResult(TopicsManager.this.buildGetTopicsResponse(resultParcel));
                        } else {
                            callback.onError(AdServicesStatusUtils.asException(resultParcel));
                        }
                    });
                }

                @Override
                public void onFailure(int resultCode) {
                    executor.execute(() -> callback.onError(AdServicesStatusUtils.asException(resultCode)));
                }
            });
        }
        catch (RemoteException e) {
            sLogger.e(e, "RemoteException");
            callback.onError(e);
        }
    }

    private GetTopicsResponse buildGetTopicsResponse(GetTopicsResult resultParcel) {
        return new GetTopicsResponse.Builder(this.getTopicList(resultParcel), this.getEncryptedTopicList(resultParcel)).build();
    }

    private List<Topic> getTopicList(GetTopicsResult resultParcel) {
        List<Long> taxonomyVersionsList = resultParcel.getTaxonomyVersions();
        List<Long> modelVersionsList = resultParcel.getModelVersions();
        List<Integer> topicsCodeList = resultParcel.getTopics();
        ArrayList<Topic> topicList = new ArrayList<Topic>();
        int size = taxonomyVersionsList.size();
        for (int i = 0; i < size; ++i) {
            Topic topic = new Topic(taxonomyVersionsList.get(i), modelVersionsList.get(i), topicsCodeList.get(i));
            topicList.add(topic);
        }
        return topicList;
    }

    private List<EncryptedTopic> getEncryptedTopicList(GetTopicsResult resultParcel) {
        ArrayList<EncryptedTopic> encryptedTopicList = new ArrayList<EncryptedTopic>();
        List<byte[]> encryptedTopics = resultParcel.getEncryptedTopics();
        List<String> encryptionKeys = resultParcel.getEncryptionKeys();
        List<byte[]> encapsulatedKeys = resultParcel.getEncapsulatedKeys();
        int size = encryptedTopics.size();
        for (int i = 0; i < size; ++i) {
            EncryptedTopic encryptedTopic = new EncryptedTopic(encryptedTopics.get(i), encryptionKeys.get(i), encapsulatedKeys.get(i));
            encryptedTopicList.add(encryptedTopic);
        }
        return encryptedTopicList;
    }

    public void unbindFromService() {
        this.mServiceBinder.unbindFromService();
    }
}

