/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.topics;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;

public class GetTopicsParam
implements Parcelable {
    private final String mSdkName;
    private final String mSdkPackageName;
    private final String mAppPackageName;
    private final boolean mRecordObservation;
    @NonNull
    public static final Parcelable.Creator<GetTopicsParam> CREATOR = new Parcelable.Creator<GetTopicsParam>(){

        @Override
        public GetTopicsParam createFromParcel(Parcel in) {
            return new GetTopicsParam(in);
        }

        public GetTopicsParam[] newArray(int size) {
            return new GetTopicsParam[size];
        }
    };

    private GetTopicsParam(@NonNull String sdkName, @Nullable String sdkPackageName, @NonNull String appPackageName, boolean recordObservation) {
        this.mSdkName = sdkName;
        this.mSdkPackageName = sdkPackageName;
        this.mAppPackageName = appPackageName;
        this.mRecordObservation = recordObservation;
    }

    private GetTopicsParam(@NonNull Parcel in) {
        this.mSdkName = in.readString();
        this.mSdkPackageName = in.readString();
        this.mAppPackageName = in.readString();
        this.mRecordObservation = in.readBoolean();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeString(this.mSdkName);
        out.writeString(this.mSdkPackageName);
        out.writeString(this.mAppPackageName);
        out.writeBoolean(this.mRecordObservation);
    }

    @NonNull
    public String getSdkName() {
        return this.mSdkName;
    }

    @NonNull
    public String getSdkPackageName() {
        return this.mSdkPackageName;
    }

    @NonNull
    public String getAppPackageName() {
        return this.mAppPackageName;
    }

    public boolean shouldRecordObservation() {
        return this.mRecordObservation;
    }

    public static class Builder {
        private String mSdkName;
        private String mSdkPackageName;
        private String mAppPackageName;
        private boolean mRecordObservation = true;

        @NonNull
        public Builder setSdkName(@NonNull String sdkName) {
            this.mSdkName = sdkName;
            return this;
        }

        @NonNull
        public Builder setSdkPackageName(@NonNull String sdkPackageName) {
            this.mSdkPackageName = sdkPackageName;
            return this;
        }

        @NonNull
        public Builder setAppPackageName(@NonNull String appPackageName) {
            this.mAppPackageName = appPackageName;
            return this;
        }

        @NonNull
        public Builder setShouldRecordObservation(boolean recordObservation) {
            this.mRecordObservation = recordObservation;
            return this;
        }

        @NonNull
        public GetTopicsParam build() {
            if (this.mSdkName == null) {
                this.mSdkName = "";
            }
            if (this.mSdkPackageName == null) {
                this.mSdkPackageName = "";
            }
            if (this.mAppPackageName == null || this.mAppPackageName.isEmpty()) {
                throw new IllegalArgumentException("App PackageName must not be empty or null");
            }
            return new GetTopicsParam(this.mSdkName, this.mSdkPackageName, this.mAppPackageName, this.mRecordObservation);
        }
    }
}

