/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.signals;

import android.adservices.common.AdServicesStatusUtils;
import android.adservices.common.FledgeErrorResponse;
import android.adservices.common.SandboxedSdkContextUtils;
import android.adservices.signals.IProtectedSignalsService;
import android.adservices.signals.UpdateSignalsCallback;
import android.adservices.signals.UpdateSignalsInput;
import android.adservices.signals.UpdateSignalsRequest;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresApi;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.app.sdksandbox.SandboxedSdkContext;
import android.content.Context;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.os._Original_Build;
import com.android.adservices.LoggerFactory;
import com.android.adservices.ServiceBinder;
import java.util.Objects;
import java.util.concurrent.Executor;

@FlaggedApi(value="com.android.adservices.flags.protected_signals_enabled")
@RequiresApi(value=31)
public class ProtectedSignalsManager {
    private static final LoggerFactory.Logger sLogger = LoggerFactory.getFledgeLogger();
    public static final String PROTECTED_SIGNALS_SERVICE = "protected_signals_service";
    @NonNull
    private Context mContext;
    @NonNull
    private ServiceBinder<IProtectedSignalsService> mServiceBinder;

    @SuppressLint(value={"ManagerLookup"})
    @NonNull
    public static ProtectedSignalsManager get(@NonNull Context context) {
        return _Original_Build.VERSION.SDK_INT >= 33 ? context.getSystemService(ProtectedSignalsManager.class) : new ProtectedSignalsManager(context);
    }

    public ProtectedSignalsManager(@NonNull Context context) {
        Objects.requireNonNull(context);
        this.initialize(context);
    }

    public ProtectedSignalsManager initialize(@NonNull Context context) {
        Objects.requireNonNull(context);
        this.mContext = context;
        this.mServiceBinder = ServiceBinder.getServiceBinder(context, "android.adservices.signals.PROTECTED_SIGNALS_SERVICE", IProtectedSignalsService.Stub::asInterface);
        return this;
    }

    @NonNull
    IProtectedSignalsService getService() {
        IProtectedSignalsService service = this.mServiceBinder.getService();
        if (service == null) {
            throw new IllegalStateException("Unable to find the service");
        }
        return service;
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_PROTECTED_SIGNALS")
    public void updateSignals(@NonNull UpdateSignalsRequest updateSignalsRequest, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Object, Exception> receiver) {
        Objects.requireNonNull(updateSignalsRequest);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(receiver);
        try {
            IProtectedSignalsService service = this.getService();
            service.updateSignals(new UpdateSignalsInput.Builder(updateSignalsRequest.getUpdateUri(), this.getCallerPackageName()).build(), new UpdateSignalsCallback.Stub(this){

                @Override
                public void onSuccess() {
                    executor.execute(() -> receiver.onResult(new Object()));
                }

                @Override
                public void onFailure(FledgeErrorResponse failureParcel) {
                    executor.execute(() -> receiver.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (RemoteException e) {
            sLogger.e(e, "Exception");
            receiver.onError(new IllegalStateException("Internal Error!", e));
        }
    }

    private String getCallerPackageName() {
        SandboxedSdkContext sandboxedSdkContext = SandboxedSdkContextUtils.getAsSandboxedSdkContext(this.mContext);
        return sandboxedSdkContext == null ? this.mContext.getPackageName() : sandboxedSdkContext.getClientPackageName();
    }
}

