/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.measurement;

import android.adservices.common.AdServicesOutcomeReceiver;
import android.adservices.common.AndroidRCommonUtil;
import android.adservices.common.OutcomeReceiverConverter;
import android.adservices.exceptions.AdServicesException;
import android.adservices.measurement.DeletionRequest;
import android.adservices.measurement.MeasurementCompatibleManager;
import android.adservices.measurement.SourceRegistrationRequest;
import android.adservices.measurement.WebSourceRegistrationRequest;
import android.adservices.measurement.WebTriggerRegistrationRequest;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.content.Context;
import android.net.Uri;
import android.os.OutcomeReceiver;
import android.os._Original_Build;
import android.view.InputEvent;
import com.android.internal.annotations.VisibleForTesting;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.concurrent.Executor;

public class MeasurementManager {
    public static final String MEASUREMENT_SERVICE = "measurement_service";
    public static final int MEASUREMENT_API_STATE_DISABLED = 0;
    public static final int MEASUREMENT_API_STATE_ENABLED = 1;
    private MeasurementCompatibleManager mImpl;

    @NonNull
    public static MeasurementManager get(@NonNull Context context) {
        return _Original_Build.VERSION.SDK_INT >= 33 ? context.getSystemService(MeasurementManager.class) : new MeasurementManager(context);
    }

    public MeasurementManager(Context context) {
        this.initialize(context);
    }

    @VisibleForTesting
    public MeasurementManager(@NonNull MeasurementCompatibleManager compatibleManager) {
        Objects.requireNonNull(compatibleManager);
        this.mImpl = compatibleManager;
    }

    public MeasurementManager initialize(@NonNull Context context) {
        this.mImpl = MeasurementCompatibleManager.get(context);
        return this;
    }

    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_ATTRIBUTION")
    public void registerSource(@NonNull Uri attributionSource, @Nullable InputEvent inputEvent, @Nullable Executor executor, @Nullable OutcomeReceiver<Object, Exception> callback) {
        this.mImpl.registerSource(attributionSource, inputEvent, executor, callback);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_ATTRIBUTION")
    @FlaggedApi(value="com.android.adservices.flags.adservices_outcomereceiver_r_api_deprecated")
    public void registerSource(@NonNull Uri attributionSource, @Nullable InputEvent inputEvent, @Nullable Executor executor, @Nullable AdServicesOutcomeReceiver<Object, Exception> callback) {
        if (AndroidRCommonUtil.invokeCallbackOnErrorOnRvc(callback)) {
            return;
        }
        this.mImpl.registerSource(attributionSource, inputEvent, executor, OutcomeReceiverConverter.toOutcomeReceiver(callback));
    }

    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_ATTRIBUTION")
    public void registerSource(@NonNull SourceRegistrationRequest request, @Nullable Executor executor, @Nullable OutcomeReceiver<Object, Exception> callback) {
        this.mImpl.registerSource(request, executor, callback);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_ATTRIBUTION")
    @FlaggedApi(value="com.android.adservices.flags.adservices_outcomereceiver_r_api_deprecated")
    public void registerSource(@NonNull SourceRegistrationRequest request, @Nullable Executor executor, @Nullable AdServicesOutcomeReceiver<Object, Exception> callback) {
        if (AndroidRCommonUtil.invokeCallbackOnErrorOnRvc(callback)) {
            callback.onError(new AdServicesException("AdServices is not supported on Android R"));
            return;
        }
        this.mImpl.registerSource(request, executor, OutcomeReceiverConverter.toOutcomeReceiver(callback));
    }

    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_ATTRIBUTION")
    public void registerWebSource(@NonNull WebSourceRegistrationRequest request, @Nullable Executor executor, @Nullable OutcomeReceiver<Object, Exception> callback) {
        this.mImpl.registerWebSource(request, executor, callback);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_ATTRIBUTION")
    @FlaggedApi(value="com.android.adservices.flags.adservices_outcomereceiver_r_api_deprecated")
    public void registerWebSource(@NonNull WebSourceRegistrationRequest request, @Nullable Executor executor, @Nullable AdServicesOutcomeReceiver<Object, Exception> callback) {
        if (AndroidRCommonUtil.invokeCallbackOnErrorOnRvc(callback)) {
            return;
        }
        this.mImpl.registerWebSource(request, executor, OutcomeReceiverConverter.toOutcomeReceiver(callback));
    }

    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_ATTRIBUTION")
    public void registerWebTrigger(@NonNull WebTriggerRegistrationRequest request, @Nullable Executor executor, @Nullable OutcomeReceiver<Object, Exception> callback) {
        this.mImpl.registerWebTrigger(request, executor, callback);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_ATTRIBUTION")
    @FlaggedApi(value="com.android.adservices.flags.adservices_outcomereceiver_r_api_deprecated")
    public void registerWebTrigger(@NonNull WebTriggerRegistrationRequest request, @Nullable Executor executor, @Nullable AdServicesOutcomeReceiver<Object, Exception> callback) {
        if (AndroidRCommonUtil.invokeCallbackOnErrorOnRvc(callback)) {
            return;
        }
        this.mImpl.registerWebTrigger(request, executor, OutcomeReceiverConverter.toOutcomeReceiver(callback));
    }

    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_ATTRIBUTION")
    public void registerTrigger(@NonNull Uri trigger, @Nullable Executor executor, @Nullable OutcomeReceiver<Object, Exception> callback) {
        this.mImpl.registerTrigger(trigger, executor, callback);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_ATTRIBUTION")
    @FlaggedApi(value="com.android.adservices.flags.adservices_outcomereceiver_r_api_deprecated")
    public void registerTrigger(@NonNull Uri trigger, @Nullable Executor executor, @Nullable AdServicesOutcomeReceiver<Object, Exception> callback) {
        if (AndroidRCommonUtil.invokeCallbackOnErrorOnRvc(callback)) {
            return;
        }
        this.mImpl.registerTrigger(trigger, executor, OutcomeReceiverConverter.toOutcomeReceiver(callback));
    }

    @RequiresApi(value=31)
    public void deleteRegistrations(@NonNull DeletionRequest deletionRequest, @NonNull Executor executor, @NonNull OutcomeReceiver<Object, Exception> callback) {
        this.mImpl.deleteRegistrations(deletionRequest, executor, callback);
    }

    @Deprecated
    @FlaggedApi(value="com.android.adservices.flags.adservices_outcomereceiver_r_api_deprecated")
    public void deleteRegistrations(@NonNull DeletionRequest deletionRequest, @NonNull Executor executor, @NonNull AdServicesOutcomeReceiver<Object, Exception> callback) {
        if (AndroidRCommonUtil.invokeCallbackOnErrorOnRvc(callback)) {
            return;
        }
        this.mImpl.deleteRegistrations(deletionRequest, executor, OutcomeReceiverConverter.toOutcomeReceiver(callback));
    }

    @RequiresApi(value=31)
    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_ATTRIBUTION")
    public void getMeasurementApiStatus(@NonNull Executor executor, @NonNull OutcomeReceiver<Integer, Exception> callback) {
        this.mImpl.getMeasurementApiStatus(executor, callback);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_ATTRIBUTION")
    @FlaggedApi(value="com.android.adservices.flags.adservices_outcomereceiver_r_api_deprecated")
    public void getMeasurementApiStatus(@NonNull Executor executor, @NonNull AdServicesOutcomeReceiver<Integer, Exception> callback) {
        if (AndroidRCommonUtil.invokeCallbackOnErrorOnRvc(callback)) {
            return;
        }
        this.mImpl.getMeasurementApiStatus(executor, OutcomeReceiverConverter.toOutcomeReceiver(callback));
    }

    @VisibleForTesting
    public void unbindFromService() {
        this.mImpl.unbindFromService();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MeasurementApiState {
    }
}

