/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.measurement;

import android.adservices.adid.AdId;
import android.adservices.adid.AdIdManager;
import android.adservices.common.AdServicesStatusUtils;
import android.adservices.common.CallerMetadata;
import android.adservices.common.SandboxedSdkContextUtils;
import android.adservices.measurement.DeletionParam;
import android.adservices.measurement.DeletionRequest;
import android.adservices.measurement.IMeasurementApiStatusCallback;
import android.adservices.measurement.IMeasurementCallback;
import android.adservices.measurement.IMeasurementService;
import android.adservices.measurement.MeasurementErrorResponse;
import android.adservices.measurement.RegistrationRequest;
import android.adservices.measurement.SourceRegistrationRequest;
import android.adservices.measurement.SourceRegistrationRequestInternal;
import android.adservices.measurement.StatusParam;
import android.adservices.measurement.WebSourceRegistrationRequest;
import android.adservices.measurement.WebSourceRegistrationRequestInternal;
import android.adservices.measurement.WebTriggerRegistrationRequest;
import android.adservices.measurement.WebTriggerRegistrationRequestInternal;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.app.sdksandbox.SandboxedSdkContext;
import android.content.Context;
import android.net.Uri;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.view.InputEvent;
import com.android.adservices.LogUtil;
import com.android.adservices.ServiceBinder;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class MeasurementCompatibleManager {
    private static final long AD_ID_TIMEOUT_MS = 400L;
    private final Context mContext;
    private final ServiceBinder<IMeasurementService> mServiceBinder;
    private AdIdManager mAdIdManager;
    private final Executor mAdIdExecutor = Executors.newCachedThreadPool();
    private static final String DEBUG_API_WARNING_MESSAGE = "To enable debug api, include ACCESS_ADSERVICES_AD_ID permission and enable advertising ID under device settings";

    @NonNull
    public static MeasurementCompatibleManager get(@NonNull Context context) {
        return new MeasurementCompatibleManager(context);
    }

    @VisibleForTesting
    public static MeasurementCompatibleManager get(Context context, AdIdManager adIdManager) {
        MeasurementCompatibleManager measurementManager = MeasurementCompatibleManager.get(context);
        measurementManager.mAdIdManager = adIdManager;
        return measurementManager;
    }

    private MeasurementCompatibleManager(Context context) {
        this.mContext = context;
        this.mServiceBinder = ServiceBinder.getServiceBinder(context, "android.adservices.MEASUREMENT_SERVICE", IMeasurementService.Stub::asInterface);
        this.mAdIdManager = new AdIdManager(context);
    }

    @VisibleForTesting
    @NonNull
    public IMeasurementService getService() throws IllegalStateException {
        IMeasurementService service = this.mServiceBinder.getService();
        if (service == null) {
            throw new IllegalStateException("Unable to find the service");
        }
        return service;
    }

    private boolean isAdIdPermissionEnabled(AdId adId) {
        return !"00000000-0000-0000-0000-000000000000".equals(adId.getAdId());
    }

    private void register(@NonNull RegistrationRequest registrationRequest, @NonNull IMeasurementService service, final @Nullable Executor executor, final @Nullable OutcomeReceiver<Object, Exception> callback) {
        block3: {
            Objects.requireNonNull(registrationRequest);
            MeasurementCompatibleManager.requireExecutorForCallback(executor, callback);
            String registrationType = "source";
            if (registrationRequest.getRegistrationType() == 2) {
                registrationType = "trigger";
            }
            LogUtil.d("Registering " + registrationType);
            try {
                service.register(registrationRequest, this.generateCallerMetadataWithCurrentTime(), new IMeasurementCallback.Stub(this){

                    @Override
                    public void onResult() {
                        if (callback != null) {
                            executor.execute(() -> callback.onResult(new Object()));
                        }
                    }

                    @Override
                    public void onFailure(MeasurementErrorResponse failureParcel) {
                        if (callback != null) {
                            executor.execute(() -> callback.onError(AdServicesStatusUtils.asException(failureParcel)));
                        }
                    }
                });
            }
            catch (RemoteException e) {
                LogUtil.e(e, "RemoteException");
                if (callback == null) break block3;
                executor.execute(() -> callback.onError(new IllegalStateException(e)));
            }
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_ATTRIBUTION")
    public void registerSource(@NonNull Uri attributionSource, @Nullable InputEvent inputEvent, @Nullable Executor executor, @Nullable OutcomeReceiver<Object, Exception> callback) {
        Objects.requireNonNull(attributionSource);
        MeasurementCompatibleManager.requireExecutorForCallback(executor, callback);
        IMeasurementService service = this.getServiceWrapper(executor, callback);
        if (service == null) {
            LogUtil.d("Measurement service not found");
            return;
        }
        RegistrationRequest.Builder builder = new RegistrationRequest.Builder(1, attributionSource, this.getAppPackageName(), this.getSdkPackageName()).setRequestTime(SystemClock.uptimeMillis()).setInputEvent(inputEvent);
        this.getAdId((isAdIdEnabled, adIdValue) -> this.register(builder.setAdIdPermissionGranted(isAdIdEnabled).setAdIdValue(adIdValue).build(), service, executor, callback));
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_ATTRIBUTION")
    public void registerSource(@NonNull SourceRegistrationRequest request, final @Nullable Executor executor, final @Nullable OutcomeReceiver<Object, Exception> callback) {
        Objects.requireNonNull(request);
        MeasurementCompatibleManager.requireExecutorForCallback(executor, callback);
        IMeasurementService service = this.getServiceWrapper(executor, callback);
        if (service == null) {
            LogUtil.d("Measurement service not found");
            return;
        }
        CallerMetadata callerMetadata = this.generateCallerMetadataWithCurrentTime();
        IMeasurementCallback.Stub measurementCallback = new IMeasurementCallback.Stub(this){

            @Override
            public void onResult() {
                if (callback != null) {
                    executor.execute(() -> callback.onResult(new Object()));
                }
            }

            @Override
            public void onFailure(MeasurementErrorResponse failureParcel) {
                if (callback != null) {
                    executor.execute(() -> callback.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            }
        };
        SourceRegistrationRequestInternal.Builder builder = new SourceRegistrationRequestInternal.Builder(request, this.getAppPackageName(), this.getSdkPackageName(), SystemClock.uptimeMillis());
        this.getAdId((isAdIdEnabled, adIdValue) -> {
            block2: {
                try {
                    LogUtil.d("Registering app sources");
                    service.registerSource(builder.setAdIdValue(adIdValue).build(), callerMetadata, measurementCallback);
                }
                catch (RemoteException e) {
                    LogUtil.e(e, "RemoteException");
                    if (callback == null) break block2;
                    executor.execute(() -> callback.onError(new IllegalStateException(e)));
                }
            }
        });
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_ATTRIBUTION")
    public void registerWebSource(@NonNull WebSourceRegistrationRequest request, final @Nullable Executor executor, final @Nullable OutcomeReceiver<Object, Exception> callback) {
        Objects.requireNonNull(request);
        MeasurementCompatibleManager.requireExecutorForCallback(executor, callback);
        IMeasurementService service = this.getServiceWrapper(executor, callback);
        if (service == null) {
            LogUtil.d("Measurement service not found");
            return;
        }
        CallerMetadata callerMetadata = this.generateCallerMetadataWithCurrentTime();
        IMeasurementCallback.Stub measurementCallback = new IMeasurementCallback.Stub(this){

            @Override
            public void onResult() {
                if (callback != null) {
                    executor.execute(() -> callback.onResult(new Object()));
                }
            }

            @Override
            public void onFailure(MeasurementErrorResponse failureParcel) {
                if (callback != null) {
                    executor.execute(() -> callback.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            }
        };
        WebSourceRegistrationRequestInternal.Builder builder = new WebSourceRegistrationRequestInternal.Builder(request, this.getAppPackageName(), this.getSdkPackageName(), SystemClock.uptimeMillis());
        this.getAdId((isAdIdEnabled, adIdValue) -> this.registerWebSourceWrapper(builder.setAdIdPermissionGranted(isAdIdEnabled).build(), service, executor, callerMetadata, measurementCallback, callback));
    }

    private void registerWebSourceWrapper(@NonNull WebSourceRegistrationRequestInternal request, @NonNull IMeasurementService service, @Nullable Executor executor, @NonNull CallerMetadata callerMetadata, @NonNull IMeasurementCallback measurementCallback, @Nullable OutcomeReceiver<Object, Exception> callback) {
        block2: {
            MeasurementCompatibleManager.requireExecutorForCallback(executor, callback);
            try {
                LogUtil.d("Registering web source");
                service.registerWebSource(request, callerMetadata, measurementCallback);
            }
            catch (RemoteException e) {
                LogUtil.e(e, "RemoteException");
                if (callback == null) break block2;
                executor.execute(() -> callback.onError(new IllegalStateException(e)));
            }
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_ATTRIBUTION")
    public void registerWebTrigger(@NonNull WebTriggerRegistrationRequest request, final @Nullable Executor executor, final @Nullable OutcomeReceiver<Object, Exception> callback) {
        Objects.requireNonNull(request);
        MeasurementCompatibleManager.requireExecutorForCallback(executor, callback);
        IMeasurementService service = this.getServiceWrapper(executor, callback);
        if (service == null) {
            LogUtil.d("Measurement service not found");
            return;
        }
        CallerMetadata callerMetadata = this.generateCallerMetadataWithCurrentTime();
        IMeasurementCallback.Stub measurementCallback = new IMeasurementCallback.Stub(this){

            @Override
            public void onResult() {
                if (callback != null) {
                    executor.execute(() -> callback.onResult(new Object()));
                }
            }

            @Override
            public void onFailure(MeasurementErrorResponse failureParcel) {
                if (callback != null) {
                    executor.execute(() -> callback.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            }
        };
        WebTriggerRegistrationRequestInternal.Builder builder = new WebTriggerRegistrationRequestInternal.Builder(request, this.getAppPackageName(), this.getSdkPackageName());
        this.getAdId((isAdIdEnabled, adIdValue) -> this.registerWebTriggerWrapper(builder.setAdIdPermissionGranted(isAdIdEnabled).build(), service, executor, callerMetadata, measurementCallback, callback));
    }

    private void registerWebTriggerWrapper(@NonNull WebTriggerRegistrationRequestInternal request, @NonNull IMeasurementService service, @Nullable Executor executor, @NonNull CallerMetadata callerMetadata, @NonNull IMeasurementCallback measurementCallback, @Nullable OutcomeReceiver<Object, Exception> callback) {
        block2: {
            MeasurementCompatibleManager.requireExecutorForCallback(executor, callback);
            try {
                LogUtil.d("Registering web trigger");
                service.registerWebTrigger(request, callerMetadata, measurementCallback);
            }
            catch (RemoteException e) {
                LogUtil.e(e, "RemoteException");
                if (callback == null) break block2;
                executor.execute(() -> callback.onError(new IllegalStateException(e)));
            }
        }
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_ATTRIBUTION")
    public void registerTrigger(@NonNull Uri trigger, @Nullable Executor executor, @Nullable OutcomeReceiver<Object, Exception> callback) {
        Objects.requireNonNull(trigger);
        MeasurementCompatibleManager.requireExecutorForCallback(executor, callback);
        IMeasurementService service = this.getServiceWrapper(executor, callback);
        if (service == null) {
            LogUtil.d("Measurement service not found");
            return;
        }
        RegistrationRequest.Builder builder = new RegistrationRequest.Builder(2, trigger, this.getAppPackageName(), this.getSdkPackageName());
        this.getAdId((isAdIdEnabled, adIdValue) -> this.register(builder.setAdIdPermissionGranted(isAdIdEnabled).setAdIdValue(adIdValue).build(), service, executor, callback));
    }

    private void deleteRegistrations(@NonNull DeletionParam deletionParam, final @NonNull Executor executor, final @NonNull OutcomeReceiver<Object, Exception> callback) {
        Objects.requireNonNull(deletionParam);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        IMeasurementService service = this.getServiceWrapper(executor, callback);
        if (service == null) {
            LogUtil.d("Measurement service not found");
            return;
        }
        try {
            service.deleteRegistrations(deletionParam, this.generateCallerMetadataWithCurrentTime(), new IMeasurementCallback.Stub(this){

                @Override
                public void onResult() {
                    executor.execute(() -> callback.onResult(new Object()));
                }

                @Override
                public void onFailure(MeasurementErrorResponse failureParcel) {
                    executor.execute(() -> callback.onError(AdServicesStatusUtils.asException(failureParcel)));
                }
            });
        }
        catch (RemoteException e) {
            LogUtil.e(e, "RemoteException");
            executor.execute(() -> callback.onError(new IllegalStateException(e)));
        }
    }

    public void deleteRegistrations(@NonNull DeletionRequest deletionRequest, @NonNull Executor executor, @NonNull OutcomeReceiver<Object, Exception> callback) {
        this.deleteRegistrations(new DeletionParam.Builder(deletionRequest.getOriginUris(), deletionRequest.getDomainUris(), deletionRequest.getStart(), deletionRequest.getEnd(), this.getAppPackageName(), this.getSdkPackageName()).setDeletionMode(deletionRequest.getDeletionMode()).setMatchBehavior(deletionRequest.getMatchBehavior()).build(), executor, callback);
    }

    @RequiresPermission(value="android.permission.ACCESS_ADSERVICES_ATTRIBUTION")
    public void getMeasurementApiStatus(final @NonNull Executor executor, final @NonNull OutcomeReceiver<Integer, Exception> callback) {
        IMeasurementService service;
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            service = this.getService();
        }
        catch (IllegalStateException e) {
            LogUtil.e(e, "Failed to bind to measurement service");
            executor.execute(() -> callback.onResult(0));
            return;
        }
        catch (RuntimeException e) {
            LogUtil.e(e, "Unknown failure while binding measurement service");
            executor.execute(() -> callback.onError(e));
            return;
        }
        try {
            service.getMeasurementApiStatus(new StatusParam.Builder(this.getAppPackageName(), this.getSdkPackageName()).build(), this.generateCallerMetadataWithCurrentTime(), new IMeasurementApiStatusCallback.Stub(this){

                @Override
                public void onResult(int result) {
                    executor.execute(() -> callback.onResult(result));
                }
            });
        }
        catch (RemoteException e) {
            LogUtil.e(e, "RemoteException");
            executor.execute(() -> callback.onResult(0));
        }
        catch (RuntimeException e) {
            LogUtil.e(e, "Unknown failure while getting measurement status");
            executor.execute(() -> callback.onError(e));
        }
    }

    @VisibleForTesting
    public void unbindFromService() {
        this.mServiceBinder.unbindFromService();
    }

    private String getAppPackageName() {
        SandboxedSdkContext sandboxedSdkContext = SandboxedSdkContextUtils.getAsSandboxedSdkContext(this.mContext);
        return sandboxedSdkContext == null ? this.mContext.getPackageName() : sandboxedSdkContext.getClientPackageName();
    }

    private String getSdkPackageName() {
        SandboxedSdkContext sandboxedSdkContext = SandboxedSdkContextUtils.getAsSandboxedSdkContext(this.mContext);
        return sandboxedSdkContext == null ? "" : sandboxedSdkContext.getSdkPackageName();
    }

    private CallerMetadata generateCallerMetadataWithCurrentTime() {
        return new CallerMetadata.Builder().setBinderElapsedTimestamp(SystemClock.elapsedRealtime()).build();
    }

    @Nullable
    private IMeasurementService getServiceWrapper(@Nullable Executor executor, @Nullable OutcomeReceiver<Object, Exception> callback) {
        IMeasurementService service;
        block2: {
            MeasurementCompatibleManager.requireExecutorForCallback(executor, callback);
            service = null;
            try {
                service = this.getService();
            }
            catch (RuntimeException e) {
                LogUtil.e(e, "Failed binding to measurement service");
                if (callback == null) break block2;
                executor.execute(() -> callback.onError(e));
            }
        }
        return service;
    }

    private static void requireExecutorForCallback(Executor executor, OutcomeReceiver<Object, Exception> callback) {
        if (callback != null && executor == null) {
            throw new IllegalArgumentException("Executor should be provided when callback is provided.");
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void getAdId(MeasurementAdIdCallback measurementAdIdCallback) {
        Trace.beginSection("MeasurementCompatibleManager#getAdId");
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicBoolean isAdIdEnabled = new AtomicBoolean();
        final AtomicReference adIdValue = new AtomicReference();
        this.mAdIdManager.getAdId(this.mAdIdExecutor, new OutcomeReceiver<AdId, Exception>(){

            @Override
            public void onResult(AdId adId) {
                isAdIdEnabled.set(MeasurementCompatibleManager.this.isAdIdPermissionEnabled(adId));
                adIdValue.set(adId.getAdId().equals("00000000-0000-0000-0000-000000000000") ? null : adId.getAdId());
                LogUtil.d("AdId permission enabled %b", isAdIdEnabled.get());
                countDownLatch.countDown();
            }

            @Override
            public void onError(Exception error) {
                boolean isExpected;
                boolean bl = isExpected = error instanceof IllegalStateException || error instanceof SecurityException;
                if (isExpected) {
                    LogUtil.w(MeasurementCompatibleManager.DEBUG_API_WARNING_MESSAGE);
                } else {
                    LogUtil.w(error, MeasurementCompatibleManager.DEBUG_API_WARNING_MESSAGE, new Object[0]);
                }
                countDownLatch.countDown();
            }
        });
        boolean timedOut = false;
        try {
            timedOut = !countDownLatch.await(400L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LogUtil.w(e, "InterruptedException while waiting for AdId", new Object[0]);
        }
        if (timedOut) {
            LogUtil.w("AdId call timed out");
        }
        Trace.endSection();
        measurementAdIdCallback.onAdIdCallback(isAdIdEnabled.get(), (String)adIdValue.get());
    }

    private static interface MeasurementAdIdCallback {
        public void onAdIdCallback(boolean var1, @Nullable String var2);
    }
}

