/*
 * Decompiled with CFR 0.152.
 */
package android.adservices.customaudience;

import android.adservices.common.AdData;
import android.adservices.common.AdSelectionSignals;
import android.adservices.common.AdTechIdentifier;
import android.adservices.common.ComponentAdData;
import android.adservices.customaudience.TrustedBiddingData;
import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.adservices.AdServicesParcelableUtil;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;
import java.util.List;
import java.util.Objects;

public class CustomAudience
implements Parcelable {
    public static final int FLAG_AUCTION_SERVER_REQUEST_DEFAULT = 0;
    public static final double PRIORITY_DEFAULT = 0.0;
    @FlaggedApi(value="com.android.adservices.flags.fledge_custom_audience_auction_server_request_flags_enabled")
    public static final int FLAG_AUCTION_SERVER_REQUEST_OMIT_ADS = 1;
    @NonNull
    private final AdTechIdentifier mBuyer;
    @NonNull
    private final String mName;
    @Nullable
    private final Instant mActivationTime;
    @Nullable
    private final Instant mExpirationTime;
    @NonNull
    private final Uri mDailyUpdateUri;
    @Nullable
    private final AdSelectionSignals mUserBiddingSignals;
    @Nullable
    private final TrustedBiddingData mTrustedBiddingData;
    @NonNull
    private final Uri mBiddingLogicUri;
    @NonNull
    private final List<AdData> mAds;
    @NonNull
    private final List<ComponentAdData> mComponentAds;
    private final int mAuctionServerRequestFlags;
    private final double mPriority;
    @NonNull
    public static final Parcelable.Creator<CustomAudience> CREATOR = new Parcelable.Creator<CustomAudience>(){

        @Override
        public CustomAudience createFromParcel(@NonNull Parcel in) {
            Objects.requireNonNull(in);
            return new CustomAudience(in);
        }

        public CustomAudience[] newArray(int size) {
            return new CustomAudience[size];
        }
    };

    private CustomAudience(@NonNull Builder builder) {
        Objects.requireNonNull(builder);
        this.mBuyer = builder.mBuyer;
        this.mName = builder.mName;
        this.mActivationTime = builder.mActivationTime;
        this.mExpirationTime = builder.mExpirationTime;
        this.mDailyUpdateUri = builder.mDailyUpdateUri;
        this.mUserBiddingSignals = builder.mUserBiddingSignals;
        this.mTrustedBiddingData = builder.mTrustedBiddingData;
        this.mBiddingLogicUri = builder.mBiddingLogicUri;
        this.mAds = builder.mAds;
        this.mComponentAds = builder.mComponentAds;
        this.mAuctionServerRequestFlags = builder.mAuctionServerRequestFlags;
        this.mPriority = builder.mPriority;
    }

    private CustomAudience(@NonNull Parcel in) {
        Objects.requireNonNull(in);
        this.mBuyer = AdTechIdentifier.CREATOR.createFromParcel(in);
        this.mName = in.readString();
        this.mActivationTime = AdServicesParcelableUtil.readNullableFromParcel(in, sourceParcel -> Instant.ofEpochMilli(sourceParcel.readLong()));
        this.mExpirationTime = AdServicesParcelableUtil.readNullableFromParcel(in, sourceParcel -> Instant.ofEpochMilli(sourceParcel.readLong()));
        this.mDailyUpdateUri = Uri.CREATOR.createFromParcel(in);
        this.mUserBiddingSignals = AdServicesParcelableUtil.readNullableFromParcel(in, AdSelectionSignals.CREATOR::createFromParcel);
        this.mTrustedBiddingData = AdServicesParcelableUtil.readNullableFromParcel(in, TrustedBiddingData.CREATOR::createFromParcel);
        this.mBiddingLogicUri = Uri.CREATOR.createFromParcel(in);
        this.mAds = in.createTypedArrayList(AdData.CREATOR);
        this.mComponentAds = in.createTypedArrayList(ComponentAdData.CREATOR);
        this.mAuctionServerRequestFlags = in.readInt();
        this.mPriority = in.readDouble();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Objects.requireNonNull(dest);
        this.mBuyer.writeToParcel(dest, flags);
        dest.writeString(this.mName);
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mActivationTime, (targetParcel, sourceInstant) -> targetParcel.writeLong(sourceInstant.toEpochMilli()));
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mExpirationTime, (targetParcel, sourceInstant) -> targetParcel.writeLong(sourceInstant.toEpochMilli()));
        this.mDailyUpdateUri.writeToParcel(dest, flags);
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mUserBiddingSignals, (targetParcel, sourceSignals) -> sourceSignals.writeToParcel(targetParcel, flags));
        AdServicesParcelableUtil.writeNullableToParcel(dest, this.mTrustedBiddingData, (targetParcel, sourceData) -> sourceData.writeToParcel(targetParcel, flags));
        this.mBiddingLogicUri.writeToParcel(dest, flags);
        dest.writeTypedList(this.mAds);
        dest.writeTypedList(this.mComponentAds);
        dest.writeInt(this.mAuctionServerRequestFlags);
        dest.writeDouble(this.mPriority);
    }

    public String toString() {
        return "CustomAudience{mBuyer=" + this.mBuyer + ", mName='" + this.mName + ", mActivationTime=" + this.mActivationTime + ", mExpirationTime=" + this.mExpirationTime + ", mDailyUpdateUri=" + this.mDailyUpdateUri + ", mUserBiddingSignals=" + this.mUserBiddingSignals + ", mTrustedBiddingData=" + this.mTrustedBiddingData + ", mBiddingLogicUri=" + this.mBiddingLogicUri + ", mAds=" + this.mAds + ", mComponentAds=" + this.mComponentAds + ", mAuctionServerRequestFlags=" + this.mAuctionServerRequestFlags + ", mPriority=" + this.mPriority + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    public AdTechIdentifier getBuyer() {
        return this.mBuyer;
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    @Nullable
    public Instant getActivationTime() {
        return this.mActivationTime;
    }

    @Nullable
    public Instant getExpirationTime() {
        return this.mExpirationTime;
    }

    @NonNull
    public Uri getDailyUpdateUri() {
        return this.mDailyUpdateUri;
    }

    @Nullable
    public AdSelectionSignals getUserBiddingSignals() {
        return this.mUserBiddingSignals;
    }

    @Nullable
    public TrustedBiddingData getTrustedBiddingData() {
        return this.mTrustedBiddingData;
    }

    @NonNull
    public Uri getBiddingLogicUri() {
        return this.mBiddingLogicUri;
    }

    @NonNull
    public List<AdData> getAds() {
        return this.mAds;
    }

    @FlaggedApi(value="com.android.adservices.flags.fledge_enable_custom_audience_component_ads")
    @NonNull
    public List<ComponentAdData> getComponentAds() {
        return this.mComponentAds;
    }

    @FlaggedApi(value="com.android.adservices.flags.fledge_custom_audience_auction_server_request_flags_enabled")
    public int getAuctionServerRequestFlags() {
        return this.mAuctionServerRequestFlags;
    }

    @FlaggedApi(value="com.android.adservices.flags.fledge_get_ad_selection_data_seller_configuration_enabled")
    public double getPriority() {
        return this.mPriority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomAudience)) {
            return false;
        }
        CustomAudience that = (CustomAudience)o;
        return this.mBuyer.equals(that.mBuyer) && this.mName.equals(that.mName) && Objects.equals(this.mActivationTime, that.mActivationTime) && Objects.equals(this.mExpirationTime, that.mExpirationTime) && ((Object)this.mDailyUpdateUri).equals(that.mDailyUpdateUri) && Objects.equals(this.mUserBiddingSignals, that.mUserBiddingSignals) && Objects.equals(this.mTrustedBiddingData, that.mTrustedBiddingData) && ((Object)this.mBiddingLogicUri).equals(that.mBiddingLogicUri) && this.mAds.equals(that.mAds) && this.mComponentAds.equals(that.mComponentAds) && this.mAuctionServerRequestFlags == that.mAuctionServerRequestFlags && Double.compare(this.mPriority, that.mPriority) == 0 && this.mComponentAds.equals(that.mComponentAds);
    }

    public int hashCode() {
        return Objects.hash(this.mBuyer, this.mName, this.mActivationTime, this.mExpirationTime, this.mDailyUpdateUri, this.mUserBiddingSignals, this.mTrustedBiddingData, this.mBiddingLogicUri, this.mAds, this.mComponentAds, this.mAuctionServerRequestFlags, this.mPriority);
    }

    public static class Builder {
        @Nullable
        private AdTechIdentifier mBuyer;
        @Nullable
        private String mName;
        @Nullable
        private Instant mActivationTime;
        @Nullable
        private Instant mExpirationTime;
        @Nullable
        private Uri mDailyUpdateUri;
        @Nullable
        private AdSelectionSignals mUserBiddingSignals;
        @Nullable
        private TrustedBiddingData mTrustedBiddingData;
        @Nullable
        private Uri mBiddingLogicUri;
        @Nullable
        private List<AdData> mAds;
        @Nullable
        private List<ComponentAdData> mComponentAds;
        private int mAuctionServerRequestFlags;
        private double mPriority;

        @NonNull
        public Builder setBuyer(@NonNull AdTechIdentifier buyer) {
            Objects.requireNonNull(buyer);
            this.mBuyer = buyer;
            return this;
        }

        @NonNull
        public Builder setName(@NonNull String name) {
            Objects.requireNonNull(name);
            this.mName = name;
            return this;
        }

        @NonNull
        public Builder setActivationTime(@Nullable Instant activationTime) {
            this.mActivationTime = activationTime;
            return this;
        }

        @NonNull
        public Builder setExpirationTime(@Nullable Instant expirationTime) {
            this.mExpirationTime = expirationTime;
            return this;
        }

        @NonNull
        public Builder setDailyUpdateUri(@NonNull Uri dailyUpdateUri) {
            Objects.requireNonNull(dailyUpdateUri);
            this.mDailyUpdateUri = dailyUpdateUri;
            return this;
        }

        @NonNull
        public Builder setUserBiddingSignals(@Nullable AdSelectionSignals userBiddingSignals) {
            this.mUserBiddingSignals = userBiddingSignals;
            return this;
        }

        @NonNull
        public Builder setTrustedBiddingData(@Nullable TrustedBiddingData trustedBiddingData) {
            this.mTrustedBiddingData = trustedBiddingData;
            return this;
        }

        @NonNull
        public Builder setBiddingLogicUri(@NonNull Uri biddingLogicUri) {
            Objects.requireNonNull(biddingLogicUri);
            this.mBiddingLogicUri = biddingLogicUri;
            return this;
        }

        @NonNull
        public Builder setAds(@Nullable List<AdData> ads) {
            this.mAds = ads;
            return this;
        }

        @FlaggedApi(value="com.android.adservices.flags.fledge_enable_custom_audience_component_ads")
        @NonNull
        public Builder setComponentAds(@NonNull List<ComponentAdData> componentAds) {
            this.mComponentAds = Objects.requireNonNull(componentAds, "The component ads provided are null");
            return this;
        }

        @FlaggedApi(value="com.android.adservices.flags.fledge_custom_audience_auction_server_request_flags_enabled")
        @NonNull
        public Builder setAuctionServerRequestFlags(int auctionServerRequestFlags) {
            this.mAuctionServerRequestFlags = auctionServerRequestFlags;
            return this;
        }

        @FlaggedApi(value="com.android.adservices.flags.fledge_get_ad_selection_data_seller_configuration_enabled")
        @NonNull
        public Builder setPriority(double priority) {
            this.mPriority = priority;
            return this;
        }

        @NonNull
        public CustomAudience build() {
            Objects.requireNonNull(this.mBuyer, "The buyer has not been provided");
            Objects.requireNonNull(this.mName, "The name has not been provided");
            Objects.requireNonNull(this.mDailyUpdateUri, "The daily update URI has not been provided");
            Objects.requireNonNull(this.mBiddingLogicUri, "The bidding logic URI has not been provided");
            if (this.mAds == null) {
                this.mAds = List.of();
            }
            if (this.mComponentAds == null) {
                this.mComponentAds = List.of();
            }
            return new CustomAudience(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AuctionServerRequestFlag {
    }
}

